/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.utils;

import java.util.Locale;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.MainFrame;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.utils.i18n.TranslationManager;

public class HeadlessGestion {
    private final ComptaPropsConfiguration comptaPropsConfiguration = ComptaPropsConfiguration.create();

    public HeadlessGestion setupGlobalState(int userId, int companyId) {
        System.setProperty("java.awt.headless", "true");
        TranslationManager.getInstance().addTranslationStreamFromClass(MainFrame.class);
        TranslationManager.getInstance().setLocale(Locale.getDefault());
        Configuration.setInstance(this.comptaPropsConfiguration);
        try {
            UserManager.getInstance().setCurrentUserID(userId);
            this.comptaPropsConfiguration.setUpSocieteDataBaseConnexion(companyId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Unable to configure connection for userId: " + userId + " companyId: " + companyId);
        }
        System.out.println("HeadlessOpenConcerto ready");
        System.out.println("Connected to " + this.comptaPropsConfiguration.getServerIp() + " on " + this.comptaPropsConfiguration.getSystemRootName() + "/" + this.comptaPropsConfiguration.getSocieteBaseName());
        return this;
    }

    public ComptaPropsConfiguration getComptaPropsConfiguration() {
        return this.comptaPropsConfiguration;
    }

    public DBRoot getCompanyRoot() {
        return this.comptaPropsConfiguration.getRootSociete();
    }

    public DBRoot getCommonRoot() {
        return this.comptaPropsConfiguration.getRoot();
    }
}

