/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.common.component.SocieteCommonSQLElement;
import org.openconcerto.erp.utils.ActionDB;
import org.openconcerto.erp.utils.StatusListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.ExceptionHandler;

public class ChargementCreationSocietePanel
extends JPanel
implements StatusListener {
    private JProgressBar progressBar = new JProgressBar();
    private JLabel label;

    public ChargementCreationSocietePanel(final int idSoc, final int typePCG) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        JLabelBold label1 = new JLabelBold("Cr\u00e9ation de la base de donn\u00e9es de la nouvelle soci\u00e9t\u00e9");
        this.add((Component)label1, c);
        ++c.gridy;
        JLabel label2 = new JLabel("Cette op\u00e9ration peut prendre plusieurs minutes.");
        this.add((Component)label2, c);
        ++c.gridy;
        this.label = new JLabel(" ");
        this.add((Component)this.label, c);
        ++c.gridy;
        this.add((Component)this.progressBar, c);
        this.progressBar.setIndeterminate(true);
        new Thread("Creation de societe"){

            @Override
            public void run() {
                try {
                    ChargementCreationSocietePanel.this.creationBase(idSoc);
                    ChargementCreationSocietePanel.this.statusChanged("Importation du plan comptable");
                    ChargementCreationSocietePanel.this.importationPlanComptable(idSoc, typePCG);
                    ChargementCreationSocietePanel.this.statusChanged("Cr\u00e9ation termin\u00e9e!");
                    ChargementCreationSocietePanel.this.progressBar.setIndeterminate(false);
                    ChargementCreationSocietePanel.this.progressBar.setString(null);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((JFrame)SwingUtilities.getRoot(ChargementCreationSocietePanel.this)).dispose();
                        }
                    });
                }
                catch (Throwable e) {
                    ExceptionHandler.handle("Erreur pendant la cr\u00e9ation de la base!", e);
                }
            }
        }.start();
    }

    private void creationBase(int id) throws SQLException {
        System.err.println("Cr\u00e9ation de la base");
        ActionDB.dupliqueDB("Default", "OpenConcerto" + id, this);
        this.statusChanged("Mise \u00e0 jour des soci\u00e9t\u00e9s");
        SQLRowValues rowVals = new SQLRowValues(Configuration.getInstance().getBase().getTable("SOCIETE_COMMON"));
        rowVals.put("DATABASE_NAME", "OpenConcerto" + id);
        rowVals.update(id);
    }

    private void importationPlanComptable(int id, int typePCG) {
        SQLRow rowSociete = Configuration.getInstance().getBase().getTable("SOCIETE_COMMON").getRow(id);
        final DBRoot baseNewSociete = SocieteCommonSQLElement.getRoot(rowSociete);
        SQLTable tableComptePCG = baseNewSociete.getTable("COMPTE_PCG");
        final SQLSelect sel = new SQLSelect();
        sel.addSelect(tableComptePCG.getField("NUMERO"));
        sel.addSelect(tableComptePCG.getField("NOM"));
        sel.addSelect(tableComptePCG.getField("INFOS"));
        if (typePCG == 0) {
            sel.setWhere(new Where((FieldRef)tableComptePCG.getField("ID_TYPE_COMPTE_PCG_BASE"), "!=", 1));
        } else if (typePCG == 1) {
            sel.setWhere(new Where((FieldRef)tableComptePCG.getField("ID_TYPE_COMPTE_PCG_AB"), "!=", 1));
        }
        try {
            baseNewSociete.getBase().getDataSource().useConnection(new ConnectionHandlerNoSetup<Object, SQLException>(){

                @Override
                public Object handle(SQLDataSource ds) throws SQLException, SQLException {
                    String insert = "INSERT INTO " + new SQLName(baseNewSociete.getName(), "COMPTE_PCE").quote() + " (\"NUMERO\", \"NOM\", \"INFOS\") VALUES (?, ?, ?)";
                    PreparedStatement stmt = ds.getConnection().prepareStatement(insert);
                    List tmpCpt = baseNewSociete.getBase().getDataSource().execute(sel.asString());
                    int i = 0;
                    while (i < tmpCpt.size()) {
                        Map tmp = (Map)tmpCpt.get(i);
                        String numero = tmp.get("NUMERO") == null ? "" : tmp.get("NUMERO").toString();
                        stmt.setString(1, numero);
                        String nom = tmp.get("NOM") == null ? "" : tmp.get("NOM").toString();
                        stmt.setString(2, nom);
                        String infos = tmp.get("INFOS") == null ? "" : tmp.get("INFOS").toString();
                        stmt.setString(3, infos);
                        stmt.executeUpdate();
                        ++i;
                    }
                    return null;
                }
            });
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void statusChanged(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChargementCreationSocietePanel.this.label.setText(message);
            }
        });
    }
}

