/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.logging.Level;
import javax.swing.table.AbstractTableModel;
import net.jcip.annotations.Immutable;
import org.openconcerto.erp.config.Log;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.Dependency;
import org.openconcerto.erp.modules.InstallationState;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.modules.ModuleReference;
import org.openconcerto.erp.modules.ModuleVersion;

public class ModuleTableModel
extends AbstractTableModel {
    private static final EnumSet<Columns> BOOLEAN_COLS = EnumSet.of(Columns.CB, Columns.LOCAL, Columns.REMOTE, Columns.DB_REQUIRED, Columns.ADMIN_REQUIRED);
    private List<ModuleRow> list;
    private final Set<ModuleRow> selection = new HashSet<ModuleRow>();
    private boolean valid = false;

    private static final boolean areDepsMet(ModuleFactory factory, InstallationState installationState) {
        for (Dependency dep : factory.getDependencies().values()) {
            boolean depMet = false;
            for (String reqID : dep.getRequiredIDs()) {
                ModuleFactory f = installationState.getInstalledFactories().get(reqID);
                if (f == null || !dep.isRequiredFactoryOK(f)) continue;
                depMet = true;
                break;
            }
            if (depMet) continue;
            return false;
        }
        return true;
    }

    public ModuleTableModel() {
        this.list = Collections.emptyList();
    }

    final void clear() {
        this.selection.clear();
        this.list = Collections.emptyList();
        this.fireTableDataChanged();
    }

    public final void reload() throws IOException, SQLException {
        ModuleManager mngr = ModuleManager.getInstance();
        InstallationState installationState = new InstallationState(mngr);
        HashMap<ModuleReference, ModuleFactory> available = new HashMap<ModuleReference, ModuleFactory>();
        for (Map.Entry<String, SortedMap<ModuleVersion, ModuleFactory>> e : mngr.getFactories().entrySet()) {
            for (Map.Entry<ModuleVersion, ModuleFactory> e2 : e.getValue().entrySet()) {
                available.put(new ModuleReference(e.getKey(), e2.getKey()), e2.getValue());
            }
        }
        List<ModuleReference> adminRequired = mngr.getAdminRequiredModules(true);
        List<ModuleReference> dbRequired = mngr.getDBRequiredModules();
        HashSet<ModuleReference> running = new HashSet<ModuleReference>();
        for (Map.Entry<String, AbstractModule> e : mngr.getRunningModules().entrySet()) {
            running.add(new ModuleReference(e.getKey(), e.getValue().getFactory().getVersion()));
        }
        Set<ModuleReference> registered = mngr.getRegisteredModules();
        this.valid = true;
        HashSet<ModuleReference> s = new HashSet<ModuleReference>(installationState.getLocalOrRemote());
        s.addAll(available.keySet());
        ArrayList<ModuleRow> l = new ArrayList<ModuleRow>(s.size());
        for (ModuleReference ref : s) {
            ModuleRow row = new ModuleRow(ref, (ModuleFactory)available.get(ref), installationState, registered.contains(ref), running.contains(ref), dbRequired.contains(ref), adminRequired.contains(ref));
            l.add(row);
            this.valid &= row.getProblems().size() == 0;
        }
        Collections.sort(l, new Comparator<ModuleRow>(){

            @Override
            public int compare(ModuleRow r1, ModuleRow r2) {
                ModuleReference o1 = r1.getRef();
                ModuleReference o2 = r2.getRef();
                return ModuleReference.COMP_ID_ASC_VERSION_DESC.compare(o1, o2);
            }
        });
        this.list = Collections.unmodifiableList(l);
        this.selection.retainAll(this.list);
        this.fireTableDataChanged();
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final Collection<ModuleRow> getCheckedRows() {
        return Collections.unmodifiableSet(this.selection);
    }

    @Override
    public int getColumnCount() {
        return Columns.values().length;
    }

    @Override
    public final int getRowCount() {
        return this.list.size();
    }

    protected final ModuleRow getFactory(int i) {
        return this.list.get(i);
    }

    protected final ModuleRow getRow(ModuleReference ref) {
        if (ref.getVersion() == null) {
            throw new IllegalStateException("Null version");
        }
        for (ModuleRow r : this.list) {
            if (!r.getRef().equals(ref)) continue;
            return r;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == Columns.CB.ordinal();
    }

    @Override
    public String getColumnName(int column) {
        Columns col = Columns.values()[column];
        switch (col) {
            case NAME: {
                return "Nom";
            }
            case VERSION: {
                return "Version";
            }
            case STATE: {
                return "Etat";
            }
            case LOCAL: {
                return "Install\u00e9 sur le poste";
            }
            case REMOTE: {
                return "Install\u00e9 sur le serveur";
            }
            case DB_REQUIRED: {
                return "Requis par le syst\u00e8me";
            }
            case ADMIN_REQUIRED: {
                return "Requis par l'administrateur";
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ModuleRow f = this.getFactory(rowIndex);
        Columns col = Columns.values()[columnIndex];
        try {
            switch (col) {
                case CB: {
                    return this.selection.contains(f);
                }
                case NAME: {
                    return f.getName();
                }
                case VERSION: {
                    return f.getRef().getVersion();
                }
                case STATE: {
                    String s = f.isRunning() ? "D\u00e9marr\u00e9" : (f.isRegistered() ? "Charg\u00e9" : (f.isAvailable() ? "Disponible" : "Non disponible"));
                    Set<Problem> pbs = f.getProblems();
                    if (pbs.size() == 0) {
                        return s;
                    }
                    StringBuilder sb = new StringBuilder(64);
                    sb.append("<html><body>");
                    sb.append(s);
                    sb.append(" <font bgcolor=\"RED\" color=\"WHITE\">&nbsp;");
                    if (pbs.contains((Object)Problem.REQUIRED_MISSING)) {
                        sb.append("Module&nbsp;requis ");
                    }
                    if (pbs.contains((Object)Problem.MISSING_DEP)) {
                        sb.append("D\u00e9pendances&nbsp;manquantes ");
                    }
                    sb.append("</font></body></html>");
                    return sb.toString();
                }
                case LOCAL: {
                    return f.isInstalledLocally();
                }
                case REMOTE: {
                    return f.isInstalledRemotely();
                }
                case DB_REQUIRED: {
                    return f.isDBRequired();
                }
                case ADMIN_REQUIRED: {
                    return f.isAdminRequired();
                }
            }
            return "";
        }
        catch (Exception e) {
            Log.get().log(Level.SEVERE, "row:" + rowIndex + " column:" + columnIndex, e);
            return e.getMessage();
        }
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (columnIndex == Columns.CB.ordinal()) {
            if (((Boolean)value).booleanValue()) {
                this.selection.add(this.getFactory(rowIndex));
            } else {
                this.selection.remove(this.getFactory(rowIndex));
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (BOOLEAN_COLS.contains((Object)Columns.values()[columnIndex])) {
            return Boolean.class;
        }
        if (columnIndex == Columns.VERSION.ordinal()) {
            return ModuleVersion.class;
        }
        return String.class;
    }

    static enum Columns {
        CB,
        NAME,
        VERSION,
        STATE,
        LOCAL,
        REMOTE,
        DB_REQUIRED,
        ADMIN_REQUIRED;

    }

    @Immutable
    static final class ModuleRow {
        private final ModuleReference ref;
        private final ModuleFactory factory;
        private final boolean local;
        private final boolean remote;
        private final boolean registered;
        private final boolean running;
        private final boolean dbRequired;
        private final boolean adminRequired;
        private final Set<Problem> problems;

        public ModuleRow(ModuleReference ref, ModuleFactory f, InstallationState installationState, boolean registered, boolean running, boolean dbRequired, boolean adminRequired) {
            boolean isInstalled;
            if (ref == null) {
                throw new NullPointerException("Null reference");
            }
            this.ref = ref;
            this.factory = f;
            assert (this.factory == null || this.factory.getReference().equals(this.ref));
            this.local = installationState.getLocal().contains(ref);
            this.remote = installationState.getRemote().contains(ref);
            this.registered = registered;
            this.running = running;
            this.dbRequired = dbRequired;
            this.adminRequired = adminRequired;
            HashSet<Problem> pbs = new HashSet<Problem>(Problem.values().length);
            boolean bl = isInstalled = this.isInstalledLocally() || this.isInstalledRemotely();
            if (!this.isAvailable() && isInstalled) {
                pbs.add(Problem.REQUIRED_MISSING);
            }
            if (this.isAvailable() && isInstalled && !ModuleTableModel.areDepsMet(this.factory, installationState)) {
                pbs.add(Problem.MISSING_DEP);
            }
            this.problems = pbs.size() == 0 ? Collections.emptySet() : Collections.unmodifiableSet(pbs);
        }

        public ModuleReference getRef() {
            return this.ref;
        }

        public final String getName() {
            return this.factory != null ? this.factory.getName() : this.getRef().getID();
        }

        public boolean isAvailable() {
            return this.factory != null;
        }

        public boolean isInstalledLocally() {
            return this.local;
        }

        public boolean isInstalledRemotely() {
            return this.remote;
        }

        public boolean isRegistered() {
            return this.registered;
        }

        public boolean isRunning() {
            return this.running;
        }

        public boolean isDBRequired() {
            return this.dbRequired;
        }

        public boolean isAdminRequired() {
            return this.adminRequired;
        }

        public Set<Problem> getProblems() {
            return this.problems;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.ref.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModuleRow other = (ModuleRow)obj;
            return this.ref.equals(other.ref);
        }
    }

    public static enum Problem {
        REQUIRED_MISSING,
        MISSING_DEP;

    }
}

