/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.injector;

import java.math.BigDecimal;
import java.util.Collection;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class CommandeBrSQLInjector
extends SQLInjector {
    public CommandeBrSQLInjector(DBRoot root) {
        super(root, "COMMANDE", "BON_RECEPTION", true);
        SQLTable tableCmd = this.getSource();
        SQLTable tableBr = this.getDestination();
        this.map(tableCmd.getField("ID_FOURNISSEUR"), tableBr.getField("ID_FOURNISSEUR"));
        this.map(tableCmd.getField("NOM"), tableBr.getField("NOM"));
        if (tableCmd.contains("REMISE_HT")) {
            this.map(tableCmd.getField("T_POIDS"), tableBr.getField("TOTAL_POIDS"));
            this.map(tableCmd.getField("REMISE_HT"), tableBr.getField("REMISE_HT"));
            this.map(tableCmd.getField("PORT_HT"), tableBr.getField("PORT_HT"));
            this.map(tableCmd.getField("ID_TAXE_PORT"), tableBr.getField("ID_TAXE_PORT"));
        }
        this.map(tableCmd.getField("INFOS"), tableBr.getField("INFOS"));
        this.map(tableCmd.getField("ID"), tableBr.getField("ID_COMMANDE"));
        if (tableBr.contains("CREATE_VIRTUAL_STOCK")) {
            this.mapDefaultValues(tableBr.getField("CREATE_VIRTUAL_STOCK"), Boolean.FALSE);
        }
    }

    @Override
    protected void merge(SQLRowAccessor srcRow, SQLRowValues rowVals) {
        super.merge(srcRow, rowVals);
        SQLTable tableElementSource = this.getSource().getTable("COMMANDE_ELEMENT");
        SQLTable tableElementDestination = this.getSource().getTable("BON_RECEPTION_ELEMENT");
        Collection myListItem = srcRow.asRow().getReferentRows(tableElementSource);
        if (myListItem.size() != 0) {
            SQLInjector injector = SQLInjector.getInjector(tableElementSource, tableElementDestination);
            for (SQLRowAccessor rowElt : myListItem) {
                SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(rowElt.asRow());
                createRowValuesFrom.put("QTE_ORIGINE", createRowValuesFrom.getObject("QTE"));
                if (createRowValuesFrom.getTable().getFieldsName().contains("POURCENT_ACOMPTE") && createRowValuesFrom.getObject("POURCENT_ACOMPTE") == null) {
                    createRowValuesFrom.put("POURCENT_ACOMPTE", new BigDecimal(100.0));
                }
                createRowValuesFrom.put("ID_BON_RECEPTION", (Object)rowVals);
            }
        }
    }
}

