/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.openconcerto.erp.core.common.element.BanqueSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class GenerationReglementAchat
extends GenerationEcritures {
    private static final Integer journalCaisse = new Integer(5);
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLTable tableMouvement = base.getTable("MOUVEMENT");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationReglementAchat(int idRegMontant) throws Exception {
        SQLRow regMontantRow = base.getTable("REGLER_MONTANT").getRow(idRegMontant);
        SQLRow rowFournisseur = regMontantRow.getForeign("ID_FOURNISSEUR");
        System.err.println("G\u00e9n\u00e9ration des ecritures du reglement du mouvement " + this.idMvt);
        SQLRow modeRegRow = base.getTable("MODE_REGLEMENT").getRow(regMontantRow.getInt("ID_MODE_REGLEMENT"));
        SQLRow typeRegRow = base.getTable("TYPE_REGLEMENT").getRow(modeRegRow.getInt("ID_TYPE_REGLEMENT"));
        System.err.println("Mode de reglement " + regMontantRow.getInt("ID_MODE_REGLEMENT"));
        PrixTTC prixTTC = new PrixTTC((Long)regMontantRow.getObject("MONTANT"));
        this.date = (Date)regMontantRow.getObject("DATE");
        this.nom = "R\u00e8glement achat " + rowFournisseur.getString("NOM") + " (" + typeRegRow.getString("NOM") + ")";
        Collection l = regMontantRow.getReferentRows(regMontantRow.getTable().getTable("REGLER_MONTANT_ELEMENT"));
        int mvtSource = -1;
        for (SQLRow sqlRow : l) {
            SQLRow mvtEch = sqlRow.getForeignRow("ID_MOUVEMENT_ECHEANCE");
            if (mvtEch.getID() == mvtSource) continue;
            this.getNewMouvement("REGLER_MONTANT", idRegMontant, mvtEch.getID(), mvtEch.getInt("ID_PIECE"));
            if (mvtSource != -1) continue;
            mvtSource = mvtEch.getID();
        }
        SQLRow rowMvtSource = tableMouvement.getRow(mvtSource);
        if (modeRegRow.getInt("AJOURS") == 0 && modeRegRow.getInt("LENJOUR") == 0) {
            System.err.println("R\u00e8glement Comptant");
            if (typeRegRow.getID() == 2) {
                this.paiementCheque(this.date, rowMvtSource, rowFournisseur.getID(), idRegMontant);
            } else {
                if (typeRegRow.getID() == 4) {
                    this.putValue("ID_JOURNAL", journalCaisse);
                } else {
                    this.fillJournalBanqueFromRow(modeRegRow);
                }
                this.idMvt = this.getNewMouvement("REGLER_MONTANT", idRegMontant, rowMvtSource.getID(), rowMvtSource.getInt("ID_PIECE"));
                this.putValue("DATE", this.date);
                this.putValue("NOM", this.nom);
                this.putValue("ID_MOUVEMENT", new Integer(this.idMvt));
                int idCompteFourn = rowFournisseur.getInt("ID_COMPTE_PCE");
                if (idCompteFourn <= 1 && (idCompteFourn = rowPrefsCompte.getInt("ID_COMPTE_PCE_FOURNISSEUR")) <= 1) {
                    idCompteFourn = ComptePCESQLElement.getIdComptePceDefault("Fournisseurs");
                }
                this.putValue("ID_COMPTE_PCE", new Integer(idCompteFourn));
                this.putValue("DEBIT", new Long(prixTTC.getLongValue()));
                this.putValue("CREDIT", new Long(0L));
                this.ajoutEcriture();
                this.fillCompteBanqueFromRow(modeRegRow, "AchatCB", true);
                this.putValue("DEBIT", new Long(0L));
                this.putValue("CREDIT", new Long(prixTTC.getLongValue()));
                this.ajoutEcriture();
            }
        } else {
            Date dateEch = ModeDeReglementSQLElement.calculDate(modeRegRow.getInt("AJOURS"), modeRegRow.getInt("LENJOUR"), this.date);
            SimpleDateFormat dateFormat = new SimpleDateFormat();
            System.out.println("Date d'\u00e9ch\u00e9ance " + dateFormat.format(dateEch));
            if (typeRegRow.getID() == 2) {
                this.paiementCheque(dateEch, rowMvtSource, rowFournisseur.getID(), idRegMontant);
            } else {
                HashMap<String, Comparable<Integer>> mEcheance = new HashMap<String, Comparable<Integer>>();
                this.idMvt = this.getNewMouvement("ECHEANCE_FOURNISSEUR", 1, rowMvtSource.getID(), rowMvtSource.getInt("ID_PIECE"));
                mEcheance.put("ID_MOUVEMENT", new Integer(this.idMvt));
                mEcheance.put("DATE", dateEch);
                mEcheance.put("MONTANT", new Long(prixTTC.getLongValue()));
                mEcheance.put("ID_FOURNISSEUR", Integer.valueOf(rowFournisseur.getID()));
                SQLRowValues valEcheance = new SQLRowValues(base.getTable("ECHEANCE_FOURNISSEUR"), mEcheance);
                if (valEcheance.getInvalid() == null) {
                    SQLRow row = valEcheance.insert();
                    SQLRowValues rowVals = new SQLRowValues(tableMouvement);
                    rowVals.put("IDSOURCE", row.getID());
                    rowVals.update(this.idMvt);
                }
            }
        }
    }

    private void paiementCheque(Date dateEch, SQLRow rowMvtSource, int idFourn, int idRegMontant) throws SQLException {
        SQLRow regMontantRow = base.getTable("REGLER_MONTANT").getRow(idRegMontant);
        PrixTTC prixTTC = new PrixTTC((Long)regMontantRow.getObject("MONTANT"));
        SQLRowValues valCheque = new SQLRowValues(base.getTable("CHEQUE_FOURNISSEUR"));
        valCheque.put("ID_FOURNISSEUR", idFourn);
        valCheque.put("DATE_ACHAT", this.date);
        valCheque.put("DATE_MIN_DECAISSE", dateEch);
        if (!regMontantRow.isForeignEmpty("ID_MODE_REGLEMENT")) {
            SQLRow rowModeRegl = regMontantRow.getForeignRow("ID_MODE_REGLEMENT");
            valCheque.put("ID_" + BanqueSQLElement.TABLENAME, rowModeRegl.getInt("ID_" + BanqueSQLElement.TABLENAME));
        }
        this.idMvt = this.getNewMouvement("CHEQUE_FOURNISSEUR", 1, rowMvtSource.getID(), rowMvtSource.getInt("ID_PIECE"));
        valCheque.put("ID_MOUVEMENT", new Integer(this.idMvt));
        valCheque.put("MONTANT", new Long(prixTTC.getLongValue()));
        if (valCheque.getInvalid() == null) {
            SQLRow row = valCheque.insert();
            SQLRowValues rowVals = new SQLRowValues(tableMouvement);
            rowVals.put("IDSOURCE", row.getID());
            rowVals.update(this.idMvt);
        }
    }
}

