/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class GenerationMvtReglementChequeClient
extends GenerationEcritures {
    private long montant;
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
    private int idCheque;
    private SQLRowAccessor banque;

    public GenerationMvtReglementChequeClient(int idMvt, long montant, Date d, int idCheque, String s, SQLRowAccessor banque) {
        this.montant = montant;
        this.date = d;
        this.idMvt = idMvt;
        this.idCheque = idCheque;
        this.banque = banque;
        SQLRow chequeRow = base.getTable("CHEQUE_A_ENCAISSER").getRow(this.idCheque);
        String num = "";
        if (chequeRow != null && !chequeRow.isUndefined() && chequeRow.getString("NUMERO").trim().length() > 0) {
            num = " N\u00b0 " + chequeRow.getString("NUMERO");
        }
        this.nom = s != null && s.trim().length() > 0 ? String.valueOf(s) + (num.trim().length() > 0 ? " - Cheque" + num : "") : "Reglement cheque client" + num;
    }

    public void genere() throws Exception {
        System.err.println("g\u00e9n\u00e9ration des ecritures de r\u00e8glement d'un cheque client du mouvement " + this.idMvt);
        SQLRow chequeRow = base.getTable("CHEQUE_A_ENCAISSER").getRow(this.idCheque);
        SQLRow clientRow = base.getTable("CLIENT").getRow(chequeRow.getInt("ID_CLIENT"));
        this.putValue("DATE", new java.sql.Date(this.date.getTime()));
        this.putValue("NOM", this.nom);
        this.putValue("ID_MOUVEMENT", new Integer(this.idMvt));
        if (this.banque == null || this.banque.isUndefined() || this.banque.isForeignEmpty("ID_JOURNAL")) {
            this.fillJournalBanqueFromRow(chequeRow);
        } else {
            int idJrnl = this.banque.getForeignID("ID_JOURNAL");
            this.putValue("ID_JOURNAL", idJrnl);
        }
        this.setDateReglement(this.idCheque, this.date);
        int idCompteClient = -1;
        if (chequeRow.getBoolean("SANS_VALEUR_ENCAISSEMENT").booleanValue()) {
            if (clientRow != null) {
                idCompteClient = clientRow.getInt("ID_COMPTE_PCE");
            }
            if (idCompteClient <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
                idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
            }
        } else {
            idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_VALEUR_ENCAISSEMENT");
            if (idCompteClient <= 1) {
                idCompteClient = ComptePCESQLElement.getIdComptePceDefault("ValeurEncaissement");
            }
        }
        this.putValue("ID_COMPTE_PCE", new Integer(idCompteClient));
        this.putValue("DEBIT", new Long(0L));
        this.putValue("CREDIT", new Long(this.montant));
        this.ajoutEcriture();
        System.err.println("First ECriture for mvt " + this.idMvt);
        this.fillCompteBanqueFromRow(chequeRow, "VenteCheque", false);
        this.putValue("DEBIT", new Long(this.montant));
        this.putValue("CREDIT", new Long(0L));
        this.ajoutEcriture();
        System.err.println("Ecritures g\u00e9n\u00e9r\u00e9es pour le mouvement " + this.idMvt);
    }

    private void setDateReglement(int idCheque, Date d) throws SQLException {
        if (idCheque > 1) {
            SQLRow chequeRow = Configuration.getInstance().getBase().getTable("CHEQUE_A_ENCAISSER").getRow(idCheque);
            int sourceId = MouvementSQLElement.getSourceId(chequeRow.getInt("ID_MOUVEMENT"));
            SQLRow rowMvt = Configuration.getInstance().getBase().getTable("MOUVEMENT").getRow(sourceId);
            if (rowMvt.getString("SOURCE").equalsIgnoreCase("SAISIE_VENTE_FACTURE")) {
                SQLElement eltFacture = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
                SQLRow saisieRow = eltFacture.getTable().getRow(rowMvt.getInt("IDSOURCE"));
                SQLRowValues rowValsUpdateVF = saisieRow.createEmptyUpdateRow();
                rowValsUpdateVF.put("DATE_REGLEMENT", new Timestamp(d.getTime()));
                rowValsUpdateVF.update();
            }
        }
    }
}

