/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.supplier.element;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.edm.AttachmentAction;
import org.openconcerto.erp.core.supplychain.supplier.component.FournisseurSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;

public class FournisseurSQLElement
extends ComptaSQLConfElement {
    public FournisseurSQLElement() {
        super("FOURNISSEUR", "un fournisseur", "fournisseurs");
        RowAction.PredicateRowAction actionAttachment = new RowAction.PredicateRowAction(new AttachmentAction().getAction(), true);
        actionAttachment.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(actionAttachment);
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        l.add("TYPE");
        l.add("TEL");
        l.add("FAX");
        l.add("ID_MODE_REGLEMENT");
        l.add("ID_COMPTE_PCE");
        l.add("ID_ADRESSE");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        l.add("CODE");
        return l;
    }

    @Override
    protected void _initComboRequest(ComboSQLRequest req) {
        super._initComboRequest(req);
        req.addToGraphToFetch("UE");
        req.addForeignToGraphToFetch("ID_COMPTE_PCE_CHARGE", Arrays.asList("ID", "NUMERO"));
        req.keepRows(ComboSQLRequest.KeepMode.GRAPH);
    }

    @Override
    protected void _initListRequest(ListSQLRequest req) {
        super._initListRequest(req);
        req.addForeignToGraphToFetch("ID_MODE_REGLEMENT", Arrays.asList("AJOURS", "LENJOUR", "DATE_FACTURE", "COMPTANT"));
    }

    @Override
    public SQLComponent createComponent() {
        return new FournisseurSQLComponent(this);
    }
}

