/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.action;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.state.WindowStateManager;
import org.openconcerto.utils.cc.ITransformer;

public class ListeDesElementsACommanderAction
extends CreateFrameAbstractAction {
    private BaseSQLTableModelColumn colAvancement;

    public ListeDesElementsACommanderAction() {
        this.putValue("Name", "Liste des \u00e9l\u00e9ments en attente de r\u00e9ception");
    }

    @Override
    public JFrame createFrame() {
        JFrame frame = new JFrame("El\u00e9ments \u00e0 r\u00e9ceptionner");
        SQLElement eltCmd = Configuration.getInstance().getDirectory().getElement("COMMANDE_ELEMENT");
        JPanel orderPanel = this.createPanel();
        frame.getContentPane().add(orderPanel);
        FrameUtil.setBounds(frame);
        File file = IListFrame.getConfigFile(eltCmd, frame.getClass());
        if (file != null) {
            new WindowStateManager(frame, file).loadState();
        }
        return frame;
    }

    JPanel createPanel() {
        final SQLElement eltCmd = Configuration.getInstance().getDirectory().getElement("COMMANDE_ELEMENT");
        SQLTableModelSourceOnline tableSource = eltCmd.getTableSource(true);
        tableSource.getReq().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                String quoteQteL = new SQLName(input.getAlias(eltCmd.getTable()).getAlias(), "QTE_RECUE").quote();
                String quoteQte = new SQLName(input.getAlias(eltCmd.getTable()).getAlias(), "QTE").quote();
                String quoteQteU = new SQLName(input.getAlias(eltCmd.getTable()).getAlias(), "QTE_UNITAIRE").quote();
                Where w = Where.createRaw(String.valueOf(quoteQteL) + " < (" + quoteQte + "*" + quoteQteU + ")", eltCmd.getTable().getField("QTE_RECUE"), eltCmd.getTable().getField("QTE"), eltCmd.getTable().getField("QTE_UNITAIRE"));
                input.setWhere(w);
                return input;
            }
        });
        ListeAddPanel panel = this.getPanel(eltCmd, tableSource);
        return panel;
    }

    private ListeAddPanel getPanel(SQLElement eltCmd, SQLTableModelSourceOnline tableSource) {
        ListeAddPanel panel = new ListeAddPanel(eltCmd, new IListe(tableSource));
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.fill = 1;
        c.anchor = 13;
        c.weightx = 1.0;
        c.gridy = 4;
        IListFilterDatePanel datePanel = new IListFilterDatePanel(panel.getListe(), eltCmd.getTable().getForeignTable("ID_COMMANDE").getField("DATE"), IListFilterDatePanel.getDefaultMap());
        datePanel.setFilterOnDefault();
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridBagLayout());
        bottomPanel.setOpaque(false);
        DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
        c2.fill = 0;
        c2.weightx = 1.0;
        bottomPanel.add((Component)datePanel, c2);
        panel.add((Component)bottomPanel, c);
        return panel;
    }
}

