/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.sales.invoice.ui.FactureAffacturerTable;
import org.openconcerto.erp.core.supplychain.receipt.component.BonReceptionSQLComponent;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.EditPanelListener;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class ReliquatSQLElement
extends ComptaSQLConfElement {
    private final String tableBonName;

    public ReliquatSQLElement(String tableName, String singularName, String pluralName, final String tableBonName) {
        super(tableName, singularName, pluralName);
        this.tableBonName = tableBonName;
        RowAction.PredicateRowAction actionTR = new RowAction.PredicateRowAction(new AbstractAction("Transfert vers Bon"){

            @Override
            public void actionPerformed(ActionEvent e) {
                final List<SQLRowValues> rows = IListe.get(e).getSelectedRows();
                EditFrame frame = new EditFrame(ReliquatSQLElement.this.getForeignElement("ID_" + tableBonName), EditPanel.EditMode.CREATION);
                frame.addEditPanelListener(new EditPanelListener(){

                    @Override
                    public void modified() {
                    }

                    @Override
                    public void inserted(int id) {
                        for (SQLRowValues rowVals : rows) {
                            try {
                                SQLRowValues upRowVals = rowVals.createEmptyUpdateRow();
                                upRowVals.put("ID_" + tableBonName, id);
                                upRowVals.update();
                            }
                            catch (SQLException exn) {
                                exn.printStackTrace();
                            }
                        }
                    }

                    @Override
                    public void deleted() {
                    }

                    @Override
                    public void cancelled() {
                    }
                });
                SQLComponent comp = frame.getSQLComponent();
                if (comp instanceof BonReceptionSQLComponent) {
                    ((BonReceptionSQLComponent)comp).loadFromReliquat(rows);
                }
                frame.setVisible(true);
            }
        }, true);
        actionTR.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        this.getRowActions().add(actionTR);
    }

    public ReliquatSQLElement() {
        this("RELIQUAT_BL", "un reliquat de BL", "reliquats de BL", "BON_DE_LIVRAISON");
    }

    @Override
    protected String getParentFFName() {
        return "ID_" + this.tableBonName;
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_" + this.tableBonName + "_ORIGINE");
        l.add("ID_ARTICLE");
        l.add("QTE_UNITAIRE");
        l.add("ID_UNITE_VENTE");
        l.add("QTE");
        l.add("ID_" + this.tableBonName);
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("QTE");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            FactureAffacturerTable table;
            {
                this.table = new FactureAffacturerTable(null);
            }

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                this.add((Component)new JLabel(this.getLabelFor("NB_FACT")), c);
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".reliquatbl";
    }

    public static class ReliquatBRSQLElement
    extends ReliquatSQLElement {
        public ReliquatBRSQLElement() {
            super("RELIQUAT_BR", "un reliquat de BR", "reliquats de BR", "BON_RECEPTION");
        }

        @Override
        protected String createCode() {
            return String.valueOf(this.createCodeFromPackage()) + ".reliquatbr";
        }
    }
}

