/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.model;

import java.text.ParseException;
import java.util.Date;
import java.util.Objects;
import org.jdom2.Element;
import org.openconcerto.erp.core.sales.pos.model.ReceiptCode;
import org.openconcerto.erp.core.sales.pos.model.RegisterLog;
import org.openconcerto.utils.XMLDateFormat;

public abstract class RegisterLogEntry {
    private static final XMLDateFormat DATE_FMT = new XMLDateFormat();
    private static final String ENTRY_ELEMENT_NAME = "entry";
    private static final String TYPE_ATTR_NAME = "type";
    private static final String DATE_ATTR_NAME = "date";
    private final RegisterLog.EventType type;
    private final Date date;

    public static final RegisterLogEntry parseEntry(Element elem) throws ParseException {
        if (!elem.getQualifiedName().equals(ENTRY_ELEMENT_NAME)) {
            throw new IllegalArgumentException("Not an entry : " + elem);
        }
        RegisterLog.EventType evtType = RegisterLog.EventType.valueOf(elem.getAttributeValue(TYPE_ATTR_NAME));
        Date date = (Date)DATE_FMT.parseObject(elem.getAttributeValue(DATE_ATTR_NAME));
        if (evtType == RegisterLog.EventType.RECEIPT_CREATION) {
            return ReceiptEntry._parseEntry(elem, evtType, date);
        }
        return RegisterEntry._parseEntry(elem, evtType, date);
    }

    protected RegisterLogEntry(RegisterLog.EventType type, Date date) {
        this.type = Objects.requireNonNull(type, "Missing type");
        this.date = Objects.requireNonNull(date, "Missing date");
    }

    public final RegisterLog.EventType getType() {
        return this.type;
    }

    public final Date getDate() {
        return this.date;
    }

    public final Element toXML() {
        Element res = new Element(ENTRY_ELEMENT_NAME);
        this.fillXML(res);
        res.setAttribute(TYPE_ATTR_NAME, this.type.name()).setAttribute(DATE_ATTR_NAME, DATE_FMT.format(this.date));
        return res;
    }

    protected abstract void fillXML(Element var1);

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + (Object)((Object)this.type) + " at " + this.date;
    }

    public static final class ReceiptEntry
    extends RegisterLogEntry {
        private static final String CODE_ATTR_NAME = "code";
        private static final String HASH_ATTR_NAME = "hash";
        private final ReceiptCode code;
        private final String fileHash;

        private static final ReceiptEntry _parseEntry(Element elem, RegisterLog.EventType evtType, Date date) throws ParseException {
            return new ReceiptEntry(date, new ReceiptCode(elem.getAttributeValue(CODE_ATTR_NAME)), elem.getAttributeValue(HASH_ATTR_NAME));
        }

        public ReceiptEntry(Date date, ReceiptCode code, String fileHash) {
            super(RegisterLog.EventType.RECEIPT_CREATION, date);
            this.code = Objects.requireNonNull(code, "Missing code");
            this.fileHash = Objects.requireNonNull(fileHash, "Missing hash");
        }

        public final ReceiptCode getCode() {
            return this.code;
        }

        public final String getCodeString() {
            return this.getCode().getCode();
        }

        public final String getFileHash() {
            return this.fileHash;
        }

        @Override
        protected void fillXML(Element res) {
            res.setAttribute(CODE_ATTR_NAME, this.getCodeString());
            res.setAttribute(HASH_ATTR_NAME, this.getFileHash());
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + " of " + this.getCodeString();
        }
    }

    public static final class RegisterEntry
    extends RegisterLogEntry {
        private static final String USER_ATTR_NAME = "userID";
        private static final String REGISTER_ATTR_NAME = "registerID";
        private static final String LAST_HASH_ATTR_NAME = "lastReceiptHash";
        private static final String PREVIOUS_DATE_ATTR_NAME = "previousDate";
        private final int userID;
        private final int registerID;
        private final String lastReceiptHash;
        private final Date previousDate;

        private static final RegisterEntry _parseEntry(Element elem, RegisterLog.EventType evtType, Date date) throws ParseException {
            String lastDateAttr = elem.getAttributeValue(PREVIOUS_DATE_ATTR_NAME);
            Date prevDate = lastDateAttr == null ? null : (Date)DATE_FMT.parseObject(lastDateAttr);
            return new RegisterEntry(evtType, date, Integer.parseInt(elem.getAttributeValue(USER_ATTR_NAME)), Integer.parseInt(elem.getAttributeValue(REGISTER_ATTR_NAME)), elem.getAttributeValue(LAST_HASH_ATTR_NAME), prevDate);
        }

        public RegisterEntry(RegisterLog.EventType type, Date date, int userID, int registerID, String lastReceiptHash, Date previousDate) {
            super(type, date);
            if (type != RegisterLog.EventType.REGISTER_OPENING && type != RegisterLog.EventType.REGISTER_CLOSURE) {
                throw new IllegalArgumentException("Wrong type : " + (Object)((Object)type));
            }
            this.userID = userID;
            this.registerID = registerID;
            this.lastReceiptHash = lastReceiptHash;
            this.previousDate = previousDate;
        }

        public final String getLastReceiptHash() {
            return this.lastReceiptHash;
        }

        public final int getUserID() {
            return this.userID;
        }

        public final int getRegisterID() {
            return this.registerID;
        }

        public final Date getPreviousDate() {
            return this.previousDate;
        }

        @Override
        protected void fillXML(Element res) {
            res.setAttribute(USER_ATTR_NAME, String.valueOf(this.userID));
            res.setAttribute(REGISTER_ATTR_NAME, String.valueOf(this.registerID));
            if (this.lastReceiptHash != null) {
                res.setAttribute(LAST_HASH_ATTR_NAME, this.lastReceiptHash);
            }
            if (this.previousDate != null) {
                res.setAttribute(PREVIOUS_DATE_ATTR_NAME, DATE_FMT.format(this.previousDate));
            }
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + " by " + this.userID + " for " + this.registerID;
        }
    }
}

