/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.humanresources.payroll.ui.ContratPrevRubriqueTable;
import org.openconcerto.erp.core.humanresources.payroll.ui.ContratPrevSalarieTable;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.utils.ListMap;

public class ContratPrevoyanceSQLElement
extends ComptaSQLConfElement {
    public ContratPrevoyanceSQLElement() {
        super("CONTRAT_PREVOYANCE", "un contrat de pr\u00e9voyance, mutuelle, formation", "contrats de pr\u00e9voyance, mutuelle, formation");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        l.add("REFERENCE");
        l.add("CODE_ORGANISME");
        l.add("CODE_DELEGATAIRE");
        l.add("COTISATION_ETABLISSEMENT");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        l.add("REFERENCE");
        return l;
    }

    @Override
    public ListMap<String, String> getShowAs() {
        return ListMap.singleton(null, "NOM");
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            ContratPrevSalarieTable tableSalarie;
            ContratPrevRubriqueTable tableRub;
            ContratPrevRubriqueTable tableRubNet;
            {
                this.tableSalarie = new ContratPrevSalarieTable();
                this.tableRub = new ContratPrevRubriqueTable(false);
                this.tableRubNet = new ContratPrevRubriqueTable(true);
            }

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JPanel panelInfos = new JPanel();
                panelInfos.setBorder(BorderFactory.createTitledBorder("Renseignements (S21.G00.15)"));
                panelInfos.setLayout(new GridBagLayout());
                JLabel labelNom = new JLabel(this.getLabelFor("NOM"));
                JTextField textNom = new JTextField();
                c.weightx = 0.0;
                panelInfos.add((Component)labelNom, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelInfos.add((Component)textNom, c);
                c.weightx = 0.0;
                JLabel labelRef = new JLabel(this.getLabelFor("REFERENCE"));
                JTextField textRef = new JTextField();
                ++c.gridx;
                panelInfos.add((Component)labelRef, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelInfos.add((Component)textRef, c);
                c.weightx = 0.0;
                JLabel labelCO = new JLabel(this.getLabelFor("CODE_ORGANISME"));
                JTextField textCO = new JTextField();
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                panelInfos.add((Component)labelCO, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelInfos.add((Component)textCO, c);
                c.weightx = 0.0;
                JLabel labelCD = new JLabel(this.getLabelFor("CODE_DELEGATAIRE"));
                JTextField textCD = new JTextField();
                ++c.gridx;
                panelInfos.add((Component)labelCD, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelInfos.add((Component)textCD, c);
                JCheckBox checkFO = new JCheckBox(this.getLabelFor("COTISATION_ETABLISSEMENT"));
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                c.gridwidth = 2;
                panelInfos.add((Component)checkFO, c);
                JLabel labelDateDeb = new JLabel(this.getLabelFor("DATE_DEBUT"));
                JDate dateDeb = new JDate();
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                panelInfos.add((Component)labelDateDeb, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelInfos.add((Component)dateDeb, c);
                this.addSQLObject(dateDeb, "DATE_DEBUT");
                c.weightx = 0.0;
                JLabel labelDateFin = new JLabel(this.getLabelFor("DATE_FIN"));
                JDate dateFin = new JDate();
                ++c.gridx;
                panelInfos.add((Component)labelDateFin, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelInfos.add((Component)dateFin, c);
                this.addSQLObject(dateFin, "DATE_FIN");
                c.weightx = 0.0;
                TitledSeparator sepRenseignement = new TitledSeparator("Renseignement par contrat salari\u00e9 (S21.G00.70)");
                c.gridwidth = 0;
                ++c.gridy;
                c.gridx = 0;
                panelInfos.add((Component)sepRenseignement, c);
                c.gridx = 0;
                ++c.gridy;
                c.fill = 1;
                c.gridwidth = 0;
                c.weighty = 0.5;
                panelInfos.add((Component)this.tableSalarie, c);
                TitledSeparator sepRub = new TitledSeparator("Rubriques de cotisation rattach\u00e9es");
                c.gridwidth = 0;
                ++c.gridy;
                c.gridx = 0;
                panelInfos.add((Component)sepRub, c);
                c.gridx = 0;
                ++c.gridy;
                c.fill = 1;
                c.weighty = 0.5;
                panelInfos.add((Component)this.tableRub, c);
                TitledSeparator sepRubN = new TitledSeparator("Rubriques de net rattach\u00e9es");
                c.gridwidth = 0;
                ++c.gridy;
                c.gridx = 0;
                panelInfos.add((Component)sepRubN, c);
                c.gridx = 0;
                ++c.gridy;
                c.fill = 1;
                c.weighty = 0.5;
                panelInfos.add((Component)this.tableRubNet, c);
                c.gridx = 0;
                ++c.gridy;
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                this.add((Component)panelInfos, c);
                this.addSQLObject(textNom, "NOM");
                this.addSQLObject(textCD, "CODE_DELEGATAIRE");
                this.addSQLObject(textCO, "CODE_ORGANISME");
                this.addSQLObject(textRef, "REFERENCE");
                this.addSQLObject(checkFO, "COTISATION_ETABLISSEMENT");
            }

            @Override
            public int insert(SQLRow order) {
                int id = super.insert(order);
                this.tableRub.updateField("ID_CONTRAT_PREVOYANCE", id);
                this.tableRubNet.updateField("ID_CONTRAT_PREVOYANCE", id);
                this.tableSalarie.updateField("ID_CONTRAT_PREVOYANCE", id);
                return id;
            }

            @Override
            public void update() {
                int id = this.getSelectedID();
                super.update();
                this.tableRub.updateField("ID_CONTRAT_PREVOYANCE", id);
                this.tableRubNet.updateField("ID_CONTRAT_PREVOYANCE", id);
                this.tableSalarie.updateField("ID_CONTRAT_PREVOYANCE", id);
            }

            @Override
            public void select(SQLRowAccessor r) {
                super.select(r);
                if (r != null) {
                    this.tableRub.insertFrom("ID_CONTRAT_PREVOYANCE", r.getID());
                    this.tableRubNet.insertFrom("ID_CONTRAT_PREVOYANCE", r.getID());
                    this.tableSalarie.insertFrom("ID_CONTRAT_PREVOYANCE", r.getID());
                }
            }
        };
    }
}

