/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.openconcerto.erp.core.finance.payment.element.ChequeAEncaisserSQLElement;
import org.openconcerto.erp.core.finance.payment.ui.ChequeListPanel;
import org.openconcerto.erp.rights.ComptaTotalUserRight;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.ui.JDate;
import org.openconcerto.utils.GestionDevise;

public class ListeDesChequesAEncaisserPanel
extends ChequeListPanel {
    public ListeDesChequesAEncaisserPanel(ChequeAEncaisserSQLElement elem) {
        super(elem);
    }

    @Override
    protected JButton createPreviewBtn() {
        return new JButton("Aper\u00e7u du relev\u00e9");
    }

    @Override
    protected JTextComponent createLabelText() {
        return new JTextField();
    }

    @Override
    protected JButton createSubmitBtn(final SQLRequestComboBox banqueSelect, final JDate dateDepot, final JCheckBox checkImpression, final JTextComponent text) {
        JButton res = new JButton("Valider le d\u00e9p\u00f4t");
        res.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = text.getText();
                ListeDesChequesAEncaisserPanel.this.getModel().valideDepot(banqueSelect.getSelectedRow(), dateDepot.getDate(), checkImpression.isSelected(), s);
                text.setText("");
            }
        });
        return res;
    }

    @Override
    protected void actionDroitTable() {
        super.actionDroitTable();
        if (UserRightsManager.getCurrentUserRights().haveRight(ComptaTotalUserRight.MENU)) {
            this.getListe().addRowAction(new AbstractAction("R\u00e9gularisation en comptabilit\u00e9"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int answer;
                    SQLRow rowCheque = IListe.get(e).fetchSelectedRow();
                    String price = GestionDevise.currencyToString(rowCheque.getLong("MONTANT"));
                    SQLRow rowClient = rowCheque.getForeignRow("ID_CLIENT");
                    String nomClient = rowClient.getString("NOM");
                    String piece = "";
                    SQLRow rowMvt = rowCheque.getForeignRow("ID_MOUVEMENT");
                    if (rowMvt != null) {
                        SQLRow rowPiece = rowMvt.getForeignRow("ID_PIECE");
                        piece = rowPiece.getString("NOM");
                    }
                    if ((answer = JOptionPane.showConfirmDialog(ListeDesChequesAEncaisserPanel.this, "Etes vous s\u00fbr de vouloir r\u00e9gulariser ce cheque de " + nomClient + " d'un montant de " + price + "\u20ac avec une saisie au kilometre?\nNom de la pi\u00e9ce : " + piece + "\nAttention, cette op\u00e9ration est irr\u00e9versible.")) == 0) {
                        SQLRowValues rowVals = rowCheque.asRowValues();
                        rowVals.put("REG_COMPTA", Boolean.TRUE);
                        try {
                            rowVals.commit();
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    @Override
    protected String getDepositLabel() {
        return "S\u00e9lectionner les ch\u00e9ques \u00e0 d\u00e9poser, en date du ";
    }
}

