/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.finance.payment.element.ChequeSQLElement;
import org.openconcerto.erp.generationEcritures.GenerationMvtReglementAvoirChequeClient;
import org.openconcerto.sql.ShowAs;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;

public class ChequeAvoirClientSQLElement
extends ChequeSQLElement {
    public ChequeAvoirClientSQLElement() {
        super("CHEQUE_AVOIR_CLIENT", "un ch\u00e9que de remboursement", "ch\u00e9ques remboursements");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("MONTANT");
        l.add("ID_CLIENT");
        l.add("DATE_AVOIR");
        l.add("DATE_DECAISSE");
        l.add("DECAISSE");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE_AVOIR");
        l.add("MONTANT");
        l.add("ID_CLIENT");
        return l;
    }

    @Override
    public String getDoneFieldName() {
        return "DECAISSE";
    }

    @Override
    public String getDateFieldName() {
        return "DATE_DECAISSE";
    }

    @Override
    public String getMinDateFieldName() {
        return "DATE_MIN_DECAISSE";
    }

    @Override
    public SQLTableModelSourceOnline createDepositTableSource() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("MONTANT");
        l.add("ID_CLIENT");
        l.add("ID_MOUVEMENT");
        l.add("DATE_AVOIR");
        l.add(this.getMinDateFieldName());
        l.add(this.getDoneFieldName());
        ShowAs showAs = new ShowAs(this.getTable().getDBRoot());
        SQLTable mvtT = this.getTable().getForeignTable("ID_MOUVEMENT");
        showAs.show(mvtT, "ID_PIECE");
        showAs.show(mvtT.getForeignTable("ID_PIECE"), "NOM");
        SQLTable clientERP = this.getTable().getForeignTable("ID_CLIENT");
        showAs.show(clientERP, "NOM");
        return this.createDepositTableSource(l, showAs, null);
    }

    @Override
    public void print(List<Integer> rows, boolean preview, Date d) {
    }

    @Override
    public void handle(SQLRowAccessor rowBanque, SQLRowAccessor rowCheque, Date d, String label) throws Exception {
        GenerationMvtReglementAvoirChequeClient gen = new GenerationMvtReglementAvoirChequeClient(rowCheque.getForeignID("ID_MOUVEMENT"), rowCheque.getLong("MONTANT"), d, rowCheque.getID());
        gen.genere();
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private final DeviseField textMontant;
            {
                this.textMontant = new DeviseField();
            }

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JLabel labelMontant = new JLabel("Montant ");
                this.add((Component)labelMontant, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textMontant, c);
                JLabel labelDate = new JLabel("Date ");
                c.weightx = 0.0;
                ++c.gridx;
                labelDate.setHorizontalAlignment(4);
                this.add((Component)labelDate, c);
                JDate dateAvoir = new JDate(true);
                ++c.gridx;
                c.gridwidth = 0;
                this.add((Component)dateAvoir, c);
                ++c.gridy;
                c.gridx = 0;
                JLabel labelClientNom = new JLabel("Client ");
                this.add((Component)labelClientNom, c);
                ElementComboBox nomClient = new ElementComboBox();
                ++c.gridx;
                c.gridwidth = 0;
                this.add((Component)nomClient, c);
                this.addRequiredSQLObject(nomClient, "ID_CLIENT");
                this.addRequiredSQLObject(this.textMontant, "MONTANT");
                this.addRequiredSQLObject(dateAvoir, "DATE_AVOIR");
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".cheque.due";
    }
}

