/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.action;

import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.accounting.ui.SuppressionEcrituresPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;

public class ListeDesChequesAction
extends CreateFrameAbstractAction {
    private final SQLElement element;

    public ListeDesChequesAction(String name, String tableName) {
        super(name);
        this.element = Configuration.getInstance().getDirectory().getElement(tableName);
    }

    @Override
    public JFrame createFrame() {
        IListFrame frame = new IListFrame(new ListeAddPanel(this.element){

            @Override
            protected void handleAction(JButton source, ActionEvent evt) {
                if (this.getListe().getSelectedId() > 1) {
                    SQLRow row = this.getListe().fetchSelectedRow();
                    if (source == this.buttonModifier) {
                        MouvementSQLElement.showSource(row.getInt("ID_MOUVEMENT"));
                    } else if (source == this.buttonEffacer) {
                        PanelFrame frameDelete = new PanelFrame(new SuppressionEcrituresPanel(row.getInt("ID_MOUVEMENT")), "Suppression");
                        frameDelete.pack();
                        frameDelete.setLocationRelativeTo(null);
                        frameDelete.setResizable(false);
                        frameDelete.setVisible(true);
                    }
                } else {
                    super.handleAction(source, evt);
                }
            }
        });
        frame.getPanel().getListe().setSQLEditable(false);
        frame.getPanel().setAddVisible(false);
        return frame;
    }
}

