/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.report;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.finance.accounting.model.SommeCompte;
import org.openconcerto.erp.core.finance.accounting.report.PdfGenerator_2033A;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.GestionDevise;

public class Map2033A
extends Thread {
    private Map<String, Object> m;
    private final DateFormat format = new SimpleDateFormat("ddMMyyyy");
    private JProgressBar bar;
    private Date dateDebut;
    private Date dateFin;
    SommeCompte sommeCompte;

    @Override
    public void run() {
        PdfGenerator_2033A p = new PdfGenerator_2033A();
        this.m = new HashMap<String, Object>();
        SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        this.m.put("NOM", String.valueOf(rowSociete.getString("TYPE")) + " " + rowSociete.getString("NOM"));
        SQLRow rowAdresse = Configuration.getInstance().getBase().getTable("ADRESSE_COMMON").getRow(rowSociete.getInt("ID_ADRESSE_COMMON"));
        String ville = rowAdresse.getString("VILLE");
        Object cedex = rowAdresse.getObject("CEDEX");
        boolean hasCedex = rowAdresse.getBoolean("HAS_CEDEX");
        if (hasCedex) {
            ville = String.valueOf(ville) + " CEDEX";
            if (cedex != null && cedex.toString().trim().length() > 0) {
                ville = String.valueOf(ville) + " " + cedex.toString().trim();
            }
        }
        this.m.put("ADRESSE", String.valueOf(rowAdresse.getString("RUE")) + ", " + rowAdresse.getString("CODE_POSTAL") + " " + ville);
        this.m.put("SIRET", rowSociete.getString("NUM_SIRET"));
        this.m.put("APE", rowSociete.getString("NUM_APE"));
        this.m.put("DUREE1", "");
        this.m.put("DUREE2", "");
        SQLRow rowExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON").getRow(rowSociete.getInt("ID_EXERCICE_COMMON"));
        this.m.put("CLOS1", this.format.format(this.dateFin));
        this.m.put("CLOS2", "");
        long v010 = this.sommeCompte.soldeCompte(206, 207, true, this.dateDebut, this.dateFin);
        this.m.put("ACTIF1.0", GestionDevise.currencyToString(v010, false));
        long v012 = -this.sommeCompte.sommeCompteFils("2807", this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(2906, 2907, true, this.dateDebut, this.dateFin);
        this.m.put("ACTIF2.0", GestionDevise.currencyToString(v012, false));
        long v011 = v010 - v012;
        this.m.put("ACTIF3.0", GestionDevise.currencyToString(v011, false));
        this.m.put("ACTIF4.0", "");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Map2033A.this.bar.setValue(10);
            }
        });
        long v014 = this.sommeCompte.soldeCompteDebiteur(109, 109, true, this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("201", this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("203", this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("232", this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("205", this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompte(208, 208, true, this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(2087, 2087, true, this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("237", this.dateDebut, this.dateFin);
        this.m.put("ACTIF1.1", GestionDevise.currencyToString(v014, false));
        long v016 = -this.sommeCompte.sommeCompteFils("2801", this.dateDebut, this.dateFin) - this.sommeCompte.sommeCompteFils("2803", this.dateDebut, this.dateFin) - this.sommeCompte.sommeCompteFils("2805", this.dateDebut, this.dateFin) - this.sommeCompte.sommeCompteFils("2808", this.dateDebut, this.dateFin) - this.sommeCompte.sommeCompteFils("2905", this.dateDebut, this.dateFin) - this.sommeCompte.sommeCompteFils("2906", this.dateDebut, this.dateFin) - this.sommeCompte.sommeCompteFils("2907", this.dateDebut, this.dateFin) - this.sommeCompte.sommeCompteFils("2908", this.dateDebut, this.dateFin) - this.sommeCompte.sommeCompteFils("2932", this.dateDebut, this.dateFin);
        this.m.put("ACTIF2.1", GestionDevise.currencyToString(v016, false));
        long v015 = v014 - v016;
        this.m.put("ACTIF3.1", GestionDevise.currencyToString(v015, false));
        this.m.put("ACTIF4.1", "");
        long v028 = this.sommeCompte.soldeCompte(211, 215, true, this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("218", this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("231", this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("238", this.dateDebut, this.dateFin);
        this.m.put("ACTIF1.2", GestionDevise.currencyToString(v028, false));
        long v030 = -this.sommeCompte.soldeCompte(2810, 2815, true, this.dateDebut, this.dateFin) - this.sommeCompte.sommeCompteFils("2818", this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(2931, 2931, true, this.dateDebut, this.dateFin) - this.sommeCompte.sommeCompteFils("2911", this.dateDebut, this.dateFin);
        this.m.put("ACTIF2.2", GestionDevise.currencyToString(v030, false));
        long v027 = v028 - v030;
        this.m.put("ACTIF3.2", GestionDevise.currencyToString(v027, false));
        this.m.put("ACTIF4.2", "");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Map2033A.this.bar.setValue(20);
            }
        });
        long v040 = this.sommeCompte.sommeCompteFils("261", this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompte(266, 268, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompte(271, 275, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompte(2761, 2761, true, this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("27682", this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompte(27684, 27685, true, this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("27688", this.dateDebut, this.dateFin);
        this.m.put("ACTIF1.3", GestionDevise.currencyToString(v040, false));
        long v042 = -this.sommeCompte.soldeCompte(2961, 2961, true, this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(2966, 2968, true, this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(2971, 2976, true, this.dateDebut, this.dateFin);
        this.m.put("ACTIF2.3", GestionDevise.currencyToString(v042, false));
        long v041 = v040 - v042;
        this.m.put("ACTIF3.3", GestionDevise.currencyToString(v041, false));
        this.m.put("ACTIF4.3", "");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Map2033A.this.bar.setValue(30);
            }
        });
        long v044 = v010 + v014 + v028 + v040;
        this.m.put("ACTIF1.4", GestionDevise.currencyToString(v044, false));
        long v048 = v012 + v016 + v030 + v042;
        this.m.put("ACTIF2.4", GestionDevise.currencyToString(v048, false));
        long v045 = v011 + v015 + v027 + v041;
        this.m.put("ACTIF3.4", GestionDevise.currencyToString(v045, false));
        this.m.put("ACTIF4.4", "");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Map2033A.this.bar.setValue(40);
            }
        });
        long v050 = this.sommeCompte.soldeCompte(30, 35, true, this.dateDebut, this.dateFin);
        this.m.put("ACTIF1.5", GestionDevise.currencyToString(v050, false));
        long v052 = -this.sommeCompte.soldeCompte(391, 395, true, this.dateDebut, this.dateFin);
        this.m.put("ACTIF2.5", GestionDevise.currencyToString(v052, false));
        long v051 = v050 - v052;
        this.m.put("ACTIF3.5", GestionDevise.currencyToString(v051, false));
        this.m.put("ACTIF4.5", "");
        long v060 = this.sommeCompte.soldeCompte(37, 37, true, this.dateDebut, this.dateFin);
        this.m.put("ACTIF1.6", GestionDevise.currencyToString(v060, false));
        long v062 = -this.sommeCompte.soldeCompte(397, 397, true, this.dateDebut, this.dateFin);
        this.m.put("ACTIF2.6", GestionDevise.currencyToString(v062, false));
        long v061 = v060 - v062;
        this.m.put("ACTIF3.6", GestionDevise.currencyToString(v061, false));
        this.m.put("ACTIF4.6", "");
        long v064 = this.sommeCompte.soldeCompte(4091, 4091, true, this.dateDebut, this.dateFin);
        this.m.put("ACTIF1.7", GestionDevise.currencyToString(v064, false));
        long v066 = 0L;
        this.m.put("ACTIF2.7", "");
        long v065 = v064;
        this.m.put("ACTIF3.7", GestionDevise.currencyToString(v064, false));
        long v067 = 0L;
        this.m.put("ACTIF4.7", "");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Map2033A.this.bar.setValue(50);
            }
        });
        long v068 = this.sommeCompte.soldeCompteDebiteur(410, 411, true, this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("413", this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteDebiteur(416, 418, true, this.dateDebut, this.dateFin);
        this.m.put("ACTIF1.8", GestionDevise.currencyToString(v068, false));
        long v070 = -this.sommeCompte.soldeCompte(491, 491, true, this.dateDebut, this.dateFin);
        this.m.put("ACTIF2.8", GestionDevise.currencyToString(v070, false));
        long v069 = v068 - v070;
        this.m.put("ACTIF3.8", GestionDevise.currencyToString(v069, false));
        this.m.put("ACTIF4.8", "");
        long v072 = this.sommeCompte.soldeCompteDebiteur(4455, 4455, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteDebiteur(421, 421, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteDebiteur(400, 408, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompte(4096, 4098, true, this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("425", this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("4287", this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("4374", this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("4387", this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("441", this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteDebiteur(443, 444, true, this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("4456", this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompte(44581, 44583, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteDebiteur(44586, 44586, true, this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("4487", this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteDebiteur(451, 451, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteDebiteur(455, 455, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteDebiteur(4560, 4561, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteDebiteur(4563, 4569, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteDebiteur(458, 458, true, this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("462", this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("465", this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteDebiteur(467, 467, true, this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("4687", this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteDebiteur(478, 478, true, this.dateDebut, this.dateFin);
        this.m.put("ACTIF1.9", GestionDevise.currencyToString(v072, false));
        long v074 = -this.sommeCompte.soldeCompte(495, 496, true, this.dateDebut, this.dateFin);
        this.m.put("ACTIF2.9", GestionDevise.currencyToString(v074, false));
        long v073 = v072 - v074;
        this.m.put("ACTIF3.9", GestionDevise.currencyToString(v073, false));
        this.m.put("ACTIF4.9", "");
        long v080 = this.sommeCompte.soldeCompte(500, 508, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompte(52, 52, true, this.dateDebut, this.dateFin);
        this.m.put("ACTIF1.10", GestionDevise.currencyToString(v080, false));
        long v082 = -this.sommeCompte.sommeCompteFils("59", this.dateDebut, this.dateFin);
        this.m.put("ACTIF2.10", GestionDevise.currencyToString(v082, false));
        long v081 = v080 - v082;
        this.m.put("ACTIF3.10", GestionDevise.currencyToString(v081, false));
        this.m.put("ACTIF4.10", "");
        long v084 = this.sommeCompte.soldeCompteDebiteur(510, 517, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteDebiteur(5180, 5185, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteDebiteur(5187, 5189, true, this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("54", this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("53", this.dateDebut, this.dateFin) + this.sommeCompte.sommeCompteFils("58", this.dateDebut, this.dateFin);
        this.m.put("ACTIF1.11", GestionDevise.currencyToString(v084, false));
        this.m.put("ACTIF2.11", "");
        long v085 = v084;
        this.m.put("ACTIF3.11", GestionDevise.currencyToString(v085, false));
        this.m.put("ACTIF4.11", "");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Map2033A.this.bar.setValue(60);
            }
        });
        long v092 = this.sommeCompte.sommeCompteFils("486", this.dateDebut, this.dateFin);
        this.m.put("ACTIF1.12", GestionDevise.currencyToString(v092, false));
        long v094 = 0L;
        this.m.put("ACTIF2.12", "");
        long v093 = v092 - v094;
        this.m.put("ACTIF3.12", GestionDevise.currencyToString(v093, false));
        this.m.put("ACTIF4.12", "");
        long v096 = v050 + v060 + v064 + v068 + v072 + v080 + v084 + v092;
        this.m.put("ACTIF1.13", GestionDevise.currencyToString(v096, false));
        long v098 = v052 + v062 + v070 + v074 + v082 + v094;
        this.m.put("ACTIF2.13", GestionDevise.currencyToString(v098, false));
        long v097 = v051 + v061 + v065 + v069 + v073 + v081 + v085 + v093;
        this.m.put("ACTIF3.13", GestionDevise.currencyToString(v097, false));
        this.m.put("ACTIF4.13", "");
        long v110 = v044 + v096;
        this.m.put("ACTIF1.14", GestionDevise.currencyToString(v110, false));
        long v112 = v048 + v098;
        this.m.put("ACTIF2.14", GestionDevise.currencyToString(v112, false));
        long v111 = v045 + v097;
        this.m.put("ACTIF3.14", GestionDevise.currencyToString(v111, false));
        this.m.put("ACTIF4.14", "");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Map2033A.this.bar.setValue(70);
            }
        });
        long v120 = -this.sommeCompte.sommeCompteFils("101", this.dateDebut, this.dateFin) - this.sommeCompte.sommeCompteFils("103", this.dateDebut, this.dateFin) - this.sommeCompte.sommeCompteFils("108", this.dateDebut, this.dateFin) - this.sommeCompte.sommeCompteFils("104", this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(109, 109, true, this.dateDebut, this.dateFin);
        this.m.put("PASSIF3.15", GestionDevise.currencyToString(v120, false));
        this.m.put("PASSIF4.15", "");
        long v124 = -this.sommeCompte.sommeCompteFils("105", this.dateDebut, this.dateFin);
        this.m.put("PASSIF3.16", GestionDevise.currencyToString(v124, false));
        this.m.put("PASSIF4.16", "");
        long v126 = -this.sommeCompte.soldeCompte(1061, 1061, true, this.dateDebut, this.dateFin);
        this.m.put("PASSIF3.17", GestionDevise.currencyToString(v126, false));
        this.m.put("PASSIF4.17", "");
        long v130 = -this.sommeCompte.soldeCompte(1062, 1062, true, this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(1064, 1064, true, this.dateDebut, this.dateFin);
        this.m.put("PASSIF3.18", GestionDevise.currencyToString(v130, false));
        this.m.put("PASSIF4.18", "");
        long v132 = -this.sommeCompte.sommeCompteFils("1063", this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(1068, 1068, true, this.dateDebut, this.dateFin);
        this.m.put("PASSIF3.19", GestionDevise.currencyToString(v132, false));
        this.m.put("PASSIF4.19", "");
        long v134 = -this.sommeCompte.sommeCompteFils("11", this.dateDebut, this.dateFin);
        this.m.put("PASSIF3.20", GestionDevise.currencyToString(v134, false));
        this.m.put("PASSIF4.20", "");
        long v136 = -this.sommeCompte.sommeCompteFils("7", this.dateDebut, this.dateFin) - this.sommeCompte.sommeCompteFils("6", this.dateDebut, this.dateFin);
        this.m.put("PASSIF3.21", GestionDevise.currencyToString(v136, false));
        this.m.put("PASSIF4.21", "");
        long v140 = -this.sommeCompte.soldeCompte(13, 14, true, this.dateDebut, this.dateFin);
        this.m.put("PASSIF3.22", GestionDevise.currencyToString(v140, false));
        this.m.put("PASSIF4.22", "");
        long v142 = v120 + v124 + v126 + v130 + v132 + v134 + v136 + v140;
        this.m.put("PASSIF3.23", GestionDevise.currencyToString(v142, false));
        this.m.put("PASSIF4.23", "");
        long v154 = -this.sommeCompte.sommeCompteFils("15", this.dateDebut, this.dateFin);
        this.m.put("PASSIF3.24", GestionDevise.currencyToString(v154, false));
        this.m.put("PASSIF4.24", "");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Map2033A.this.bar.setValue(80);
            }
        });
        long v156 = -this.sommeCompte.sommeCompteFils("161", this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(163, 166, true, this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(1680, 1681, true, this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(1682, 1682, true, this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(1684, 1689, true, this.dateDebut, this.dateFin) - this.sommeCompte.sommeCompteFils("17", this.dateDebut, this.dateFin) - this.sommeCompte.sommeCompteFils("426", this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(450, 454, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(456, 456, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(458, 459, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(512, 517, true, this.dateDebut, this.dateFin) - this.sommeCompte.sommeCompteFils("518", this.dateDebut, this.dateFin) - this.sommeCompte.sommeCompteFils("519", this.dateDebut, this.dateFin);
        this.m.put("PASSIF3.25", GestionDevise.currencyToString(v156, false));
        this.m.put("PASSIF4.25", "");
        long v164 = -this.sommeCompte.soldeCompte(4191, 4191, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(510, 511, true, this.dateDebut, this.dateFin);
        this.m.put("PASSIF3.26", GestionDevise.currencyToString(v164, false));
        this.m.put("PASSIF4.26", "");
        long v166 = this.sommeCompte.soldeCompteCrediteur(403, 403, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(401, 401, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(4081, 4081, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(4088, 4088, true, this.dateDebut, this.dateFin);
        this.m.put("PASSIF3.27", GestionDevise.currencyToString(v166, false));
        this.m.put("PASSIF4.27", "");
        long v169 = -this.sommeCompte.sommeCompteFils("455", this.dateDebut, this.dateFin);
        this.m.put("PASSIF2.28", GestionDevise.currencyToString(v169, false));
        long v172 = this.sommeCompte.soldeCompteCrediteur(410, 411, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(421, 421, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(422, 422, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(424, 424, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(427, 427, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(4282, 4282, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(4284, 4284, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(4286, 4286, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(43, 43, true, this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompteCrediteur(4387, 4387, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(442, 442, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(443, 443, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(444, 444, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(4455, 4455, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(44586, 44586, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(4457, 4457, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(44584, 44584, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(44587, 44587, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(455, 455, true, this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(446, 447, true, this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(4482, 4482, true, this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(4486, 4486, true, this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(457, 457, true, this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(269, 269, true, this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(279, 279, true, this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(404, 405, true, this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(4084, 4084, true, this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(4088, 4088, true, this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(4196, 4198, true, this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(464, 464, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(467, 467, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(4686, 4686, true, this.dateDebut, this.dateFin) + this.sommeCompte.soldeCompteCrediteur(478, 478, true, this.dateDebut, this.dateFin) - this.sommeCompte.soldeCompte(509, 509, true, this.dateDebut, this.dateFin);
        this.m.put("PASSIF3.28", GestionDevise.currencyToString(v172, false));
        this.m.put("PASSIF4.28", "");
        long v174 = -this.sommeCompte.soldeCompte(487, 487, false, this.dateDebut, this.dateFin);
        this.m.put("PASSIF3.29", GestionDevise.currencyToString(v174, false));
        this.m.put("PASSIF4.29", "");
        long v176 = v156 + v164 + v166 + v172 + v174;
        this.m.put("PASSIF3.30", GestionDevise.currencyToString(v176, false));
        this.m.put("PASSIF4.30", "");
        long v180 = v142 + v154 + v176;
        this.m.put("PASSIF3.31", GestionDevise.currencyToString(v180, false));
        this.m.put("PASSIF4.31", "");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Map2033A.this.bar.setValue(90);
            }
        });
        this.m.put("PASSIF2.18", "");
        this.m.put("PASSIF2.19", "");
        this.m.put("PASSIF1.32", "");
        this.m.put("PASSIF1.33", "");
        this.m.put("PASSIF1.34", "");
        this.m.put("PASSIF4.32", "");
        this.m.put("PASSIF4.33", "");
        this.m.put("PASSIF4.34", "");
        p.generateFrom(this.m);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Map2033A.this.bar.setValue(95);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String file = String.valueOf(TemplateNXProps.getInstance().getStringProperty("Location2033APDF")) + File.separator + String.valueOf(Calendar.getInstance().get(1)) + File.separator + "result_2033A.pdf";
                File f = new File(file);
                Gestion.openPDF(f);
                Map2033A.this.bar.setValue(100);
            }
        });
    }

    public Map2033A(JProgressBar bar, Date dateDeb, Date dateFin) {
        this(bar, dateDeb, dateFin, null);
    }

    public Map2033A(JProgressBar bar, Date dateDeb, Date dateFin, SQLRow posteAnalytique) {
        this.bar = bar;
        if (dateDeb == null && dateFin == null) {
            SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
            SQLRow rowExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON").getRow(rowSociete.getInt("ID_EXERCICE_COMMON"));
            dateFin = (Date)rowExercice.getObject("DATE_FIN");
            dateDeb = (Date)rowExercice.getObject("DATE_DEB");
        }
        this.dateDebut = dateDeb;
        this.dateFin = dateFin;
        this.sommeCompte = new SommeCompte(posteAnalytique);
    }

    public Map2033A(JProgressBar bar) {
        this(bar, null, null);
    }

    public void generateMap2033A() {
        this.start();
    }
}

