/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.edm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import org.openconcerto.erp.core.edm.Attachment;
import org.openconcerto.erp.core.edm.AttachmentPanel;
import org.openconcerto.erp.core.edm.AttachmentTransferable;
import org.openconcerto.erp.core.edm.AttachmentUtils;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.JImage;

public class FilePanel
extends JPanel {
    private static final Color HOVER_COLOR = new Color(230, 240, 255);
    private static final Color SELECTED_COLOR = new Color(193, 220, 252);
    public static final int PREFERRED_WIDTH = 128;
    public static final int PREFERRED_HEIGHT = 74;
    private final JLabel label;
    private JImage image;
    private AttachmentPanel attachmentPanel;
    private Attachment attachment;

    public FilePanel(final Attachment attachment, final AttachmentPanel panelSource) {
        this.attachment = attachment;
        this.attachmentPanel = panelSource;
        String name = attachment.getName();
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        try {
            String type = attachment.getMimeType();
            this.image = type == null || type.trim().isEmpty() || type.equals("application/octet-stream") ? new JImage(this.getClass().getResource("data-icon.png")) : (type.equals("application/msword") ? new JImage(this.getClass().getResource("doc-icon.png")) : (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document") ? new JImage(this.getClass().getResource("docx-icon.png")) : (type.equals("application/vnd.oasis.opendocument.text") ? new JImage(this.getClass().getResource("odt-icon.png")) : (type.equals("application/pdf") ? new JImage(this.getClass().getResource("pdf-icon.png")) : (type.equals("image/jpeg") ? new JImage(this.getClass().getResource("jpg-icon.png")) : (type.equals("image/png") ? new JImage(this.getClass().getResource("png-icon.png")) : (type.equals("application/vnd.oasis.opendocument.spreadsheet") ? new JImage(this.getClass().getResource("ods-icon.png")) : (type.equals("application/msexcel") || type.equals("application/vnd.ms-excel") || type.equals("application/xls") ? new JImage(this.getClass().getResource("xls-icon.png")) : (type.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet") ? new JImage(this.getClass().getResource("xlsx-icon.png")) : (type.equals("inode/directory") ? new JImage(this.getClass().getResource("folder-icon.png")) : new JImage(this.getClass().getResource("data-icon.png"))))))))))));
            this.image.setOpaque(true);
            this.image.setCenterImage(true);
            this.add((Component)this.image, "Center");
        }
        catch (Exception e) {
            ExceptionHandler.handle("image error", e);
        }
        this.setBackground(Color.WHITE);
        this.label = new JLabel(name, 0);
        this.label.setOpaque(false);
        this.label.setPreferredSize(new Dimension(this.label.getPreferredSize().width, new JTextField((String)"a").getPreferredSize().height));
        this.add((Component)this.label, "South");
        this.setPreferredSize(new Dimension(128, 74));
        this.setMinimumSize(new Dimension(128, 74));
        this.updateBackgroundFromState();
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                JComponent lab = (JComponent)e.getSource();
                TransferHandler handle = lab.getTransferHandler();
                handle.exportAsDrag(lab, e, 2);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                FilePanel.this.updateBackgroundFromState();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (panelSource.isSelected(attachment)) {
                    FilePanel.this.setBackground(SELECTED_COLOR);
                } else {
                    FilePanel.this.setBackground(HOVER_COLOR);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                boolean ctrlPressed;
                boolean bl = ctrlPressed = (e.getModifiers() & 2) == 2;
                if (!ctrlPressed) {
                    panelSource.select(attachment);
                    FilePanel.this.updateBackgroundFromState();
                } else {
                    if (!panelSource.isSelected(FilePanel.this.attachment)) {
                        panelSource.select(attachment);
                    } else {
                        panelSource.deselect(attachment);
                    }
                    FilePanel.this.updateBackgroundFromState();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                boolean ctrlPressed;
                boolean bl = ctrlPressed = (e.getModifiers() & 2) == 2;
                if (!ctrlPressed) {
                    panelSource.clearSelection();
                    panelSource.select(attachment);
                    panelSource.updatePanels();
                }
            }
        });
        this.initMenu(attachment, panelSource, name);
        this.setTransferHandler(new TransferHandler("id"){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                if (!attachment.isFolder()) {
                    return false;
                }
                try {
                    Attachment a;
                    List attachmentsToImport = (List)support.getTransferable().getTransferData(support.getDataFlavors()[0]);
                    Iterator iterator = attachmentsToImport.iterator();
                    do {
                        if (iterator.hasNext()) continue;
                        return true;
                    } while ((a = (Attachment)iterator.next()).getId() != attachment.getId());
                    return false;
                }
                catch (UnsupportedFlavorException | IOException e) {
                    e.printStackTrace();
                }
                return true;
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                if (!this.canImport(support)) {
                    return false;
                }
                try {
                    List attachmentsToImport = (List)support.getTransferable().getTransferData(support.getDataFlavors()[0]);
                    AttachmentUtils utils = new AttachmentUtils();
                    for (Attachment a : attachmentsToImport) {
                        utils.move(a, attachment);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            panelSource.initUI();
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                return new AttachmentTransferable(new ArrayList<Attachment>(FilePanel.this.attachmentPanel.getSelectedAttachments()));
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 2;
            }
        });
    }

    public void updateBackgroundFromState() {
        if (this.attachmentPanel.isSelected(this.attachment)) {
            this.setBackground(SELECTED_COLOR);
        } else {
            this.setBackground(Color.WHITE);
        }
    }

    private void initMenu(final Attachment attachment, final AttachmentPanel panelSource, String name) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuItemDelete = new JMenuItem("Supprimer");
        menuItemDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int value = 0;
                value = attachment.isFolder() ? JOptionPane.showConfirmDialog(FilePanel.this, "Voulez-vous vraiment supprimer ce dossier ?\n" + attachment.getName(), "Supprimer le dossier", 0) : JOptionPane.showConfirmDialog(FilePanel.this, "Voulez-vous vraiment supprimer ce fichier ?\n" + attachment.getName() + "\nFichier original : " + attachment.getFileName() + "\nType : " + attachment.getMimeType(), "Supprimer le fichier", 0);
                if (value == 0) {
                    AttachmentUtils utils = new AttachmentUtils();
                    try {
                        utils.deleteFile(attachment);
                        panelSource.initUI();
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle("Erreur lors de la suppression", e1);
                    }
                }
            }
        });
        menu.add(menuItemDelete);
        JMenuItem menuItemRename = new JMenuItem("Renommer");
        menuItemRename.addActionListener(new ActionListener(name){
            final JTextField text;
            {
                this.text = new JTextField(string);
            }

            private void stopNameEditing() {
                FilePanel.this.invalidate();
                FilePanel.this.remove(this.text);
                FilePanel.this.add((Component)FilePanel.this.label, "South");
                FilePanel.this.validate();
                FilePanel.this.repaint();
            }

            public void validText(Attachment attachment2, String name, JTextField text) {
                try {
                    String newName = text.getText();
                    if (newName.trim().isEmpty()) {
                        newName = name;
                    }
                    AttachmentUtils.rename(attachment2, newName);
                    FilePanel.this.label.setText(newName);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle("Erreur lors du renommage du fichier!", e1);
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                final String name = attachment.getName();
                this.text.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            this.validText(attachment, name, text);
                            this.stopNameEditing();
                        } else if (e.getKeyCode() == 27) {
                            this.stopNameEditing();
                        }
                    }
                });
                this.text.addFocusListener(new FocusListener(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        this.validText(attachment, name, text);
                        this.stopNameEditing();
                    }

                    @Override
                    public void focusGained(FocusEvent e) {
                    }
                });
                this.text.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseExited(MouseEvent e) {
                        this.validText(attachment, name, text);
                        this.stopNameEditing();
                    }
                });
                FilePanel.this.invalidate();
                FilePanel.this.remove(FilePanel.this.label);
                FilePanel.this.add((Component)this.text, "South");
                FilePanel.this.validate();
                FilePanel.this.repaint();
                this.text.grabFocus();
                this.text.setSelectionStart(0);
                this.text.setSelectionEnd(name.length());
            }
        });
        menu.add(menuItemRename);
        if (!attachment.isFolder()) {
            menu.addSeparator();
            JMenuItem menuItemProperties = new JMenuItem("Propri\u00e9t\u00e9s");
            menuItemProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFrame f = new JFrame();
                    f.setTitle("Propri\u00e9t\u00e9s de " + attachment.getName());
                    JPanel p = new JPanel();
                    p.setLayout(new GridBagLayout());
                    DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                    c.weightx = 0.0;
                    p.add((Component)new JLabel("Nom : ", 4), c);
                    ++c.gridx;
                    c.weightx = 1.0;
                    p.add((Component)new JLabel(attachment.getName()), c);
                    ++c.gridy;
                    c.gridx = 0;
                    c.weightx = 0.0;
                    p.add((Component)new JLabel("Type : ", 4), c);
                    ++c.gridx;
                    c.weightx = 1.0;
                    p.add((Component)new JLabel(attachment.getMimeType()), c);
                    ++c.gridy;
                    c.gridx = 0;
                    c.weightx = 0.0;
                    p.add((Component)new JLabel("Fichier original : ", 4), c);
                    ++c.gridx;
                    c.weightx = 1.0;
                    p.add((Component)new JLabel(attachment.getFileName()), c);
                    ++c.gridy;
                    c.gridx = 0;
                    c.weightx = 0.0;
                    p.add((Component)new JLabel("Taille : ", 4), c);
                    ++c.gridx;
                    c.weightx = 1.0;
                    p.add((Component)new JLabel(String.valueOf(attachment.getFileSize()) + " octets"), c);
                    c.gridx = 1;
                    ++c.gridy;
                    c.weightx = 1.0;
                    JPanel spacer = new JPanel();
                    spacer.setPreferredSize(new Dimension(300, 1));
                    p.add((Component)spacer, c);
                    f.setDefaultCloseOperation(2);
                    f.setContentPane(p);
                    f.pack();
                    f.setResizable(false);
                    f.setLocationRelativeTo(FilePanel.this);
                    f.setVisible(true);
                }
            });
            menu.add(menuItemProperties);
        }
        this.setComponentPopupMenu(menu);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.image != null) {
            this.image.setBackground(bg);
        }
    }
}

