/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.edm;

import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.edm.Attachment;
import org.openconcerto.erp.core.edm.AttachmentSQLElement;
import org.openconcerto.erp.generationDoc.DocumentLocalStorageManager;
import org.openconcerto.erp.storage.StorageEngine;
import org.openconcerto.erp.storage.StorageEngines;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.sync.SyncClient;

public class AttachmentUtils {
    public void uploadFile(File inFile, SQLRowAccessor rowSource, int idParent) {
        try {
            String fileName;
            SQLRowValues rowValsAttachment = new SQLRowValues(rowSource.getTable().getTable("ATTACHMENT"));
            rowValsAttachment.put("SOURCE_TABLE", rowSource.getTable().getName());
            rowValsAttachment.put("SOURCE_ID", rowSource.getID());
            rowValsAttachment.put("ID_PARENT", idParent);
            SQLRow rowAttachment = rowValsAttachment.insert();
            int id = rowAttachment.getID();
            String folderId = String.valueOf(id / 1000 * 1000);
            String subDir = "EDM" + File.separator + folderId;
            String fileNameID = String.valueOf(id);
            String ext = "";
            int i = inFile.getName().lastIndexOf(46);
            if (i > 0) {
                ext = inFile.getName().substring(i + 1);
            }
            String fileWithIDNAme = String.valueOf(fileNameID) + "." + ext;
            ComptaPropsConfiguration config = ComptaPropsConfiguration.getInstanceCompta();
            boolean isOnCloud = config.isOnCloud();
            if (isOnCloud) {
                String remotePath = subDir;
                remotePath = remotePath.replace('\\', '/');
                List<StorageEngine> engines = StorageEngines.getInstance().getActiveEngines();
                for (StorageEngine storageEngine : engines) {
                    if (!storageEngine.isConfigured() || !storageEngine.allowAutoStorage()) continue;
                    String path = remotePath;
                    try {
                        Throwable throwable = null;
                        Object var21_25 = null;
                        try (FileInputStream in = new FileInputStream(inFile);){
                            storageEngine.connect();
                            BufferedInputStream inStream = new BufferedInputStream(in);
                            storageEngine.store(inStream, path, fileWithIDNAme, true);
                            inStream.close();
                            storageEngine.disconnect();
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        ExceptionHandler.handle("Impossible de sauvegarder le fichier " + inFile.getAbsolutePath() + " vers " + path + "(" + storageEngine + ")", e);
                    }
                }
            } else {
                File dirRoot = DocumentLocalStorageManager.getInstance().getDocumentOutputDirectory("EDMdirectory");
                File storagePathFile = new File(dirRoot, subDir);
                storagePathFile.mkdirs();
                FileUtils.copyFile(inFile, new File(storagePathFile, fileWithIDNAme));
            }
            rowValsAttachment = rowAttachment.createEmptyUpdateRow();
            String name = fileName = inFile.getName();
            int index = name.lastIndexOf(46);
            if (index > 0) {
                name = name.substring(0, index);
            }
            rowValsAttachment.put("NAME", name);
            rowValsAttachment.put("SOURCE_TABLE", rowSource.getTable().getName());
            rowValsAttachment.put("SOURCE_ID", rowSource.getID());
            Collection mimeTypes = MimeUtil.getMimeTypes(inFile);
            if (mimeTypes != null && !mimeTypes.isEmpty()) {
                MimeType mimeType = (MimeType)mimeTypes.toArray()[0];
                rowValsAttachment.put("MIMETYPE", String.valueOf(mimeType.getMediaType()) + "/" + mimeType.getSubType());
            } else {
                rowValsAttachment.put("MIMETYPE", "application/octet-stream");
            }
            rowValsAttachment.put("FILENAME", fileName);
            rowValsAttachment.put("FILESIZE", inFile.length());
            rowValsAttachment.put("STORAGE_PATH", subDir);
            rowValsAttachment.put("STORAGE_FILENAME", fileWithIDNAme);
            rowValsAttachment.commit();
            Attachment a = new Attachment(rowValsAttachment);
            this.updateAttachmentsCountFromAttachment(a);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public File getFile(Attachment attachment) {
        File fTemp;
        ComptaPropsConfiguration config = ComptaPropsConfiguration.getInstanceCompta();
        boolean isOnCloud = config.isOnCloud();
        String subDir = attachment.getStoragePath();
        String fileName = attachment.getStorageFileName();
        String remotePath = String.valueOf(config.getSocieteID()) + File.separator + subDir;
        try {
            fTemp = File.createTempFile("edm_", "oc");
        }
        catch (IOException e) {
            ExceptionHandler.handle("Impossible de cr\u00e9er le fichier temporaire de r\u00e9ception", e);
            return null;
        }
        File f = new File(fTemp.getParent(), String.valueOf(fTemp.getName()) + "-dir");
        f.mkdirs();
        fTemp.delete();
        if (isOnCloud) {
            remotePath = remotePath.replace('\\', '/');
            SyncClient client = new SyncClient("https://" + config.getStorageServer());
            client.setVerifyHost(false);
            try {
                client.retrieveFile(f, remotePath, fileName, config.getToken());
            }
            catch (Exception e) {
                ExceptionHandler.handle("Impossible de r\u00e9cup\u00e9rer le fichier depuis le cloud", e);
                return null;
            }
        } else {
            File dirRoot = DocumentLocalStorageManager.getInstance().getDocumentOutputDirectory("EDMdirectory");
            File storagePathFile = new File(dirRoot, subDir);
            File fileIn = new File(storagePathFile, fileName);
            if (fileIn.exists()) {
                File outFile = new File(f, fileName);
                try {
                    FileUtils.copyFile(fileIn, outFile);
                }
                catch (IOException e) {
                    ExceptionHandler.handle("Impossible de copier le fichier vers le fichier temporaire de r\u00e9ception", e);
                    return null;
                }
            } else {
                JOptionPane.showMessageDialog(null, "Le fichier n'existe pas sur le serveur!", "Erreur fichier", 0);
            }
        }
        File outFile = new File(f, fileName);
        outFile.setReadOnly();
        return outFile;
    }

    public void deleteFile(Attachment rowAttachment) throws SQLException, IllegalStateException {
        ComptaPropsConfiguration config = ComptaPropsConfiguration.getInstanceCompta();
        if (!rowAttachment.isFolder()) {
            boolean isOnCloud = config.isOnCloud();
            String subDir = rowAttachment.getStoragePath();
            String fileName = rowAttachment.getStorageFileName();
            String remotePath = String.valueOf(config.getSocieteID()) + File.separator + subDir;
            if (isOnCloud) {
                remotePath = remotePath.replace('\\', '/');
            } else {
                File dirRoot = DocumentLocalStorageManager.getInstance().getDocumentOutputDirectory("EDMdirectory");
                File storagePathFile = new File(dirRoot, subDir);
                File f = new File(storagePathFile, fileName);
                if (f.exists() && !f.delete()) {
                    throw new IllegalStateException("Une erreur est survenue lors de la suppression du fichier");
                }
            }
        }
        config.getDirectory().getElement(AttachmentSQLElement.class).archive(rowAttachment.getId());
        this.updateAttachmentsCountFromAttachment(rowAttachment);
    }

    private void updateAttachmentsCountFromAttachment(Attachment rowAttachment) {
        ComptaPropsConfiguration config = ComptaPropsConfiguration.getInstanceCompta();
        SQLTable attachmentTable = config.getDirectory().getElement(AttachmentSQLElement.class).getTable();
        SQLTable table = attachmentTable.getTable(rowAttachment.getSourceTable());
        SQLRow source = table.getRow(rowAttachment.getSourceId());
        this.updateAttachmentsCountFromSource(source);
    }

    private void updateAttachmentsCountFromSource(SQLRow rowSource) {
        SQLTable tableSource = rowSource.getTable();
        SQLTable tableAtt = rowSource.getTable().getTable("ATTACHMENT");
        String req = "UPDATE " + tableSource.getSQLName().quote() + " SET " + tableSource.getField("ATTACHMENTS").getQuotedName() + "=(SELECT COUNT(*) FROM " + tableAtt.getSQLName().quote();
        req = String.valueOf(req) + " WHERE " + tableAtt.getArchiveField().getQuotedName() + "=0 AND " + tableAtt.getField("SOURCE_TABLE").getQuotedName() + "='" + tableSource.getName() + "'";
        req = String.valueOf(req) + " AND " + tableAtt.getField("SOURCE_ID").getQuotedName() + "=" + rowSource.getID() + ") WHERE " + tableSource.getKey().getQuotedName() + "=" + rowSource.getID();
        tableSource.getDBSystemRoot().getDataSource().execute(req);
    }

    public static void rename(Attachment rowAttachment, String newName) {
        rowAttachment.setName(newName);
        ComptaPropsConfiguration config = ComptaPropsConfiguration.getInstanceCompta();
        SQLTable attachmentTable = config.getDirectory().getElement(AttachmentSQLElement.class).getTable();
        String req = "UPDATE " + attachmentTable.getSQLName().quote() + " SET " + attachmentTable.getField("NAME").getQuotedName() + "=" + attachmentTable.getBase().quoteString(newName) + " WHERE " + attachmentTable.getKey().getQuotedName() + "=" + rowAttachment.getId();
        attachmentTable.getDBSystemRoot().getDataSource().execute(req);
    }

    public void createFolder(String folderName, SQLRowAccessor rowSource, int idParent) throws SQLException {
        SQLRowValues rowValsAttachment = new SQLRowValues(rowSource.getTable().getTable("ATTACHMENT"));
        rowValsAttachment.put("SOURCE_TABLE", rowSource.getTable().getName());
        rowValsAttachment.put("SOURCE_ID", rowSource.getID());
        rowValsAttachment.put("ID_PARENT", idParent);
        rowValsAttachment.put("NAME", folderName);
        rowValsAttachment.put("SOURCE_TABLE", rowSource.getTable().getName());
        rowValsAttachment.put("SOURCE_ID", rowSource.getID());
        rowValsAttachment.put("MIMETYPE", "inode/directory");
        rowValsAttachment.put("FILENAME", "");
        rowValsAttachment.put("FILESIZE", 0);
        rowValsAttachment.put("STORAGE_PATH", "");
        rowValsAttachment.put("STORAGE_FILENAME", "");
        rowValsAttachment.commit();
    }

    public void move(Attachment a, Attachment folder) {
        if (!folder.isFolder()) {
            throw new IllegalArgumentException(folder + " is not a folder");
        }
        this.move(a, folder.getId());
    }

    public void move(Attachment a, int folderId) {
        ComptaPropsConfiguration config = ComptaPropsConfiguration.getInstanceCompta();
        SQLTable attachmentTable = config.getDirectory().getElement(AttachmentSQLElement.class).getTable();
        String req = "UPDATE " + attachmentTable.getSQLName().quote() + " SET " + attachmentTable.getField("ID_PARENT").getQuotedName() + "=" + folderId + " WHERE " + attachmentTable.getKey().getQuotedName() + "=" + a.getId();
        attachmentTable.getDBSystemRoot().getDataSource().execute(req);
    }
}

