/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.element;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openconcerto.erp.core.common.component.AdresseSQLComponent;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.customerrelationship.customer.element.ContactItemTable;
import org.openconcerto.erp.core.customerrelationship.customer.ui.AdresseClientItemTable;
import org.openconcerto.erp.core.sales.product.element.ClientCodeArticleTable;
import org.openconcerto.erp.preferences.ModeReglementDefautPrefPanel;
import org.openconcerto.erp.utils.TM;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.GroupSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.sqlobject.SQLSearchableTextCombo;
import org.openconcerto.sql.ui.textmenu.TextFieldWithMenu;
import org.openconcerto.sql.ui.textmenu.TextFieldWithMenuItemsTableFetcher;
import org.openconcerto.sql.ui.textmenu.TextFieldWithWebBrowsing;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.utils.ExceptionHandler;

public class CustomerSQLComponent
extends GroupSQLComponent {
    private ContactItemTable table;
    private ClientCodeArticleTable tableCustomProduct;
    private AdresseClientItemTable adresseTable = new AdresseClientItemTable();
    private SQLTable contactTable = Configuration.getInstance().getDirectory().getElement("CONTACT").getTable();
    private final SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
    private final JUniqueTextField code = new JUniqueTextField(20){

        @Override
        public String getAutoRefreshNumber() {
            if (CustomerSQLComponent.this.getMode() == SQLComponent.Mode.INSERTION) {
                return NumerotationAutoSQLElement.getNextNumero(CustomerSQLComponent.this.getElement().getClass());
            }
            return null;
        }
    };
    private SQLRowValues defaultContactRowVals = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(this.contactTable));
    private JCheckBox checkAdrLivraison;
    private JCheckBox checkAdrFacturation;

    public CustomerSQLComponent(SQLElement element) {
        super(element);
        this.table = new ContactItemTable(this.defaultContactRowVals);
        this.tableCustomProduct = new ClientCodeArticleTable();
        this.table.setPreferredSize(new Dimension(this.table.getSize().width, 150));
    }

    @Override
    protected Set<String> createRequiredNames() {
        HashSet<String> s = new HashSet<String>();
        s.add("NOM");
        s.add("ID_ADRESSE");
        s.add("ID_MODE_REGLEMENT");
        return s;
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        rowVals.put("CODE", NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()));
        try {
            SQLRow r = ModeReglementDefautPrefPanel.getDefaultRow(true);
            SQLElement eltModeReglement = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
            if (r.getID() > 1) {
                SQLRowValues rowValsMR = eltModeReglement.createCopy(r, null);
                rowVals.put("ID_MODE_REGLEMENT", (Object)rowValsMR);
            }
        }
        catch (SQLException e) {
            System.err.println("Impossible de s\u00e9lectionner le mode de r\u00e8glement par d\u00e9faut du client.");
            e.printStackTrace();
        }
        return rowVals;
    }

    @Override
    public JComponent createEditor(String id) {
        if (id.equals("CATEGORIES")) {
            TextFieldWithMenuItemsTableFetcher itemsFetcher = new TextFieldWithMenuItemsTableFetcher(this.getTable().getTable("CATEGORIE_CLIENT").getField("NOM"));
            TextFieldWithMenu t = new TextFieldWithMenu(itemsFetcher, false);
            t.addAction(new AbstractAction(TM.tr("add", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditFrame frame = new EditFrame(CustomerSQLComponent.this.getElement().getDirectory().getElement("CATEGORIE_CLIENT"), EditPanel.EditMode.CREATION);
                    FrameUtil.showPacked(frame);
                }
            });
            t.addAction(new AbstractAction("Modifier/Supprimer"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SQLElement element = CustomerSQLComponent.this.getElement().getDirectory().getElement("CATEGORIE_CLIENT");
                    ListeAddPanel p = new ListeAddPanel(element);
                    IListFrame frame = new IListFrame(p);
                    FrameUtil.showPacked(frame);
                }
            });
            return t;
        }
        if (id.equals("GROUPE") || id.equals("FORME_JURIDIQUE") || id.equals("CENTRE_GESTION") || id.equals("METHODE_RELANCE")) {
            return new SQLSearchableTextCombo(ComboLockedMode.UNLOCKED, 1, 20, false);
        }
        if (id.equals("SITE_INTERNET")) {
            return new TextFieldWithWebBrowsing();
        }
        if (id.equals("DATE")) {
            return new JDate(true);
        }
        if (id.equals("customerrelationship.customer.contacts")) {
            return this.table;
        }
        if (id.equals("customerrelationship.customer.customproduct")) {
            return this.tableCustomProduct;
        }
        if (id.equals("customerrelationship.customer.addresses")) {
            return this.createAdressesComponent();
        }
        if (id.equals("NOM")) {
            return super.createEditor(id);
        }
        if (id.equals("CODE")) {
            return this.code;
        }
        if (id.equals("INFOS")) {
            return new ITextArea(4, 40);
        }
        if (id.equals("COMMENTAIRES")) {
            return new ITextArea(10, 40);
        }
        if (id.equals("TEL")) {
            final JTextField textTel = new JTextField(25);
            textTel.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    CustomerSQLComponent.this.defaultContactRowVals.put("TEL_DIRECT", textTel.getText());
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    CustomerSQLComponent.this.defaultContactRowVals.put("TEL_DIRECT", textTel.getText());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    CustomerSQLComponent.this.defaultContactRowVals.put("TEL_DIRECT", textTel.getText());
                }
            });
            return textTel;
        }
        if (id.equals("FAX")) {
            final JTextField textFax = new JTextField(25);
            textFax.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    CustomerSQLComponent.this.defaultContactRowVals.put("FAX", textFax.getText());
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    CustomerSQLComponent.this.defaultContactRowVals.put("FAX", textFax.getText());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    CustomerSQLComponent.this.defaultContactRowVals.put("FAX", textFax.getText());
                }
            });
            return textFax;
        }
        JComponent c = super.createEditor(id);
        return c;
    }

    @Override
    public JComponent getLabel(String id) {
        if (id.equals("ID_MODE_REGLEMENT") || id.equals("INFOS") || id.startsWith("ID_ADRESSE")) {
            JLabel l = (JLabel)super.getLabel(id);
            l.setFont(l.getFont().deriveFont(1));
            return l;
        }
        if (id.equals("customerrelationship.customer.contact")) {
            return new JLabelBold("Contacts");
        }
        if (id.equals("customerrelationship.customer.payment")) {
            return new JLabelBold("Mode de r\u00e8glement");
        }
        if (id.equals("customerrelationship.customer.address")) {
            return new JLabelBold("Adresses du client");
        }
        JComponent c = super.getLabel(id);
        return c;
    }

    @Override
    public void update() {
        super.update();
        int selectedID = this.getSelectedID();
        this.table.updateField("ID_CLIENT", selectedID);
        this.tableCustomProduct.updateField("ID_CLIENT", selectedID);
        this.adresseTable.updateField("ID_CLIENT", selectedID);
    }

    @Override
    public void select(SQLRowAccessor r) {
        super.select(r);
        this.checkAdrLivraison.setSelected(r == null || !r.getFields().contains("ID_ADRESSE_L") || r.isForeignEmpty("ID_ADRESSE_L"));
        this.checkAdrFacturation.setSelected(r == null || !r.getFields().contains("ID_ADRESSE_F") || r.isForeignEmpty("ID_ADRESSE_F"));
        if (r != null) {
            this.table.insertFrom("ID_CLIENT", r.asRowValues());
            this.tableCustomProduct.insertFrom("ID_CLIENT", r.asRowValues());
            this.adresseTable.insertFrom("ID_CLIENT", r.asRowValues());
        }
    }

    @Override
    public int insert(SQLRow order) {
        int id;
        String num;
        int attempt = 0;
        if (!this.code.checkValidation(false)) {
            while (attempt < JUniqueTextField.RETRY_COUNT) {
                num = NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass());
                this.code.setText(num);
                ++attempt;
                if (this.code.checkValidation(false)) {
                    System.err.println("ATEMPT " + attempt + " SUCCESS WITH NUMERO " + num);
                    break;
                }
                try {
                    Thread.sleep(JUniqueTextField.SLEEP_WAIT_MS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        num = this.code.getText();
        if (attempt == JUniqueTextField.RETRY_COUNT) {
            id = this.getSelectedID();
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de client existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
        } else {
            id = super.insert(order);
            this.table.updateField("ID_CLIENT", id);
            this.tableCustomProduct.updateField("ID_CLIENT", id);
            this.adresseTable.updateField("ID_CLIENT", id);
            if (NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()).equalsIgnoreCase(this.code.getText().trim())) {
                SQLRowValues rowVals = new SQLRowValues(this.tableNum);
                SQLRow rowNumAuto = this.tableNum.getRow(2);
                if (rowNumAuto.getObject("CLIENT_START") != null) {
                    int val = rowNumAuto.getInt("CLIENT_START");
                    rowVals.put("CLIENT_START", new Integer(++val));
                    try {
                        rowVals.update(2);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (attempt > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "Le num\u00e9ro a \u00e9t\u00e9 actualis\u00e9 en " + num);
                    }
                });
            }
        }
        return id;
    }

    private JComponent createAdressesComponent() {
        JTabbedPane tabbedAdresse = new JTabbedPane(){

            @Override
            public void insertTab(String title, Icon icon, Component component, String tip, int index) {
                if (component instanceof JComponent) {
                    ((JComponent)component).setOpaque(false);
                }
                super.insertTab(title, icon, component, tip, index);
            }
        };
        JPanel panelAdressePrincipale = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cPanel = new DefaultGridBagConstraints();
        cPanel.weightx = 1.0;
        cPanel.weighty = 1.0;
        cPanel.anchor = 11;
        this.addView("ID_ADRESSE", "required;notdecorated;noseparator");
        ElementSQLObject componentPrincipale = (ElementSQLObject)this.getView("ID_ADRESSE");
        ((AdresseSQLComponent)componentPrincipale.getSQLChild()).setDestinataireVisible(true);
        componentPrincipale.setOpaque(false);
        panelAdressePrincipale.add((Component)componentPrincipale, cPanel);
        tabbedAdresse.add(this.getLabelFor("ID_ADRESSE"), panelAdressePrincipale);
        tabbedAdresse.setOpaque(false);
        tabbedAdresse.add(this.getLabelFor("ID_ADRESSE_F"), this.createFacturationPanel());
        tabbedAdresse.add(this.getLabelFor("ID_ADRESSE_L"), this.createLivraisonPanel());
        String labelAdrSuppl = TM.tr("additional.address", new Object[0]);
        tabbedAdresse.add(labelAdrSuppl, this.adresseTable);
        return tabbedAdresse;
    }

    private Component createLivraisonPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        String field = "ID_ADRESSE_L";
        this.addView("ID_ADRESSE_L", "notdecorated;noseparator");
        final ElementSQLObject component = (ElementSQLObject)this.getView("ID_ADRESSE_L");
        AdresseSQLComponent adresseSQLComponent = (AdresseSQLComponent)component.getSQLChild();
        adresseSQLComponent.setDestinataireVisible(true);
        System.err.println("CustomerSQLComponent.createLivraisonPanel()" + component + " " + System.identityHashCode(component));
        System.err.println("CustomerSQLComponent.createLivraisonPanel()" + adresseSQLComponent + " " + System.identityHashCode(adresseSQLComponent));
        component.setOpaque(false);
        c.weightx = 1.0;
        this.checkAdrLivraison = new JCheckBox(TM.tr("delivery.address.same.main.address", new Object[0]));
        this.checkAdrLivraison.setOpaque(false);
        panel.add((Component)component, c);
        ++c.gridy;
        c.weighty = 1.0;
        c.anchor = 11;
        panel.add((Component)this.checkAdrLivraison, c);
        this.checkAdrLivraison.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = CustomerSQLComponent.this.checkAdrLivraison.isSelected();
                System.err.println("CustomerSQLComponent.createAdressesComponent().new ActionListener() {...}.actionPerformed() checkAdrLivraison " + b);
                component.setEditable(!b ? InteractionMode.READ_WRITE : InteractionMode.DISABLED);
                component.setCreated(!b);
            }
        });
        panel.setOpaque(false);
        return panel;
    }

    private Component createFacturationPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        String field = "ID_ADRESSE_F";
        this.addView("ID_ADRESSE_F", "notdecorated;noseparator");
        final ElementSQLObject component = (ElementSQLObject)this.getView("ID_ADRESSE_F");
        AdresseSQLComponent adresseSQLComponent = (AdresseSQLComponent)component.getSQLChild();
        System.err.println("CustomerSQLComponent.createFacturationPanel()" + component + " " + System.identityHashCode(component));
        System.err.println("CustomerSQLComponent.createFacturationPanel()" + adresseSQLComponent + " " + System.identityHashCode(adresseSQLComponent));
        adresseSQLComponent.setDestinataireVisible(true);
        component.setOpaque(false);
        c.weightx = 1.0;
        this.checkAdrFacturation = new JCheckBox(TM.tr("invoice.address.same.main.address", new Object[0]));
        this.checkAdrFacturation.setOpaque(false);
        c.anchor = 11;
        panel.add((Component)component, c);
        ++c.gridy;
        c.weighty = 1.0;
        c.anchor = 11;
        panel.add((Component)this.checkAdrFacturation, c);
        this.checkAdrFacturation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = CustomerSQLComponent.this.checkAdrFacturation.isSelected();
                System.err.println("CustomerSQLComponent.createAdressesComponent().new ActionListener() {...}.actionPerformed() checkAdrFacturation " + b);
                component.setEditable(!b ? InteractionMode.READ_WRITE : InteractionMode.DISABLED);
                component.setCreated(!b);
            }
        });
        panel.setOpaque(false);
        return panel;
    }
}

