/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.preferences.GestionCommercialeGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.Tuple2;

public class TotalCalculator {
    private static String FIELD_SERVICE = "SERVICE";
    private static String FIELD_POIDS = "T_POIDS";
    private final String fieldHT;
    private final String fieldHA;
    private final String fieldDevise;
    private boolean imputEcart = true;
    private SQLRowAccessor rowDefaultCptProduit;
    private SQLRowAccessor rowDefaultCptService;
    private SQLRowAccessor rowDefaultCptTVACollecte;
    private SQLRowAccessor rowDefaultCptTVADeductible;
    private SQLRowAccessor rowDefaultCptAchat;
    private SQLRowAccessor rowDefaultCptProduitStandard;
    private double totalPoids;
    private BigDecimal totalDevise;
    private BigDecimal totalDeviseSel;
    private BigDecimal totalHA;
    private BigDecimal totalHASel;
    private BigDecimal totalEco;
    private BigDecimal totalEcoSel;
    private BigDecimal totalService;
    private BigDecimal totalServiceSel;
    private BigDecimal totalHTSansFActurable;
    private BigDecimal totalTTC;
    private BigDecimal totalTTCSel;
    private long remiseHT;
    private long remiseRestante;
    private final boolean achat;
    private Map<SQLRowAccessor, BigDecimal> mapHt = new HashMap<SQLRowAccessor, BigDecimal>();
    private Map<SQLRowAccessor, BigDecimal> mapHtSel = new HashMap<SQLRowAccessor, BigDecimal>();
    private Map<SQLRowAccessor, BigDecimal> mapHtTVA = new HashMap<SQLRowAccessor, BigDecimal>();
    private Map<SQLRowAccessor, Map<SQLRowAccessor, BigDecimal>> mapHtTaxeCompl = new HashMap<SQLRowAccessor, Map<SQLRowAccessor, BigDecimal>>();
    private Map<SQLRowAccessor, BigDecimal> mapHtTVAIntra = new HashMap<SQLRowAccessor, BigDecimal>();
    private Map<SQLRowAccessor, BigDecimal> mapHtTVASel = new HashMap<SQLRowAccessor, BigDecimal>();
    private Map<SQLRowAccessor, Tuple2<BigDecimal, BigDecimal>> mapHtTVARowTaux = new HashMap<SQLRowAccessor, Tuple2<BigDecimal, BigDecimal>>();
    private int[] selectedRows;
    private Boolean bServiceActive;
    private BigDecimal totalHTAvantRemise;
    private boolean intraComm = false;
    private static Map<Integer, SQLRowAccessor> mapTVA;
    private static long lastTVAfetchedTime;
    final SQLTable tvaTable = Configuration.getInstance().getRoot().findTable("TAXE");
    final SQLTable compteTable = Configuration.getInstance().getRoot().findTable("COMPTE_PCE");

    static {
        lastTVAfetchedTime = 0L;
    }

    public TotalCalculator(String fieldHA, String fieldHT, String fieldDeviseTotal) {
        this(fieldHA, fieldHT, fieldDeviseTotal, false, null);
    }

    public void setRowDefaultCptService(SQLRowAccessor rowDefaultCptService) {
        this.rowDefaultCptService = rowDefaultCptService;
    }

    public void setIntraComm(boolean intraComm) {
        this.intraComm = intraComm;
    }

    public TotalCalculator(String fieldHA, String fieldHT, String fieldDeviseTotal, boolean achat, SQLRowAccessor defaultCompte) {
        this.achat = achat;
        this.initValues();
        this.fieldDevise = fieldDeviseTotal;
        this.fieldHA = fieldHA;
        this.fieldHT = fieldHT;
        SQLTable tablePrefCompte = Configuration.getInstance().getRoot().findTable("PREFS_COMPTE");
        SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
        SQLPreferences prefs = SQLPreferences.getMemCached(tablePrefCompte.getDBRoot());
        this.imputEcart = prefs.getBoolean(GestionCommercialeGlobalPreferencePanel.IMPUT_ECART, true);
        this.rowDefaultCptService = rowPrefsCompte.getForeign("ID_COMPTE_PCE_VENTE_SERVICE");
        if (this.rowDefaultCptService == null || this.rowDefaultCptService.isUndefined()) {
            try {
                this.rowDefaultCptService = ComptePCESQLElement.getRowComptePceDefault("VentesServices");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (defaultCompte == null || defaultCompte.isUndefined()) {
            this.rowDefaultCptProduit = rowPrefsCompte.getForeign("ID_COMPTE_PCE_VENTE_PRODUIT");
            if (this.rowDefaultCptProduit == null || this.rowDefaultCptProduit.isUndefined()) {
                try {
                    this.rowDefaultCptProduit = ComptePCESQLElement.getRowComptePceDefault("VentesProduits");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.rowDefaultCptProduit = defaultCompte;
        }
        this.rowDefaultCptProduitStandard = this.rowDefaultCptProduit;
        this.rowDefaultCptTVACollecte = rowPrefsCompte.getForeign("ID_COMPTE_PCE_TVA_VENTE");
        if (this.rowDefaultCptTVACollecte == null || this.rowDefaultCptTVACollecte.isUndefined()) {
            try {
                this.rowDefaultCptTVACollecte = ComptePCESQLElement.getRowComptePceDefault("TVACollectee");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.rowDefaultCptTVADeductible = rowPrefsCompte.getForeign("ID_COMPTE_PCE_TVA_ACHAT");
        if (this.rowDefaultCptTVADeductible == null || this.rowDefaultCptTVADeductible.isUndefined()) {
            try {
                this.rowDefaultCptTVADeductible = ComptePCESQLElement.getRowComptePceDefault("TVADeductible");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (defaultCompte == null || defaultCompte.isUndefined()) {
            this.rowDefaultCptAchat = rowPrefsCompte.getForeign("ID_COMPTE_PCE_ACHAT");
            if (this.rowDefaultCptAchat == null || this.rowDefaultCptAchat.isUndefined()) {
                try {
                    this.rowDefaultCptAchat = ComptePCESQLElement.getRowComptePceDefault("Achats");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.rowDefaultCptAchat = defaultCompte;
        }
    }

    public void setRowDefaultCptProduit(SQLRowAccessor rowDefaultCptProduit) {
        this.rowDefaultCptProduit = rowDefaultCptProduit;
    }

    public void retoreRowDefaultCptProduit() {
        this.rowDefaultCptProduit = this.rowDefaultCptProduitStandard;
    }

    public void setRemise(long remiseHT, BigDecimal totalHTAvantRemise) {
        this.remiseHT = remiseHT;
        this.remiseRestante = remiseHT;
        this.totalHTAvantRemise = totalHTAvantRemise;
    }

    public void setServiceActive(boolean b) {
        this.bServiceActive = b;
    }

    public void initValues() {
        this.remiseHT = 0L;
        this.remiseRestante = 0L;
        this.totalHTAvantRemise = BigDecimal.ZERO;
        this.selectedRows = null;
        this.totalHTSansFActurable = BigDecimal.ZERO;
        this.totalTTC = BigDecimal.ZERO;
        this.totalTTCSel = BigDecimal.ZERO;
        this.totalEco = BigDecimal.ZERO;
        this.totalEcoSel = BigDecimal.ZERO;
        this.totalHA = BigDecimal.ZERO;
        this.totalHASel = BigDecimal.ZERO;
        this.totalService = BigDecimal.ZERO;
        this.totalServiceSel = BigDecimal.ZERO;
        this.totalDeviseSel = BigDecimal.ZERO;
        this.totalDevise = BigDecimal.ZERO;
        this.totalPoids = 0.0;
        this.mapHt.clear();
        this.mapHtSel.clear();
        this.mapHtTVA.clear();
        this.mapHtTaxeCompl.clear();
        this.mapHtTVAIntra.clear();
        this.mapHtTVARowTaux.clear();
        this.mapHtTVASel.clear();
    }

    public void setSelectedRows(int[] selectedRows) {
        this.selectedRows = selectedRows;
    }

    public void addEchantillon(BigDecimal ht, SQLRowAccessor tva) {
        this.addHT(ht, ht, tva, this.rowDefaultCptProduit, false);
    }

    private void fetchTVA() {
        mapTVA = new HashMap<Integer, SQLRowAccessor>();
        SQLRowValues rowVals = new SQLRowValues(this.tvaTable);
        SQLRowValues rowValsC1 = new SQLRowValues(this.compteTable);
        rowValsC1.put("NUMERO", null);
        rowValsC1.put("ID", null);
        SQLRowValues rowValsC2 = new SQLRowValues(this.compteTable);
        rowValsC2.put("NUMERO", null);
        rowValsC2.put("ID", null);
        SQLRowValues rowValsC3 = new SQLRowValues(this.compteTable);
        rowValsC3.put("NUMERO", null);
        rowValsC3.put("ID", null);
        SQLRowValues rowValsC4 = new SQLRowValues(this.compteTable);
        rowValsC4.put("NUMERO", null);
        rowValsC4.put("ID", null);
        rowVals.put(this.tvaTable.getKey().getName(), null);
        rowVals.put("ID_COMPTE_PCE_COLLECTE", (Object)rowValsC1);
        rowVals.put("ID_COMPTE_PCE_DED", (Object)rowValsC2);
        rowVals.put("ID_COMPTE_PCE_VENTE", (Object)rowValsC3);
        rowVals.put("ID_COMPTE_PCE_VENTE_SERVICE", (Object)rowValsC4);
        if (this.tvaTable.contains("ID_COMPTE_PCE_COLLECTE_INTRA")) {
            SQLRowValues rowValsC1Intra = new SQLRowValues(this.compteTable);
            rowValsC1Intra.put("NUMERO", null);
            rowValsC1Intra.put("ID", null);
            rowVals.put("ID_COMPTE_PCE_COLLECTE_INTRA", (Object)rowValsC1Intra);
            SQLRowValues rowValsC2Intra = new SQLRowValues(this.compteTable);
            rowValsC2Intra.put("NUMERO", null);
            rowValsC2Intra.put("ID", null);
            rowVals.put("ID_COMPTE_PCE_DED_INTRA", (Object)rowValsC2Intra);
        }
        SQLRowValuesListFetcher fetch = SQLRowValuesListFetcher.create(rowVals);
        List<SQLRowValues> rowValsList = fetch.fetch();
        for (SQLRowValues sqlRowValues : rowValsList) {
            mapTVA.put(sqlRowValues.getID(), sqlRowValues);
        }
        lastTVAfetchedTime = System.currentTimeMillis();
    }

    private void addHT(BigDecimal ht, BigDecimal htSansFacturable, SQLRowAccessor tva, SQLRowAccessor cptArticle, boolean selection) {
        BigDecimal l;
        BigDecimal totalTVA;
        BigDecimal ttc;
        if (tva == null || tva.isUndefined()) {
            ttc = ht;
            totalTVA = BigDecimal.ZERO;
        } else {
            BigDecimal tauxTVA = BigDecimal.valueOf(TaxeCache.getCache().getTauxFromId(tva.getID()).floatValue()).movePointLeft(2);
            ttc = tauxTVA.add(BigDecimal.ONE).multiply(ht, DecimalUtils.HIGH_PRECISION);
            totalTVA = ttc.subtract(ht);
        }
        if (tva != null && !tva.isUndefined()) {
            Object l2;
            SQLRowAccessor rowCptTva;
            if (this.intraComm) {
                SQLRowAccessor rowCptTvaIntra;
                rowCptTva = tva.getForeign("ID_COMPTE_PCE_DED_INTRA");
                if (rowCptTva == null || rowCptTva.isUndefined()) {
                    rowCptTva = this.rowDefaultCptTVADeductible;
                }
                if ((rowCptTvaIntra = tva.getForeign("ID_COMPTE_PCE_COLLECTE_INTRA")) == null || rowCptTvaIntra.isUndefined()) {
                    rowCptTvaIntra = this.rowDefaultCptTVADeductible;
                }
                if (this.mapHtTVAIntra.get(rowCptTvaIntra) == null) {
                    this.mapHtTVAIntra.put(rowCptTvaIntra, totalTVA);
                }
                ht = ttc;
            } else if (this.achat) {
                rowCptTva = tva.getForeign("ID_COMPTE_PCE_DED");
                if (rowCptTva == null || rowCptTva.isUndefined()) {
                    rowCptTva = this.rowDefaultCptTVADeductible;
                }
            } else {
                rowCptTva = tva.getForeign("ID_COMPTE_PCE_COLLECTE");
                if (rowCptTva == null || rowCptTva.isUndefined()) {
                    rowCptTva = this.rowDefaultCptTVACollecte;
                }
            }
            if (this.mapHtTVA.get(rowCptTva) == null) {
                this.mapHtTVA.put(rowCptTva, totalTVA);
            } else {
                l2 = this.mapHtTVA.get(rowCptTva);
                this.mapHtTVA.put(rowCptTva, ((BigDecimal)l2).add(totalTVA));
            }
            if (ht.signum() != 0) {
                if (this.mapHtTVARowTaux.get(tva) == null) {
                    this.mapHtTVARowTaux.put(tva, Tuple2.create(ht, totalTVA));
                } else {
                    l2 = this.mapHtTVARowTaux.get(tva);
                    this.mapHtTVARowTaux.put(tva, Tuple2.create(ht.add((BigDecimal)((Tuple2)l2).get0()), ((BigDecimal)((Tuple2)l2).get1()).add(totalTVA)));
                }
            }
            if (selection) {
                if (this.mapHtTVASel.get(rowCptTva) == null) {
                    this.mapHtTVASel.put(rowCptTva, totalTVA);
                } else {
                    l2 = this.mapHtTVASel.get(rowCptTva);
                    this.mapHtTVASel.put(rowCptTva, ((BigDecimal)l2).add(totalTVA));
                }
            }
        }
        if (this.mapHt.get(cptArticle) == null) {
            this.mapHt.put(cptArticle, ht);
        } else {
            l = this.mapHt.get(cptArticle);
            this.mapHt.put(cptArticle, l.add(ht));
        }
        this.totalTTC = this.totalTTC.add(ttc);
        this.totalHTSansFActurable = this.totalHTSansFActurable.add(htSansFacturable);
        if (selection) {
            if (this.mapHtSel.get(cptArticle) == null) {
                this.mapHtSel.put(cptArticle, ht);
            } else {
                l = this.mapHtSel.get(cptArticle);
                this.mapHtSel.put(cptArticle, l.add(ht));
            }
            this.totalTTCSel = this.totalTTCSel.add(ttc);
        }
    }

    private static boolean containsInt(int[] tab, int i) {
        if (tab == null) {
            return false;
        }
        int j = 0;
        while (j < tab.length) {
            if (tab[j] == i) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public void addLine(SQLRowAccessor rowAccessorLine, SQLRowAccessor article, int lineNumber, boolean last) {
        SQLRowAccessor cpt;
        if (rowAccessorLine.getFields().contains("NIVEAU") && rowAccessorLine.getInt("NIVEAU") != 1) {
            return;
        }
        BigDecimal totalLineHT = rowAccessorLine.getObject(this.fieldHT) == null ? BigDecimal.ZERO : (BigDecimal)rowAccessorLine.getObject(this.fieldHT);
        BigDecimal totalLineEco = rowAccessorLine.getObject("T_ECO_CONTRIBUTION") == null ? BigDecimal.ZERO : (BigDecimal)rowAccessorLine.getObject("T_ECO_CONTRIBUTION");
        BigDecimal totalLineHTSansFacturable = totalLineHT;
        if (!this.achat) {
            totalLineHTSansFacturable = rowAccessorLine.getObject("PV_HT") == null ? BigDecimal.ZERO : (BigDecimal)rowAccessorLine.getObject("PV_HT");
            BigDecimal qteUV = rowAccessorLine.getObject("QTE_UNITAIRE") == null ? BigDecimal.ZERO : (BigDecimal)rowAccessorLine.getObject("QTE_UNITAIRE");
            int qte = rowAccessorLine.getInt("QTE");
            totalLineHTSansFacturable = totalLineHTSansFacturable.multiply(qteUV).multiply(new BigDecimal(qte));
        }
        BigDecimal totalHALigne = rowAccessorLine.getObject(this.fieldHA) == null ? BigDecimal.ZERO : (BigDecimal)rowAccessorLine.getObject(this.fieldHA);
        Boolean service = rowAccessorLine.getBoolean(FIELD_SERVICE);
        BigDecimal totalLineDevise = this.fieldDevise == null || rowAccessorLine.getObject(this.fieldDevise) == null ? BigDecimal.ZERO : (BigDecimal)rowAccessorLine.getObject(this.fieldDevise);
        Number nPoids = (Number)rowAccessorLine.getObject(FIELD_POIDS);
        if (this.remiseHT != 0L && this.remiseRestante > 0L && this.totalHTAvantRemise != null && this.totalHTAvantRemise.signum() != 0) {
            if (last) {
                totalLineHT = totalLineHT.subtract(new BigDecimal(this.remiseRestante).movePointLeft(2));
                totalLineHTSansFacturable = totalLineHTSansFacturable.subtract(new BigDecimal(this.remiseRestante).movePointLeft(2));
                this.remiseRestante = 0L;
            } else {
                BigDecimal percent = totalLineHT.divide(this.totalHTAvantRemise, DecimalUtils.HIGH_PRECISION);
                BigDecimal remiseApply = percent.multiply(new BigDecimal(this.remiseHT), DecimalUtils.HIGH_PRECISION).setScale(0, RoundingMode.HALF_UP);
                totalLineHT = totalLineHT.subtract(remiseApply.movePointLeft(2));
                totalLineHTSansFacturable = totalLineHTSansFacturable.subtract(remiseApply.movePointLeft(2));
                this.remiseRestante -= remiseApply.longValue();
            }
        }
        if (mapTVA == null || lastTVAfetchedTime + 30000L < System.currentTimeMillis()) {
            this.fetchTVA();
        }
        SQLRowAccessor foreignTVA = rowAccessorLine.getForeign("ID_TAXE");
        Integer idTVA = null;
        if (foreignTVA != null) {
            idTVA = foreignTVA.getID();
        }
        SQLRowAccessor tva = mapTVA.get(idTVA);
        SQLRowAccessor sQLRowAccessor = cpt = this.achat ? this.rowDefaultCptAchat : this.rowDefaultCptProduit;
        if (!this.achat) {
            if (this.bServiceActive != null && this.bServiceActive.booleanValue() && service != null && service.booleanValue()) {
                this.totalService = this.totalService.add(totalLineHT);
                cpt = this.rowDefaultCptService;
                if (tva != null && !tva.isForeignEmpty("ID_COMPTE_PCE_VENTE_SERVICE")) {
                    cpt = tva.getForeign("ID_COMPTE_PCE_VENTE_SERVICE");
                }
            } else if (tva != null && !tva.isForeignEmpty("ID_COMPTE_PCE_VENTE")) {
                cpt = tva.getForeign("ID_COMPTE_PCE_VENTE");
            }
        }
        if (article != null && !article.isUndefined()) {
            String suffix = this.achat ? "_ACHAT" : "";
            SQLRowAccessor compteArticle = article.getForeign("ID_COMPTE_PCE" + suffix);
            if (compteArticle != null && !compteArticle.isUndefined()) {
                cpt = compteArticle;
            } else {
                SQLRowAccessor familleArticle = article.getForeign("ID_FAMILLE_ARTICLE");
                HashSet<SQLRowAccessor> unique = new HashSet<SQLRowAccessor>();
                while (familleArticle != null && !familleArticle.isUndefined() && !unique.contains(familleArticle)) {
                    unique.add(familleArticle);
                    SQLRowAccessor compteFamilleArticle = familleArticle.getForeign("ID_COMPTE_PCE" + suffix);
                    if (compteFamilleArticle != null && !compteFamilleArticle.isUndefined()) {
                        cpt = compteFamilleArticle;
                        break;
                    }
                    familleArticle = familleArticle.getForeign("ID_FAMILLE_ARTICLE_PERE");
                }
            }
            if (!this.achat) {
                SQLRowAccessor taxeCompl;
                SQLRowAccessor sQLRowAccessor2 = taxeCompl = article.getFields().contains("ID_TAXE_COMPLEMENTAIRE") && article.getObject("ID_TAXE_COMPLEMENTAIRE") != null && !article.isForeignEmpty("ID_TAXE_COMPLEMENTAIRE") ? article.getForeign("ID_TAXE_COMPLEMENTAIRE") : null;
                if (taxeCompl != null && !taxeCompl.isUndefined()) {
                    BigDecimal b;
                    Map<SQLRowAccessor, BigDecimal> mapCptTaxeValue = this.mapHtTaxeCompl.get(cpt);
                    if (mapCptTaxeValue == null) {
                        mapCptTaxeValue = new HashMap<SQLRowAccessor, BigDecimal>();
                        this.mapHtTaxeCompl.put(cpt, mapCptTaxeValue);
                    }
                    if ((b = mapCptTaxeValue.get(taxeCompl)) == null) {
                        b = BigDecimal.ZERO;
                    }
                    b = b.add(totalLineHT);
                    mapCptTaxeValue.put(taxeCompl, b);
                }
            }
        }
        if (this.achat && this.bServiceActive != null && this.bServiceActive.booleanValue() && service != null && service.booleanValue()) {
            this.totalService = this.totalService.add(totalLineHT);
            cpt = this.rowDefaultCptService;
        }
        this.totalHA = this.totalHA.add(totalHALigne);
        if (totalLineDevise != null) {
            this.totalDevise = this.totalDevise.add(totalLineDevise);
        }
        this.totalPoids += nPoids == null ? 0.0 : nPoids.doubleValue();
        this.totalEco = this.totalEco.add(totalLineEco);
        boolean selection = TotalCalculator.containsInt(this.selectedRows, lineNumber);
        if (selection) {
            this.totalHASel = this.totalHASel.add(totalHALigne);
            if (this.bServiceActive != null && this.bServiceActive.booleanValue() && service != null && service.booleanValue()) {
                this.totalServiceSel = this.totalServiceSel.add(totalLineHT);
            }
            this.totalEcoSel = this.totalEcoSel.add(totalLineEco);
            if (totalLineDevise != null) {
                this.totalDeviseSel = this.totalDeviseSel.add(totalLineDevise);
            }
        }
        this.addHT(totalLineHT, totalLineHTSansFacturable, tva, cpt, selection);
    }

    public void checkResult() {
        BigDecimal ht = this.getTotalHT();
        BigDecimal tva = this.getTotalTVA();
        BigDecimal totalTTC2 = this.getTotalTTC();
        BigDecimal reste = totalTTC2.subtract(ht.add(tva));
        if (!this.intraComm && reste.compareTo(BigDecimal.ZERO) != 0) {
            System.err.print("Ecarts: " + reste + "(HT:" + ht);
            System.err.print(" TVA:" + tva);
            System.err.println(" TTC:" + totalTTC2);
            if (!this.imputEcart) {
                for (SQLRowAccessor rHT : this.mapHt.keySet()) {
                    BigDecimal input = this.mapHt.get(rHT);
                    if (input == null || input.signum() == 0) continue;
                    this.mapHt.put(rHT, input.add(reste));
                    break;
                }
            } else {
                SQLRow row = ComptePCESQLElement.getRow("758", "Ecarts arrondis");
                this.mapHt.put(row, reste);
            }
        }
    }

    public BigDecimal getTotalDevise() {
        return this.totalDevise;
    }

    public BigDecimal getTotalDeviseSel() {
        return this.totalDeviseSel;
    }

    public BigDecimal getTotalHA() {
        return this.totalHA;
    }

    public BigDecimal getTotalHASel() {
        return this.totalHASel;
    }

    public double getTotalPoids() {
        return this.totalPoids;
    }

    public BigDecimal getTotalService() {
        return this.totalService;
    }

    public BigDecimal getTotalServiceSel() {
        return this.totalServiceSel;
    }

    public Map<SQLRowAccessor, Map<SQLRowAccessor, BigDecimal>> getMapHtTaxeCompl() {
        return this.mapHtTaxeCompl;
    }

    public BigDecimal getTotalHT() {
        BigDecimal ht = BigDecimal.ZERO;
        for (SQLRowAccessor row : this.mapHt.keySet()) {
            ht = ht.add(this.mapHt.get(row).setScale(2, RoundingMode.HALF_UP));
        }
        return ht;
    }

    public BigDecimal getTotalTVA() {
        BigDecimal tva = BigDecimal.ZERO;
        for (SQLRowAccessor row : this.mapHtTVA.keySet()) {
            tva = tva.add(this.mapHtTVA.get(row).setScale(2, RoundingMode.HALF_UP));
        }
        return tva;
    }

    public BigDecimal getTotalEco() {
        return this.totalEco.setScale(2, RoundingMode.HALF_UP);
    }

    public BigDecimal getTotalEcoSel() {
        return this.totalEcoSel.setScale(2, RoundingMode.HALF_UP);
    }

    public BigDecimal getTotalHTSansFActurable() {
        return this.totalHTSansFActurable;
    }

    public BigDecimal getTotalTTC() {
        return this.totalTTC.setScale(2, RoundingMode.HALF_UP);
    }

    public BigDecimal getTotalHTSel() {
        BigDecimal ht = BigDecimal.ZERO;
        for (SQLRowAccessor row : this.mapHtSel.keySet()) {
            ht = ht.add(this.mapHtSel.get(row).setScale(2, RoundingMode.HALF_UP));
        }
        return ht;
    }

    public BigDecimal getTotalTVASel() {
        BigDecimal tva = BigDecimal.ZERO;
        for (SQLRowAccessor row : this.mapHtTVASel.keySet()) {
            tva = tva.add(this.mapHtTVASel.get(row).setScale(2, RoundingMode.HALF_UP));
        }
        return tva;
    }

    public BigDecimal getTotalTTCSel() {
        return this.totalTTCSel.setScale(2, RoundingMode.HALF_UP);
    }

    public Map<SQLRowAccessor, BigDecimal> getMapHt() {
        return this.mapHt;
    }

    public Map<SQLRowAccessor, Tuple2<BigDecimal, BigDecimal>> getMapHtTVARowTaux() {
        return this.mapHtTVARowTaux;
    }

    public Map<SQLRowAccessor, BigDecimal> getMapHtTVA() {
        return this.mapHtTVA;
    }

    public Map<SQLRowAccessor, BigDecimal> getMapHtTVAIntra() {
        return this.mapHtTVAIntra;
    }
}

