/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import net.jcip.annotations.Immutable;
import org.openconcerto.utils.CompareUtils;

public class TimeUtils {
    private static DatatypeFactory typeFactory = null;
    private static List<DatatypeConstants.Field> FIELDS_LIST = Arrays.asList(DatatypeConstants.YEARS, DatatypeConstants.MONTHS, DatatypeConstants.DAYS, DatatypeConstants.HOURS, DatatypeConstants.MINUTES, DatatypeConstants.SECONDS);
    private static List<DatatypeConstants.Field> DATE_FIELDS;
    private static List<DatatypeConstants.Field> TIME_FIELDS;

    static {
        int dayIndex = FIELDS_LIST.indexOf(DatatypeConstants.DAYS);
        DATE_FIELDS = Collections.unmodifiableList(FIELDS_LIST.subList(0, dayIndex + 1));
        TIME_FIELDS = Collections.unmodifiableList(FIELDS_LIST.subList(dayIndex + 1, FIELDS_LIST.size()));
    }

    public static List<DatatypeConstants.Field> getAllFields() {
        return FIELDS_LIST;
    }

    public static List<DatatypeConstants.Field> getDateFields() {
        return DATE_FIELDS;
    }

    public static List<DatatypeConstants.Field> getTimeFields() {
        return TIME_FIELDS;
    }

    private static Class<? extends Number> getFieldClass(DatatypeConstants.Field f) {
        return f == DatatypeConstants.SECONDS ? BigDecimal.class : BigInteger.class;
    }

    public static final DatatypeFactory getTypeFactory() {
        if (typeFactory == null) {
            try {
                typeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }
        return typeFactory;
    }

    private static final <N extends Number> N getZeroIfNull(Number n, Class<N> clazz) {
        Number res;
        if (n != null) {
            res = n;
        } else if (clazz == BigInteger.class) {
            res = BigInteger.ZERO;
        } else if (clazz == BigDecimal.class) {
            res = BigDecimal.ZERO;
        } else {
            throw new IllegalArgumentException("Unknown class : " + n);
        }
        return (N)((Number)clazz.cast(res));
    }

    private static final <N extends Number> N getNullIfZero(N n) {
        if (n == null) {
            return null;
        }
        boolean isZero = n instanceof BigInteger ? n.intValue() == 0 : ((BigDecimal)n).compareTo(BigDecimal.ZERO) == 0;
        return isZero ? null : (N)n;
    }

    public static final BigDecimal getSeconds(Duration d) {
        return TimeUtils.getZeroIfNull(d.getField(DatatypeConstants.SECONDS), BigDecimal.class);
    }

    public static final Duration timePartToDuration(Calendar cal) {
        BigDecimal seconds = BigDecimal.valueOf(cal.get(13)).add(BigDecimal.valueOf(cal.get(14)).movePointLeft(3));
        return TimeUtils.getTypeFactory().newDuration(true, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.valueOf(cal.get(11)), BigInteger.valueOf(cal.get(12)), seconds);
    }

    public static final Duration trimDuration(Duration dur) {
        return DurationNullsChanger.ALL_TO_NULL.apply(dur);
    }

    public static final Duration removeNulls(Duration dur) {
        return DurationNullsChanger.NONE_TO_NULL.apply(dur);
    }

    public static final long normalizeLocalTime(Calendar cal) {
        return cal.getTimeInMillis() + (long)cal.getTimeZone().getOffset(cal.getTimeInMillis());
    }

    public static final Calendar copyLocalTime(Calendar from, Calendar to) throws IllegalArgumentException {
        Calendar dest;
        Calendar source;
        boolean createGregDest;
        boolean sameClass = from.getClass() == to.getClass();
        boolean createGregSource = !sameClass && to.getClass() == GregorianCalendar.class;
        boolean bl = createGregDest = !sameClass && from.getClass() == GregorianCalendar.class;
        if (!(sameClass || createGregSource || createGregDest)) {
            throw new IllegalArgumentException("Calendars mismatch " + from.getClass() + " != " + to.getClass());
        }
        Calendar calendar = source = createGregSource ? new GregorianCalendar(from.getTimeZone()) : from;
        if (createGregSource) {
            source.setTime(from.getTime());
        }
        Calendar calendar2 = dest = createGregDest ? new GregorianCalendar(to.getTimeZone()) : to;
        assert (source.getClass() == dest.getClass());
        if (source.getTimeZone().equals(dest.getTimeZone())) {
            dest.setTimeInMillis(source.getTimeInMillis());
        } else {
            dest.clear();
            int[] nArray = new int[7];
            nArray[1] = 1;
            nArray[2] = 6;
            nArray[3] = 11;
            nArray[4] = 12;
            nArray[5] = 13;
            nArray[6] = 14;
            int[] nArray2 = nArray;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int field = nArray2[n2];
                dest.set(field, source.get(field));
                ++n2;
            }
        }
        if (createGregDest) {
            to.setTime(dest.getTime());
        }
        return to;
    }

    public static final boolean isAmbiguous(Calendar cal) {
        return TimeUtils.isAmbiguous(TimeUtils.getDSTChange(cal));
    }

    public static final boolean isAmbiguous(DSTChange dstChange) {
        return dstChange == DSTChange.BEFORE_WINTER || dstChange == DSTChange.AFTER_WINTER;
    }

    public static final DSTChange getDSTChange(Calendar cal) {
        TimeZone tz = cal.getTimeZone();
        if (!tz.useDaylightTime()) {
            return DSTChange.NO;
        }
        long currentMillis = cal.getTimeInMillis();
        int hourInMillis = tz.getDSTSavings();
        boolean isSTBefore = tz.inDaylightTime(new Date(currentMillis - (long)hourInMillis));
        boolean isST = tz.inDaylightTime(new Date(currentMillis));
        boolean isSTAfter = tz.inDaylightTime(new Date(currentMillis + (long)hourInMillis));
        if (isSTBefore != isST) {
            assert (isST == isSTAfter);
            return isSTBefore ? DSTChange.AFTER_WINTER : DSTChange.AFTER_SUMMER;
        }
        if (isST != isSTAfter) {
            assert (isST == isSTBefore);
            return isSTAfter ? DSTChange.BEFORE_SUMMER : DSTChange.BEFORE_WINTER;
        }
        return DSTChange.NO;
    }

    public static final Calendar clearTime(Calendar cal) {
        cal.set(11, 0);
        cal.clear(12);
        cal.clear(13);
        cal.clear(14);
        return cal;
    }

    public static final boolean isSameDay(Calendar date1, Date date2) {
        return TimeUtils.isSameDay((Calendar)date1.clone(), date1.getTime(), date2);
    }

    public static final boolean isSameDay(Calendar cal, Date date1, Date date2) {
        cal.setTime(date1);
        TimeUtils.clearTime(cal);
        long day1 = cal.getTimeInMillis();
        cal.setTime(date2);
        TimeUtils.clearTime(cal);
        long day2 = cal.getTimeInMillis();
        return day1 == day2;
    }

    public static enum DSTChange {
        NO,
        BEFORE_SUMMER,
        AFTER_SUMMER,
        BEFORE_WINTER,
        AFTER_WINTER;

    }

    public static final class DurationNullsBuilder {
        private final Map<DatatypeConstants.Field, EmptyFieldPolicy> policy = new HashMap<DatatypeConstants.Field, EmptyFieldPolicy>();

        public DurationNullsBuilder() {
            this(EmptyFieldPolicy.AS_IS);
        }

        public DurationNullsBuilder(EmptyFieldPolicy initialPolicy) {
            this.setPolicy(FIELDS_LIST, initialPolicy);
        }

        public final void setPolicy(Collection<DatatypeConstants.Field> fields, EmptyFieldPolicy to) {
            for (DatatypeConstants.Field f : fields) {
                this.policy.put(f, to);
            }
        }

        public final DurationNullsBuilder setToNull(Collection<DatatypeConstants.Field> fields) {
            this.setPolicy(fields, EmptyFieldPolicy.SET_TO_NULL);
            return this;
        }

        public final DurationNullsBuilder setToZero(Collection<DatatypeConstants.Field> fields) {
            this.setPolicy(fields, EmptyFieldPolicy.SET_TO_ZERO);
            return this;
        }

        public final DurationNullsBuilder dontChange(Collection<DatatypeConstants.Field> fields) {
            this.setPolicy(fields, EmptyFieldPolicy.AS_IS);
            return this;
        }

        public final DurationNullsChanger build() {
            return new DurationNullsChanger(this.policy);
        }
    }

    @Immutable
    public static final class DurationNullsChanger {
        public static final DurationNullsChanger ALL_TO_NULL = new DurationNullsBuilder(EmptyFieldPolicy.SET_TO_NULL).build();
        public static final DurationNullsChanger NONE_TO_NULL = new DurationNullsBuilder(EmptyFieldPolicy.SET_TO_ZERO).build();
        private final Map<DatatypeConstants.Field, EmptyFieldPolicy> policy;

        private DurationNullsChanger(Map<DatatypeConstants.Field, EmptyFieldPolicy> policy) {
            this.policy = Collections.unmodifiableMap(new HashMap<DatatypeConstants.Field, EmptyFieldPolicy>(policy));
        }

        public final Duration apply(Duration dur) {
            boolean changed = false;
            HashMap<DatatypeConstants.Field, Number> newValues = new HashMap<DatatypeConstants.Field, Number>();
            for (DatatypeConstants.Field f : FIELDS_LIST) {
                Number newVal;
                Number oldVal = dur.getField(f);
                EmptyFieldPolicy pol = this.policy.get(f);
                if (pol == EmptyFieldPolicy.SET_TO_NULL) {
                    newVal = TimeUtils.getNullIfZero(oldVal);
                } else if (pol == EmptyFieldPolicy.SET_TO_ZERO) {
                    newVal = TimeUtils.getZeroIfNull(oldVal, TimeUtils.getFieldClass(f));
                } else {
                    assert (pol == EmptyFieldPolicy.AS_IS);
                    newVal = oldVal;
                }
                newValues.put(f, newVal);
                changed |= !CompareUtils.equals(newVal, oldVal);
            }
            if (!changed) {
                return dur;
            }
            return TimeUtils.getTypeFactory().newDuration(dur.getSign() >= 0, (BigInteger)newValues.get(DatatypeConstants.YEARS), (BigInteger)newValues.get(DatatypeConstants.MONTHS), (BigInteger)newValues.get(DatatypeConstants.DAYS), (BigInteger)newValues.get(DatatypeConstants.HOURS), (BigInteger)newValues.get(DatatypeConstants.MINUTES), (BigDecimal)newValues.get(DatatypeConstants.SECONDS));
        }
    }

    public static enum EmptyFieldPolicy {
        AS_IS,
        SET_TO_NULL,
        SET_TO_ZERO;

    }
}

