/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.Row;
import org.openconcerto.utils.io.JSONAble;
import org.openconcerto.utils.io.JSONConverter;

public class RowsBulk
implements Externalizable,
JSONAble {
    private List<Row> rows;
    private int offset;
    private int total;
    private boolean remove;

    public RowsBulk() {
    }

    public RowsBulk(JSONObject json) {
        this.fromJSON(json);
    }

    public RowsBulk(List<Row> rows, int offset, int total, boolean remove) {
        this.rows = rows;
        this.offset = offset;
        this.total = total;
        this.remove = remove;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int rowCount = in.readInt();
        if (rowCount == 0) {
            this.rows = Collections.emptyList();
        } else {
            this.rows = new ArrayList<Row>(rowCount);
            int columnCount = in.readByte();
            int j = 0;
            while (j < rowCount) {
                Row row = new Row((Number)in.readObject(), columnCount);
                this.rows.add(row);
                ++j;
            }
            int i = 0;
            while (i < columnCount) {
                int j2 = 0;
                while (j2 < rowCount) {
                    Object v = in.readObject();
                    this.rows.get(j2).addValue(v);
                    ++j2;
                }
                ++i;
            }
        }
        this.offset = in.readInt();
        this.total = in.readInt();
        this.remove = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int rowCount = this.rows.size();
        out.writeInt(rowCount);
        if (this.rows.size() > 0) {
            int columnCount = this.rows.get(0).getValues().size();
            out.writeByte(columnCount);
            int j = 0;
            while (j < rowCount) {
                Row row = this.rows.get(j);
                out.writeObject(row.getId());
                ++j;
            }
            int i = 0;
            while (i < columnCount) {
                int j2 = 0;
                while (j2 < rowCount) {
                    Row row = this.rows.get(j2);
                    Object v = row.getValues().get(i);
                    out.writeObject(v);
                    ++j2;
                }
                ++i;
            }
        }
        out.writeInt(this.offset);
        out.writeInt(this.total);
        out.writeBoolean(this.remove);
    }

    public final List<Row> getRows() {
        return this.rows;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getTotal() {
        return this.total;
    }

    public final boolean isRemove() {
        return this.remove;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject result = new JSONObject();
        result.put("class", "RowsBulk");
        result.put("rows", JSONConverter.getJSON(this.rows));
        result.put("offset", this.offset);
        result.put("total", this.total);
        result.put("remove", this.remove);
        return result;
    }

    @Override
    public void fromJSON(JSONObject json) {
        this.offset = JSONConverter.getParameterFromJSON(json, "offset", Integer.class);
        this.total = JSONConverter.getParameterFromJSON(json, "total", Integer.class);
        JSONArray jsonRows = JSONConverter.getParameterFromJSON(json, "rows", JSONArray.class);
        this.rows = new ArrayList<Row>();
        if (jsonRows != null) {
            for (Object o : jsonRows) {
                this.rows.add(new Row(JSONConverter.getObjectFromJSON(o, JSONObject.class)));
            }
        }
    }

    public String toString() {
        return String.valueOf(this.rows.size()) + " rows at offset " + this.offset + " (total:" + this.total + ") remove:" + this.remove;
    }
}

