/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list.search;

import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.FutureTask;
import javax.swing.SwingUtilities;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListAccess;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.UpdateQueue;
import org.openconcerto.sql.view.list.search.SearchAll;
import org.openconcerto.sql.view.list.search.SearchOne;
import org.openconcerto.sql.view.list.search.SearchRunnable;
import org.openconcerto.sql.view.search.SearchSpec;
import org.openconcerto.utils.IFutureTask;
import org.openconcerto.utils.SleepingQueue;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;

public final class SearchQueue
extends SleepingQueue {
    private final ITableModel model;
    SearchSpec search;
    private final ListAccess listAccess;
    private final IClosure<Deque<FutureTask<?>>> cancelClosure;

    public static boolean isSearch(FutureTask<?> f) {
        Runnable r = SearchQueue.getRunnable(f);
        return r instanceof SearchRunnable && ((SearchRunnable)r).performsSearch();
    }

    public static Runnable getRunnable(FutureTask<?> f) {
        if (f instanceof IFutureTask) {
            return ((IFutureTask)f).getRunnable();
        }
        return null;
    }

    public static String getLastReferentField(Path p) {
        Step lastStep = p.length() == 0 ? null : p.getStep(-1);
        boolean lastIsForeign = lastStep == null || lastStep.getDirection() == Link.Direction.FOREIGN;
        return lastIsForeign ? null : lastStep.getSingleField().getName();
    }

    public SearchQueue(ListAccess la) {
        super(String.valueOf(SearchQueue.class.getName()) + " on " + la.getModel());
        this.listAccess = la;
        this.model = la.getModel();
        this.search = null;
        this.cancelClosure = UpdateQueue.createCancelClosure(this, new ITransformer<FutureTask<?>, UpdateQueue.TaskType>(){

            @Override
            public UpdateQueue.TaskType transformChecked(FutureTask<?> input) {
                Runnable r = SearchQueue.getRunnable(input);
                if (r instanceof SearchRunnable) {
                    return UpdateQueue.TaskType.COMPUTE;
                }
                if (r instanceof SetStateRunnable) {
                    return UpdateQueue.TaskType.SET_STATE;
                }
                return UpdateQueue.TaskType.USER;
            }
        });
    }

    public void orderChanged() {
        this.put(new SearchRunnable(this){

            @Override
            protected boolean performsSearch() {
                return false;
            }

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.getAccess().setList(null, null);
                    }
                });
            }
        });
    }

    public void changeFullList(int id, ListSQLLine modifiedLine, Collection<Integer> modifiedCols, SearchOne.Mode mode) {
        SearchOne oneSearchRunnable = new SearchOne(this, id, modifiedLine, modifiedCols, mode);
        this.put(oneSearchRunnable);
    }

    public void fullListChanged() {
        this.fullDataChange();
    }

    public void setSearch(SearchSpec s) {
        this.setSearch(s, null);
    }

    public void setSearch(final SearchSpec s, final Runnable r) {
        this.tasksDo(new IClosure<Deque<FutureTask<?>>>(){

            @Override
            public void executeChecked(Deque<FutureTask<?>> input) {
                SearchQueue.this.put(new SetStateRunnable(){

                    @Override
                    public void run() {
                        (this).SearchQueue.this.search = s;
                    }
                });
                SearchQueue.this.fullDataChange();
                if (r != null) {
                    SearchQueue.this.put(new Runnable(){

                        @Override
                        public void run() {
                            SwingUtilities.invokeLater(r);
                        }
                    });
                }
            }
        });
    }

    private void fullDataChange() {
        this.put(new SearchAll(this));
    }

    @Override
    protected void willPut(FutureTask<?> qr) throws InterruptedException {
        if (SearchQueue.getRunnable(qr) instanceof SearchAll) {
            this.tasksDo(this.cancelClosure);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + " for " + this.getModel();
    }

    final SearchSpec getSearch() {
        return this.search;
    }

    final ListAccess getAccess() {
        return this.listAccess;
    }

    public final ITableModel getModel() {
        return this.model;
    }

    public static interface SetStateRunnable
    extends Runnable {
    }
}

