/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openconcerto.openoffice.ContentType;
import org.openconcerto.openoffice.OOUtils;
import org.openconcerto.openoffice.XMLFormatVersion;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.users.rights.TableAllRights;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.IListener;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.search.SearchListComponent;
import org.openconcerto.ui.ContinuousButtonModel;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.ui.component.JRadioButtons;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.change.ListChangeIndex;

public abstract class IListPanel
extends JPanel
implements ActionListener {
    public static final String CAN_CLONE = "org.openconcerto.sql.canCloneInList";
    private static final String EXPORT_DIR_KEY = "exportDir";
    protected static final String FALLBACK_KEY = "FALLBACK_ACTION";
    private static final String FILE_STRUCT_VERSION = "20161018";
    private final IListe liste;
    protected final SQLElement element;
    protected final BtnTooltipMnger btnMngr;
    protected JButton buttonActualiser;
    protected JButton buttonModifier;
    protected JButton buttonEffacer;
    protected JButton buttonAjouter;
    protected JButton buttonClone;
    protected JButton saveBtn;
    private JButton buttonPlus;
    private JButton buttonMoins;
    protected final JPanel searchPanel = new JPanel(new GridBagLayout());
    private static final Icon UP_ARROW = new ImageIcon(IListPanel.class.getResource("fleche_haut.png"));
    private static final Icon DOWN_ARROW = new ImageIcon(IListPanel.class.getResource("fleche_bas.png"));
    protected EditFrame createFrame;
    private boolean selectRowOnAdd = true;
    private boolean showReadOnlyFrameOnDoubleClick = true;
    private boolean deaf = Boolean.getBoolean("org.openconcerto.sql.listPanel.deafEditPanel");
    protected SearchListComponent searchComponent;

    public static final File getConfigFile(SQLElement elem, Class<? extends Container> c) {
        return IListPanel.getConfigFile(elem, c, null);
    }

    public static final File getConfigFile(SQLElement elem, Class<? extends Container> c, String variant) {
        String suffix = StringUtils.isEmpty(variant, true) ? "" : "-" + variant;
        return IListPanel.getConfigFile(c, String.valueOf(elem.getCode()) + suffix);
    }

    public static final File getConfigFile(Class<? extends Container> c, String code) {
        Configuration conf = Configuration.getInstance();
        if (conf == null) {
            return null;
        }
        File structFile = new File(conf.getConfDir(), "jtableState-20161018");
        return new File(structFile, String.valueOf(c.getSimpleName()) + File.separator + IListFrame.getConfigFileName(code));
    }

    private static final JButton createBtn(Icon i) {
        JButton res = new JButton(i);
        res.setMargin(new Insets(1, 1, 1, 1));
        res.setModel(new ContinuousButtonModel(300));
        res.setBorder(BorderFactory.createEmptyBorder());
        res.setOpaque(false);
        res.setFocusPainted(true);
        res.setContentAreaFilled(false);
        return res;
    }

    public IListPanel(SQLElement elem) {
        this(elem, null);
    }

    public IListPanel(SQLElement elem, IListe list) {
        this(elem, list, null);
    }

    public IListPanel(SQLElement elem, IListe list, String variant) {
        this.element = elem;
        this.btnMngr = new BtnTooltipMnger();
        File config = IListPanel.getConfigFile(this.getElement(), this.getClass(), variant);
        if (list == null) {
            list = new IListe(this.getElement().getTableSource(), config);
        } else {
            if (list.getSource().getPrimaryTable() != elem.getTable()) {
                throw new IllegalArgumentException("Different tables : " + elem.getTable() + " != " + list.getSource().getPrimaryTable());
            }
            if (list.getConfigFile() == null) {
                list.setConfigFile(config);
            }
        }
        this.liste = list;
        final IClosure<ListChangeIndex<IListeAction>> l = new IClosure<ListChangeIndex<IListeAction>>(){

            @Override
            public void executeChecked(ListChangeIndex<IListeAction> input) {
                IListPanel.this.getListe().removeIListeActions(input.getItemsRemoved());
                IListPanel.this.getListe().addIListeActions(input.getItemsAdded());
            }
        };
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 2L) != 0L) {
                    if (IListPanel.this.isDisplayable()) {
                        IListPanel.this.getListe().addIListeActions(IListPanel.this.getElement().getRowActions());
                        IListPanel.this.getElement().addRowActionsListener(l);
                    } else {
                        IListPanel.this.getElement().removeRowActionsListener(l);
                        IListPanel.this.getListe().removeIListeActions(IListPanel.this.getElement().getRowActions());
                    }
                }
            }
        });
        this.init();
    }

    protected final void init() {
        this.uiInit();
        this.liste.addIListener(new IListener(){

            @Override
            public void selectionId(int id, int field) {
                IListPanel.this.listSelectionChanged(id);
            }
        });
        this.liste.addSelectionDataListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IListPanel.this.listSelectionDataChanged();
            }
        });
        this.liste.addModelListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IListPanel.this.searchComponent.reset((ITableModel)evt.getNewValue());
            }
        });
        this.liste.getJTable().addMouseListener(new MouseAdapter(){
            private EditFrame listeningFrame = null;

            private final EditFrame createFrame(boolean listening) {
                Boolean rw = Boolean.getBoolean("org.openconcerto.sql.listPanel.rwOnDoubleClick");
                EditFrame res = new EditFrame(IListPanel.this.getElement(), rw == false ? EditPanel.READONLY : EditPanel.MODIFICATION);
                if (listening) {
                    IListPanel.this.getListe().addIListener(res);
                }
                res.selectionId(IListPanel.this.getListe().getSelectedId());
                return res;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (IListPanel.this.showReadOnlyFrameOnDoubleClick && e.getClickCount() == 2) {
                    EditFrame frame;
                    if ((e.getModifiersEx() & 0x200) != 0) {
                        if (this.listeningFrame == null) {
                            this.listeningFrame = this.createFrame(true);
                        }
                        frame = this.listeningFrame;
                    } else {
                        frame = this.createFrame(false);
                    }
                    FrameUtil.show(frame);
                }
            }
        });
        this.btnMngr.updateBtns();
        this.getListe().selectID(-1);
    }

    private final void uiInit() {
        this.createUI();
        IListPanel container = this;
        container.setLayout(new GridBagLayout());
        GridBagConstraints c = this.createConstraints();
        c.weighty = 1.0;
        container.add((Component)this.liste, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.insets = new Insets(4, 1, 2, 1);
        container.add((Component)this.getMiddlePanel(), c);
        this.addComponents(container, c);
        this.setOpaque(false);
    }

    protected GridBagConstraints createConstraints() {
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        return c;
    }

    protected void createUI() {
        this.setOpaque(false);
        this.buttonActualiser = new JButton(new ImageIcon(IListPanel.class.getResource("reload.png")));
        this.buttonActualiser.setBorderPainted(false);
        this.buttonActualiser.setFocusPainted(false);
        this.buttonActualiser.setOpaque(false);
        this.buttonActualiser.setContentAreaFilled(false);
        this.buttonActualiser.setMinimumSize(new Dimension(20, 20));
        this.buttonActualiser.setPreferredSize(new Dimension(20, 20));
        this.buttonActualiser.setMaximumSize(new Dimension(20, 20));
        this.searchComponent = new SearchListComponent(this.liste.getModel());
        this.searchComponent.setFormats(this.liste.getSearchFormats());
        this.buttonModifier = new JButton(TM.tr("modify", new Object[0]));
        this.buttonModifier.setOpaque(false);
        this.btnMngr.addBtn(this.buttonModifier, "noRightToModify", "UPDATE_ROW", true, true);
        this.buttonEffacer = new JButton(TM.tr("remove", new Object[0]));
        this.buttonEffacer.setOpaque(false);
        this.btnMngr.addBtn(this.buttonEffacer, "noRightToDel", "DELETE_ROW", true);
        this.buttonAjouter = new JButton(TM.tr("add", new Object[0]));
        this.buttonAjouter.setOpaque(false);
        this.btnMngr.addBtn(this.buttonAjouter, "noRightToAdd", "INSERT_ROW", false, false);
        this.buttonClone = new JButton(TM.tr("duplicate", new Object[0]));
        this.buttonClone.setOpaque(false);
        this.btnMngr.addBtn(this.buttonClone, "noRightToClone", "INSERT_ROW", true, false);
        this.btnMngr.setOKToolTip(this.buttonClone, TM.tr("listPanel.cloneToolTip", new Object[0]));
        this.saveBtn = new JButton(new ImageIcon(IListPanel.class.getResource("save.png")));
        this.saveBtn.setFocusPainted(false);
        this.saveBtn.setOpaque(false);
        this.saveBtn.setContentAreaFilled(false);
        this.saveBtn.setBorderPainted(false);
        this.saveBtn.setMinimumSize(new Dimension(20, 20));
        this.saveBtn.setPreferredSize(new Dimension(20, 20));
        this.saveBtn.setMaximumSize(new Dimension(20, 20));
        this.buttonMoins = IListPanel.createBtn(UP_ARROW);
        this.buttonPlus = IListPanel.createBtn(DOWN_ARROW);
        this.btnMngr.addBtn(this.buttonMoins, "noRightToReorder", "UPDATE_ROW", false);
        this.btnMngr.addBtn(this.buttonPlus, "noRightToReorder", "UPDATE_ROW", false);
        ITransformer<JButton, String> transf = new ITransformer<JButton, String>(){

            @Override
            public String transformChecked(JButton input) {
                boolean ok = IListPanel.this.getListe().hasSelection() && !IListPanel.this.getListe().isSorted();
                return input.getModel().isArmed() || ok ? null : TM.tr("listPanel.noSelectionOrSort", new Object[0]);
            }
        };
        this.btnMngr.setAdditional(this.buttonMoins, transf);
        this.btnMngr.setAdditional(this.buttonPlus, transf);
        this.searchPanel.setOpaque(false);
        this.getListe().addSortListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IListPanel.this.updateOrderButtons();
            }
        });
        if (Boolean.getBoolean("org.openconcerto.listpanel.simpleui")) {
            this.setAdjustVisible(false);
            this.setSearchFullMode(false);
        } else {
            this.searchPanel.setBorder(BorderFactory.createEtchedBorder());
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 2, 0, 2);
        c.fill = 2;
        c.weightx = 0.0;
        JLabel label = new JLabel(TM.tr("search", new Object[0]));
        label.setOpaque(false);
        this.searchPanel.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.searchComponent.setOpaque(false);
        this.searchPanel.setOpaque(false);
        this.searchPanel.add((Component)this.searchComponent, c);
    }

    protected abstract boolean modifyIsImmediate();

    protected void addComponents(Container container, GridBagConstraints c) {
    }

    protected Object[] getMiddleCompsLayout() {
        JComponent[] comps = new JComponent[]{this.buttonPlus, this.buttonMoins, this.buttonActualiser, this.canSave() ? this.saveBtn : null, this.searchPanel, this.buttonAjouter, this.canClone() ? this.buttonClone : null, this.buttonModifier, this.buttonEffacer};
        return new Object[]{comps, this.searchPanel};
    }

    private boolean canClone() {
        String prop = System.getProperty(CAN_CLONE, "");
        return Boolean.parseBoolean(prop) || SQLRow.toList(prop).contains(this.getElement().getTable().getName());
    }

    private boolean canSave() {
        String prop = System.getProperty("org.openconcerto.sql.canSaveInList", "true");
        return Boolean.parseBoolean(prop) || TableAllRights.currentUserHasRight("SAVE_ROW", this.getElement().getTable());
    }

    private final JPanel getMiddlePanel() {
        JPanel container = new JPanel();
        container.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 2, 0, 2);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 10;
        Object[] middleCompsL = this.getMiddleCompsLayout();
        JComponent[] comps = (JComponent[])middleCompsL[0];
        JComponent largest = (JComponent)middleCompsL[1];
        int i = 0;
        while (i < comps.length) {
            JComponent component = comps[i];
            if (component != null) {
                c.weightx = component == largest ? 1 : 0;
                container.add((Component)component, c);
                if (component instanceof JButton) {
                    ((JButton)component).addActionListener(this);
                }
                ++c.gridx;
            }
            ++i;
        }
        container.setOpaque(false);
        return container;
    }

    public void search(String s) {
        this.searchComponent.setSearchString(s);
    }

    public synchronized void search(String s, Runnable r) {
        this.search(s);
        this.getListe().getModel().invokeLater(r);
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        this.handleAction((JButton)e.getSource(), e);
    }

    private final int askSerious(Object msg, String title) {
        return JOptionPane.showConfirmDialog(this, msg, title, 0, 2);
    }

    private final JPanel createClonePanel(int selectedLines, boolean rec, SQLRequestComboBox combo) {
        String msg = TM.getInstance().trM("listPanel.cloneRows", "rowCount", selectedLines, "rec", rec);
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 21;
        c.insets = new Insets(2, 2, 2, 2);
        p.add((Component)new JLabel(msg), c);
        if (combo != null) {
            c.gridx = 0;
            ++c.gridy;
            p.add((Component)new JLabel(TM.tr("clone.newPlace", new Object[0])), c);
            ++c.gridy;
            combo.uiInit(this.getElement().getParentElement().getComboRequest());
            combo.setPreferredSize(new Dimension(600, combo.getPreferredSize().height));
            p.add((Component)combo, c);
        }
        return p;
    }

    protected void handleAction(JButton source, ActionEvent evt) {
        block28: {
            if (source == this.buttonMoins) {
                this.getListe().deplacerDe(-this.getInc(evt));
            } else if (source == this.buttonPlus) {
                this.getListe().deplacerDe(this.getInc(evt));
            } else if (source == this.buttonActualiser) {
                this.liste.update();
            } else if (source == this.buttonAjouter) {
                boolean deaf = this.isDeaf();
                int selectedId = this.getListe().getSelectedId();
                if (!deaf && this.selectRowOnAdd && selectedId >= 0) {
                    this.getCreateFrame().selectionId(selectedId);
                }
                FrameUtil.show(this.getCreateFrame());
            } else if (source == this.buttonClone) {
                SQLRequestComboBox combo;
                List<Integer> selectedIDs = this.getListe().getSelection().getSelectedIDs();
                boolean rec = (evt.getModifiers() & 2) != 0;
                boolean showParent = (evt.getModifiers() & 1) != 0;
                SQLRequestComboBox sQLRequestComboBox = combo = showParent && this.getElement().getParentElement() != null ? new SQLRequestComboBox() : null;
                if (this.askSerious(this.createClonePanel(selectedIDs.size(), rec, combo), TM.tr("duplication", new Object[0])) == 0) {
                    SQLRow parent = combo == null ? null : combo.getSelectedRow();
                    for (int id : selectedIDs) {
                        SQLRow row = this.getElement().getTable().getRow(id);
                        try {
                            if (rec) {
                                this.getElement().copyRecursive(row, parent);
                                continue;
                            }
                            this.getElement().copy(row, parent);
                        }
                        catch (SQLException e) {
                            ExceptionHandler.handle(this, TM.tr("listPanel.duplicationError", row), e);
                        }
                    }
                }
            } else if (source == this.buttonEffacer) {
                this.getElement().askArchive((Component)this, this.getListe().getSelection().getSelectedIDs());
            } else if (source == this.saveBtn) {
                try {
                    File file;
                    String allRows = TM.tr("listPanel.wholeList", new Object[0]);
                    String selectedRows = TM.tr("listPanel.selection", new Object[0]);
                    JRadioButtons.JStringRadioButtons radios = new JRadioButtons.JStringRadioButtons(false, Arrays.asList(allRows, selectedRows));
                    radios.setValue(this.getListe().getSelection().getSelectedIDs().size() <= 1 ? allRows : selectedRows);
                    JPanel p = new JPanel(new BorderLayout());
                    p.add((Component)new JLabel(TM.tr("export", new Object[0])), "First");
                    p.add((Component)radios, "Before");
                    Object[] options = new Object[]{TM.tr("open", new Object[0]), String.valueOf(TM.tr("save", new Object[0])) + "...", TM.tr("cancel", new Object[0])};
                    int answer = JOptionPane.showOptionDialog(this, p, TM.tr("listPanel.export", new Object[0]), -1, 3, null, options, options[0]);
                    if (answer != 0 && answer != 1) break block28;
                    boolean tmp = answer == 0;
                    XMLFormatVersion version = XMLFormatVersion.getDefault();
                    String prefix = this.element.getPluralName().replace('/', '-');
                    String suffix = "." + ContentType.SPREADSHEET.getVersioned(version.getXMLVersion()).getExtension();
                    if (tmp) {
                        file = File.createTempFile(prefix, suffix);
                    } else {
                        FileDialog fd = new FileDialog(SwingThreadUtils.getAncestorOrSelf(Frame.class, this), TM.tr("listPanel.save", new Object[0]), 1);
                        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
                        fd.setDirectory(prefs.get(EXPORT_DIR_KEY, Configuration.getInstance().getWD().getAbsolutePath()));
                        fd.setFile(String.valueOf(prefix) + suffix);
                        fd.setVisible(true);
                        if (fd.getFile() != null) {
                            file = new File(fd.getDirectory(), fd.getFile());
                            prefs.put(EXPORT_DIR_KEY, fd.getDirectory());
                        } else {
                            file = null;
                        }
                    }
                    if (file != null) {
                        File exportedFile = this.liste.exporter(file, ((String)radios.getValue()).equals(selectedRows), version);
                        if (tmp) {
                            exportedFile.setWritable(false, false);
                            exportedFile.deleteOnExit();
                        }
                        OOUtils.open((File)exportedFile);
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle(this, TM.tr("saveError", new Object[0]), e);
                }
            } else {
                throw new IllegalStateException("button '" + source.getText() + "' not implemented");
            }
        }
    }

    public final boolean isDeaf() {
        return this.deaf;
    }

    public final void setDeaf(boolean b) {
        this.deaf = b;
    }

    protected final EditFrame getCreateFrame() {
        if (this.createFrame == null) {
            this.createFrame = new EditFrame(this.element, EditPanel.CREATION);
            this.createFrame.getPanel().setIListe(this.getListe());
            if (!this.isDeaf()) {
                this.liste.addIListener(this.createFrame);
            }
        }
        return this.createFrame;
    }

    protected void listSelectionChanged(int id) {
    }

    protected void listSelectionDataChanged() {
        this.btnMngr.updateBtns();
    }

    protected final void updateOrderButtons() {
        this.btnMngr.updateBtn(this.buttonMoins);
        this.btnMngr.updateBtn(this.buttonPlus);
    }

    public final IListe getListe() {
        return this.liste;
    }

    public final SQLElement getElement() {
        return this.element;
    }

    protected SQLComponent getSQLComponent() {
        return null;
    }

    public abstract SQLComponent getModifComp();

    public final SQLComponent getAddComp() {
        return this.getCreateFrame().getSQLComponent();
    }

    @Override
    public void grabFocus() {
        this.liste.grabFocus();
    }

    private int getInc(ActionEvent evt) {
        int times = (int)evt.getWhen() - 3;
        return times < 2 ? 1 : (int)Math.pow(times, 2.0);
    }

    public void setUpAndDownVisible(boolean b) {
        this.buttonPlus.setVisible(b);
        this.buttonMoins.setVisible(b);
        this.getListe().getJTable().setDragEnabled(b);
    }

    public void setShowReadOnlyFrameOnDoubleClick(boolean showReadOnlyFrameOnDoubleClick) {
        this.showReadOnlyFrameOnDoubleClick = showReadOnlyFrameOnDoubleClick;
    }

    public void setAddVisible(boolean b) {
        this.buttonAjouter.setVisible(b);
    }

    public void setAdjustVisible(boolean b) {
        this.liste.setAdjustVisible(b);
    }

    public void setReloadVisible(boolean b) {
        this.buttonActualiser.setVisible(b);
    }

    public void setSaveVisible(boolean b) {
        this.saveBtn.setVisible(b);
    }

    public void setSearchVisible(boolean b) {
        this.searchPanel.setVisible(b);
    }

    public void setDeleteVisible(boolean b) {
        this.buttonEffacer.setVisible(b);
    }

    public void setModifyVisible(boolean b) {
        this.buttonModifier.setVisible(b);
    }

    public void setCloneVisible(boolean b) {
        this.buttonClone.setVisible(b);
    }

    public void setReadWriteButtonsVisible(boolean b) {
        this.setUpAndDownVisible(b);
        this.setAddVisible(b);
        this.setDeleteVisible(b);
        this.setModifyVisible(b);
        this.setCloneVisible(b);
    }

    public void setSearchFullMode(boolean b) {
        if (b) {
            this.searchPanel.setBorder(BorderFactory.createEtchedBorder());
        } else {
            this.searchPanel.setBorder(BorderFactory.createEmptyBorder());
        }
        this.searchComponent.setSearchFullMode(b);
    }

    public void setSelectRowOnAdd(boolean b) {
        this.selectRowOnAdd = b;
    }

    public JButton getButtonAdd() {
        return this.buttonAjouter;
    }

    public JButton getButtonModify() {
        return this.buttonModifier;
    }

    public JButton getButtonDelete() {
        return this.buttonEffacer;
    }

    protected final class BtnTooltipMnger {
        private final Map<JButton, Tuple2<String, String>> code;
        private final Set<JButton> needSelection = new HashSet<JButton>();
        private final Set<JButton> needRWSelection = new HashSet<JButton>();
        private final Map<JButton, ITransformer<JButton, String>> additional;
        private final Map<JButton, String> okTooltip;
        private final Map<JButton, Tuple2.List2<String>> alternateLabels;

        public BtnTooltipMnger() {
            this.code = new HashMap<JButton, Tuple2<String, String>>();
            this.additional = new HashMap<JButton, ITransformer<JButton, String>>();
            this.okTooltip = new HashMap<JButton, String>();
            this.alternateLabels = new HashMap<JButton, Tuple2.List2<String>>(4);
        }

        public void addBtn(JButton btn, String desc, String rightCode, boolean needSelection) {
            this.addBtn(btn, desc, rightCode, needSelection, true);
        }

        public void addBtn(JButton btn, String desc, String rightCode, boolean needSelection, boolean needRWSelection) {
            if (this.code.containsKey(btn)) {
                throw new IllegalStateException("already in");
            }
            this.code.put(btn, Tuple2.create(desc, rightCode));
            if (needSelection) {
                this.needSelection.add(btn);
            }
            if (needRWSelection && IListPanel.this.getElement().getTable().contains("UI_LOCK")) {
                this.needRWSelection.add(btn);
            }
        }

        public void setAdditional(JButton btn, ITransformer<JButton, String> additional) {
            if (additional != null) {
                this.additional.put(btn, additional);
            } else {
                this.additional.remove(btn);
            }
        }

        public void setFallback(JButton btn, String normalLabel, String altLabel) {
            if (normalLabel == null || altLabel == null) {
                this.alternateLabels.remove(btn);
            } else {
                this.alternateLabels.put(btn, new Tuple2.List2<String>(normalLabel, altLabel));
            }
        }

        public void setOKToolTip(JButton btn, String tooltip) {
            if (tooltip != null) {
                this.okTooltip.put(btn, tooltip);
            } else {
                this.okTooltip.remove(btn);
            }
        }

        void updateBtn(JButton btn) {
            if (!this.code.containsKey(btn)) {
                throw new IllegalArgumentException();
            }
            this.updateBtns(Collections.singleton(btn));
        }

        void updateBtns() {
            this.updateBtns(this.code.keySet());
        }

        private void updateBtns(Set<JButton> btns) {
            boolean hasSelection = IListPanel.this.getListe().getSelectedId() >= 0;
            UserRights rights = UserRightsManager.getCurrentUserRights();
            for (JButton btn : btns) {
                String tooltip;
                boolean ok;
                Tuple2<String, String> t = this.code.get(btn);
                boolean fallBack = false;
                if (!TableAllRights.hasRight(rights, t.get1(), IListPanel.this.getElement().getTable())) {
                    ok = false;
                    tooltip = TM.tr(t.get0(), new Object[0]);
                    fallBack = true;
                } else if (this.needRWSelection.contains(btn) && this.isRO()) {
                    ok = false;
                    tooltip = TM.tr("editPanel.readOnlySelection", new Object[0]);
                    fallBack = true;
                } else if (this.needSelection.contains(btn) && !hasSelection) {
                    ok = false;
                    tooltip = TM.tr("noSelection", new Object[0]);
                } else if (this.additional.containsKey(btn)) {
                    tooltip = this.additional.get(btn).transformChecked(btn);
                    ok = tooltip == null;
                } else {
                    ok = true;
                    tooltip = this.okTooltip.get(btn);
                }
                boolean finalOK = ok;
                Tuple2.List2<String> fallbackLabels = this.alternateLabels.get(btn);
                if (fallbackLabels != null) {
                    String label;
                    if (fallBack) {
                        assert (!ok);
                        finalOK = true;
                        label = (String)fallbackLabels.get1();
                    } else {
                        label = (String)fallbackLabels.get0();
                    }
                    btn.setText(TM.tr(label, new Object[0]));
                    btn.putClientProperty(IListPanel.FALLBACK_KEY, fallBack);
                }
                btn.setToolTipText(tooltip);
                btn.setEnabled(finalOK);
            }
        }

        private boolean isRO() {
            SQLRowValues r = IListPanel.this.getListe().getSelectedRow();
            return r != null && SQLComponent.isReadOnly(r);
        }
    }
}

