/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui.light;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Future;
import net.minidev.json.JSONObject;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldMapper;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.ui.light.LightForeignRowValuesTableOffline;
import org.openconcerto.sql.ui.light.SavableCustomEditorProvider;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.SQLTableModelLinesSourceOffline;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.Item;
import org.openconcerto.ui.light.CustomEditorProvider;
import org.openconcerto.ui.light.JSONToLightUIConvertor;
import org.openconcerto.ui.light.LightUICheckBox;
import org.openconcerto.ui.light.LightUIComboBox;
import org.openconcerto.ui.light.LightUIDate;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUIFrame;
import org.openconcerto.utils.io.JSONConverter;

public class LightEditFrame
extends LightUIFrame {
    private static final String EDIT_MODE_JSON_KEY = "edit-mode";
    private Group group;
    private SQLRowValues sqlRow;
    private EditPanel.EditMode editMode = EditPanel.EditMode.READONLY;

    public LightEditFrame(JSONObject json) {
        super(json);
    }

    public LightEditFrame(LightEditFrame frame) {
        super(frame);
        this.sqlRow = frame.sqlRow;
        this.group = frame.group;
        this.editMode = frame.editMode;
    }

    public LightEditFrame(Configuration conf, Group group, SQLRowValues sqlRow, LightUIFrame parentFrame, EditPanel.EditMode editMode) {
        super(String.valueOf(group.getId()) + ".edit.frame");
        this.setType(13);
        this.setParent(parentFrame);
        this.sqlRow = sqlRow;
        this.group = group;
        this.setEditMode(editMode);
    }

    public void setEditMode(EditPanel.EditMode editMode) {
        this.editMode = editMode;
        if (editMode.equals((Object)EditPanel.EditMode.READONLY)) {
            this.setReadOnly(true);
        } else {
            this.setReadOnly(false);
        }
    }

    public SQLRow commitSqlRow(Configuration configuration) throws SQLException {
        if (this.editMode.equals((Object)EditPanel.EditMode.READONLY)) {
            throw new IllegalArgumentException("Impossible to commit values when the frame is read only");
        }
        SQLElement sqlElement = configuration.getDirectory().getElement(this.sqlRow.getTable());
        return this.sqlRow.prune(sqlElement.getPrivateGraph()).commit();
    }

    public EditPanel.EditMode getEditMode() {
        return this.editMode;
    }

    public Group getGroup() {
        return this.group;
    }

    public SQLRowValues getSqlRow() {
        return this.sqlRow;
    }

    public void updateRow(Configuration configuration, String sessionSecurityToken, int userId) {
        if (this.editMode.equals((Object)EditPanel.EditMode.READONLY)) {
            throw new IllegalArgumentException("Impossible to update values when the frame is read only");
        }
        this.updateRow(configuration, this.group, sessionSecurityToken, userId);
    }

    private void updateRow(Configuration configuration, Group group, String sessionSecurityToken, int userId) {
        FieldMapper fieldMapper = configuration.getFieldMapper();
        if (fieldMapper == null) {
            throw new IllegalStateException("null field mapper");
        }
        SQLElement sqlElement = configuration.getDirectory().getElement(this.sqlRow.getTable());
        Map<String, CustomEditorProvider> customEditors = this.editMode.equals((Object)EditPanel.EditMode.CREATION) ? sqlElement.getCustomEditorProviderForCreation(configuration, sessionSecurityToken) : sqlElement.getCustomEditorProviderForModification(configuration, this.sqlRow, sessionSecurityToken);
        this.createRowValues(configuration, sqlElement, fieldMapper, this.group, customEditors);
        this.setMetaData(userId);
    }

    protected final void createRowValues(Configuration configuration, SQLElement sqlElement, FieldMapper fieldMapper, Group group, Map<String, CustomEditorProvider> customEditors) {
        int itemCount = group.getSize();
        int i = 0;
        while (i < itemCount) {
            Item item = group.getItem(i);
            if (item instanceof Group) {
                this.createRowValues(configuration, sqlElement, fieldMapper, (Group)item, customEditors);
            } else {
                SQLField field = fieldMapper.getSQLFieldForItem(item.getId());
                if (field != null) {
                    LightUIElement uiElement = this.findChildByID(item.getId(), LightUIElement.class);
                    if (uiElement == null) {
                        throw new IllegalArgumentException("Impossible to find UI Element with id: " + item.getId());
                    }
                    if (!uiElement.isNotSaved()) {
                        this.putValueFromUserControl(configuration, sqlElement, field, uiElement, customEditors);
                    }
                } else {
                    Log.get().warning("No field attached to " + item.getId());
                }
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void putValueFromUserControl(Configuration configuration, SQLElement sqlElement, SQLField sqlField, LightUIElement uiElement, Map<String, CustomEditorProvider> customEditors) {
        if (uiElement.isNotSaved()) return;
        Class<?> fieldType = sqlField.getType().getJavaType();
        if (customEditors.containsKey(uiElement.getId())) {
            CustomEditorProvider customEditor = customEditors.get(uiElement.getId());
            if (!(customEditor instanceof SavableCustomEditorProvider)) throw new IllegalStateException(customEditor + " must implement SavableCustomEditorProvider for field " + sqlField.getFieldName() + " of tye " + fieldType);
            ((SavableCustomEditorProvider)customEditor).save(this.sqlRow, sqlField, uiElement);
            return;
        } else {
            String fieldName = sqlField.getFieldName();
            if (sqlField.isKey()) {
                if (!(uiElement instanceof LightUIComboBox)) {
                    throw new IllegalArgumentException("Invalid UI Element for field: " + fieldName + ". When field is foreign key, UI Element must be a LightUIDate");
                }
                LightUIComboBox combo = (LightUIComboBox)uiElement;
                if (combo.hasSelectedValue()) {
                    this.sqlRow.put(fieldName, combo.getSelectedValue().getId());
                    return;
                } else {
                    this.sqlRow.put(fieldName, null);
                }
                return;
            } else {
                String value = uiElement.getValue();
                if (value == null && !sqlField.isNullable().booleanValue()) {
                    Log.get().warning("ignoring null value for not nullable field " + fieldName + " from table " + sqlField.getTable().getName());
                    return;
                } else if (fieldType.equals(String.class)) {
                    this.sqlRow.put(fieldName, value);
                    return;
                } else if (fieldType.equals(Date.class)) {
                    if (!(uiElement instanceof LightUIDate)) {
                        throw new IllegalArgumentException("Invalid UI Element for field: " + fieldName + ". When field is Date, UI Element must be a LightUIDate");
                    }
                    this.sqlRow.put(fieldName, ((LightUIDate)uiElement).getValueAsDate());
                    return;
                } else if (fieldType.equals(Boolean.class)) {
                    if (!(uiElement instanceof LightUICheckBox)) {
                        throw new IllegalArgumentException("Invalid UI Element for field: " + fieldName + ". When field is Boolean, UI Element must be a LightUICheckBox");
                    }
                    this.sqlRow.put(fieldName, ((LightUICheckBox)uiElement).isChecked());
                    return;
                } else if (fieldType.equals(Timestamp.class)) {
                    if (!(uiElement instanceof LightUIDate)) {
                        throw new IllegalArgumentException("Invalid UI Element for field: " + fieldName + ". When field is Date, UI Element must be a LightUIDate");
                    }
                    this.sqlRow.put(fieldName, ((LightUIDate)uiElement).getValueAsDate());
                    return;
                } else if (fieldType.equals(Integer.class)) {
                    if (value != null && !value.trim().isEmpty()) {
                        if (!value.matches("^-?\\d+$")) {
                            throw new IllegalArgumentException("Invalid value for field: " + fieldName + " value: " + value);
                        }
                        this.sqlRow.put(fieldName, Integer.parseInt(value));
                        return;
                    } else {
                        this.sqlRow.put(fieldName, null);
                    }
                    return;
                } else if (fieldType.equals(Double.class) || fieldType.equals(Float.class) || fieldType.equals(BigDecimal.class)) {
                    if (value != null && !value.trim().isEmpty()) {
                        try {
                            this.sqlRow.put(fieldName, new BigDecimal(value));
                            return;
                        }
                        catch (Exception ex) {
                            throw new IllegalArgumentException("Invalid value for field: " + fieldName + " value: " + value);
                        }
                    } else {
                        this.sqlRow.put(fieldName, null);
                    }
                    return;
                } else {
                    Log.get().warning("unsupported type " + fieldName);
                }
            }
        }
    }

    public final void saveReferentRows(Configuration configuration, SQLRow parentSqlRow, Map<String, CustomEditorProvider> customEditors, String sessionSecurityToken) {
        this.saveReferentRows(configuration, this.group, parentSqlRow, customEditors, sessionSecurityToken);
    }

    private final void saveReferentRows(Configuration configuration, Group group, SQLRow parentSqlRow, Map<String, CustomEditorProvider> customEditors, String sessionSecurityToken) {
        int i = 0;
        while (i < group.getSize()) {
            LightUIElement element;
            Item item = group.getItem(i);
            if (item instanceof Group) {
                this.saveReferentRows(configuration, (Group)item, parentSqlRow, customEditors, sessionSecurityToken);
            } else if (customEditors.containsKey(item.getId()) && (element = this.findChildByID(item.getId(), LightUIElement.class)) instanceof LightForeignRowValuesTableOffline) {
                LightForeignRowValuesTableOffline foreignTable = (LightForeignRowValuesTableOffline)element;
                int j = 0;
                while (j < foreignTable.getRowsCount()) {
                    ListSQLLine listLine = foreignTable.getModel().getRow(j);
                    SQLRowValues rowVals = listLine.getRow().createEmptyUpdateRow();
                    rowVals.put(foreignTable.getForeignField().getName(), parentSqlRow.getID());
                    ((SQLTableModelLinesSourceOffline)foreignTable.getModel().getLinesSource()).updateRow((Number)listLine.getID(), rowVals);
                    ++j;
                }
                Future<?> fCommit = foreignTable.commitRows();
                try {
                    fCommit.get();
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
            ++i;
        }
    }

    protected final void setMetaData(int userId) {
        SQLTable sqlTable = this.sqlRow.getTable();
        if (this.sqlRow.getObject(sqlTable.getCreationUserField().getName()) == null || this.sqlRow.getObject(sqlTable.getCreationDateField().getName()) == null) {
            this.sqlRow.put(sqlTable.getCreationUserField().getName(), userId);
            this.sqlRow.put(sqlTable.getCreationDateField().getName(), new Date());
        }
        this.sqlRow.put(sqlTable.getModifUserField().getName(), userId);
        this.sqlRow.put(sqlTable.getModifDateField().getName(), new Date());
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public JSONToLightUIConvertor getConvertor() {
        return new JSONToLightUIConvertor(){

            @Override
            public LightUIElement convert(JSONObject json) {
                return new LightEditFrame(json);
            }
        };
    }

    public LightUIElement clone() {
        return new LightEditFrame(this);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (!this.editMode.equals((Object)EditPanel.EditMode.READONLY)) {
            if (this.editMode.equals((Object)EditPanel.EditMode.CREATION)) {
                json.put(EDIT_MODE_JSON_KEY, 1);
            } else if (this.editMode.equals((Object)EditPanel.EditMode.MODIFICATION)) {
                json.put(EDIT_MODE_JSON_KEY, 2);
            }
        }
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        int jsonEditMode = JSONConverter.getParameterFromJSON(json, EDIT_MODE_JSON_KEY, Integer.class, 3);
        if (jsonEditMode == 1) {
            this.editMode = EditPanel.EditMode.CREATION;
        } else if (jsonEditMode == 2) {
            this.editMode = EditPanel.EditMode.MODIFICATION;
        } else if (jsonEditMode == 3) {
            this.editMode = EditPanel.EditMode.READONLY;
        }
    }
}

