/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.navigator;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.view.search.SearchSpec;
import org.openconcerto.utils.EnumOrderedSet;
import org.openconcerto.utils.SortDirection;
import org.openconcerto.utils.cc.IPredicate;

public abstract class SQLListModel<T>
extends AbstractListModel {
    private static final EnumOrderedSet<SortDirection> ALL = EnumOrderedSet.allOf(SortDirection.class);
    private final List<T> items;
    private final List<T> initialItems;
    private SearchSpec search = null;
    private SortDirection sortAscending;
    private final Comparator<T> comp;
    private Set<SQLRow> highlighted;
    private final Set<Number> ids;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
    private boolean updating = false;

    public SQLListModel() {
        this.items = new ArrayList<T>();
        this.initialItems = new ArrayList<T>();
        this.sortAscending = SortDirection.NONE;
        this.comp = new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return SQLListModel.this.toString(o1).compareTo(SQLListModel.this.toString(o2));
            }
        };
        this.highlighted = Collections.emptySet();
        this.ids = new HashSet<Number>();
    }

    protected final void reload() {
        this.reload(false);
    }

    protected abstract void reload(boolean var1);

    @Override
    public final int getSize() {
        return this.items.size();
    }

    @Override
    public final T getElementAt(int index) {
        return this.items.get(index);
    }

    protected final List<T> getDisplayedItems() {
        return this.items;
    }

    protected final List<T> getRealItems() {
        if (this.hasALLValue()) {
            return this.getDisplayedItems().subList(1, this.getDisplayedItems().size());
        }
        return this.getDisplayedItems();
    }

    protected final void setAll(List<T> items) {
        this.getInitialItems().clear();
        this.getInitialItems().addAll(items);
        this.computeItems();
    }

    protected final List<T> getInitialItems() {
        return this.initialItems;
    }

    final List<T> selectItems(boolean displayed, IPredicate<T> pred) {
        List<T> l;
        List<T> list = l = displayed ? this.getDisplayedItems() : this.getInitialItems();
        if (pred == null) {
            return l;
        }
        ArrayList<T> res = new ArrayList<T>();
        int i = 0;
        while (i < l.size()) {
            T row = l.get(i);
            if (!this.isALLValue(row) && pred.evaluateChecked(row)) {
                res.add(row);
            }
            ++i;
        }
        return res;
    }

    public final void sort() {
        this.sortAscending = ALL.getFrom(this.sortAscending, 1, true);
        this.computeItems();
    }

    public final SortDirection getSortDirection() {
        return this.sortAscending;
    }

    public void setSearchString(final String text) {
        this.setSearch(new SearchSpec(){

            @Override
            public boolean isEmpty() {
                return text == null || text.length() == 0;
            }

            @Override
            public boolean match(Object line) {
                return line.toString().toLowerCase().indexOf(text.toLowerCase()) != -1;
            }
        });
    }

    public final void setSearch(SearchSpec search) {
        this.search = search;
        this.computeItems();
    }

    public final SearchSpec getSearch() {
        return this.search;
    }

    private void computeItems() {
        this.setUpdating(true);
        int oldSize = this.getSize();
        this.items.clear();
        this.items.addAll(this.filter(this.getInitialItems()));
        if (this.sortAscending == SortDirection.ASCENDING) {
            Collections.sort(this.items, this.comp);
        } else if (this.sortAscending == SortDirection.DESCENDING) {
            Collections.sort(this.items, Collections.reverseOrder(this.comp));
        }
        if (this.hasALLValue()) {
            this.items.add(0, this.getALLValue());
        }
        this.fireIntervalRemoved(this, 0, oldSize);
        this.fireIntervalAdded(this, 0, this.getSize());
        this.supp.firePropertyChange("items", null, this.items);
        this.setUpdating(false);
    }

    private final List<T> filter(List<T> l) {
        if (this.search == null || this.search.isEmpty()) {
            return l;
        }
        ArrayList<T> res = new ArrayList<T>();
        for (T value : l) {
            if (!this.search.match(this.toString(value))) continue;
            res.add(value);
        }
        return res;
    }

    public final void setParentIDs(Collection<? extends Number> ids) {
        if (!this.ids.equals(new HashSet<Number>(ids))) {
            this.ids.clear();
            this.ids.addAll(ids);
            this.idsChanged();
        }
    }

    protected final Set<Number> getIds() {
        return this.ids;
    }

    protected abstract void idsChanged();

    protected abstract String toString(T var1);

    void setHighlighted(Set<SQLRow> rows) {
        if (!this.highlighted.equals(rows)) {
            this.highlighted = rows;
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    Set<SQLRow> getHighlighted() {
        return this.highlighted;
    }

    int getFirstHighlighted() {
        if (this.getHighlighted().size() > 0) {
            int i = 0;
            while (i < this.items.size()) {
                T item = this.items.get(i);
                if (this.getHighlighted().contains(item)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public final boolean isALLValue(T val) {
        return this.hasALLValue() && val == this.getALLValue();
    }

    protected boolean hasALLValue() {
        return false;
    }

    protected T getALLValue() {
        return null;
    }

    public final synchronized boolean isUpdating() {
        return this.updating;
    }

    private synchronized void setUpdating(boolean updating) {
        boolean old = this.updating;
        if (old != updating) {
            this.updating = updating;
            this.supp.firePropertyChange("updating", old, this.updating);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l, String propName) {
        this.supp.addPropertyChangeListener(propName, l);
    }

    public void rmPropertyChangeListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    public void rmPropertyChangeListener(PropertyChangeListener l, String propName) {
        this.supp.removePropertyChangeListener(propName, l);
    }
}

