/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.util.List;
import org.openconcerto.sql.element.JoinSQLElement;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.Step;

public final class SQLElementLink {
    private final SQLElement owner;
    private final SQLElement owned;
    private final Path path;
    private final LinkType type;
    private final String name;
    private SQLElement.ReferenceAction action;

    protected SQLElementLink(SQLElement owner, Path path, SQLElement owned, LinkType type, String name, SQLElement.ReferenceAction action) {
        SQLField singleField;
        int length = path.length();
        if (length == 0) {
            throw new IllegalArgumentException("Empty path");
        }
        if (owner != null && owner.getTable() != path.getFirst() || owned.getTable() != path.getLast()) {
            throw new IllegalArgumentException("Wrong path : " + path + " not from owner : " + owner + " to owned : " + owned);
        }
        if (!path.isSingleLink()) {
            throw new IllegalArgumentException("Isn't single link : " + path);
        }
        if (length > 2) {
            throw new IllegalArgumentException("Path too long : " + path);
        }
        Step lastStep = path.getStep(-1);
        boolean endsWithForeign = lastStep.getDirection().equals((Object)Link.Direction.FOREIGN);
        if (length == 1) {
            if (!endsWithForeign) {
                throw new IllegalArgumentException("Single step path isn't foreign : " + path);
            }
        } else {
            assert (length == 2);
            if (!endsWithForeign || !path.getStep(0).getDirection().equals((Object)Link.Direction.REFERENT)) {
                throw new IllegalArgumentException("Two steps path isn't a join : " + path);
            }
        }
        if (lastStep.getSingleField() == null) {
            throw new IllegalArgumentException("Multi-field not yet supported : " + lastStep);
        }
        this.path = path;
        this.owner = owner;
        this.owned = owned;
        if (type == null || action == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.name = name != null ? name : (length == 1 ? ((singleField = lastStep.getSingleField()) != null ? singleField.getName() : lastStep.getSingleLink().getName()) : lastStep.getFrom().getName());
        assert (this.getName() != null);
        this.action = action;
    }

    public final Path getPath() {
        return this.path;
    }

    public final boolean isJoin() {
        return this.path.length() == 2;
    }

    public final Link getSingleLink() {
        if (this.isJoin()) {
            return null;
        }
        Link res = this.path.getStep(0).getSingleLink();
        assert (res != null);
        return res;
    }

    public final SQLField getSingleField() {
        Link l = this.getSingleLink();
        if (l == null) {
            return null;
        }
        SQLField res = l.getSingleField();
        assert (res != null);
        return res;
    }

    public final SQLElement getOwner() {
        return this.owner;
    }

    public final SQLElement getOwned() {
        return this.owned;
    }

    public final JoinSQLElement getJoinElement() {
        if (!this.isJoin()) {
            return null;
        }
        return (JoinSQLElement)this.getOwner().getElement(this.getPath().getTable(1));
    }

    public final boolean isOwnerTheParent() {
        boolean owner;
        if (this.getLinkType().equals((Object)LinkType.COMPOSITION)) {
            owner = true;
        } else if (this.getLinkType().equals((Object)LinkType.PARENT)) {
            owner = false;
        } else {
            throw new IllegalStateException("Invalid type : " + (Object)((Object)this.getLinkType()));
        }
        return owner;
    }

    public final SQLElement getParent() {
        return this.getParentOrChild(true);
    }

    private final SQLElement getParentOrChild(boolean parent) {
        return parent == this.isOwnerTheParent() ? this.getOwner() : this.getOwned();
    }

    public final SQLElement getChild() {
        return this.getParentOrChild(false);
    }

    public final Path getPathToParent() {
        return this.getPathToParentOrChild(true);
    }

    public final Step getStepToParent() {
        return this.getPathToParent().getStep(-1);
    }

    private final Path getPathToParentOrChild(boolean toParent) {
        return toParent == this.isOwnerTheParent() ? this.getPath().reverse() : this.getPath();
    }

    public final Path getPathToChild() {
        return this.getPathToParentOrChild(false);
    }

    public final Step getStepToChild() {
        return this.getPathToChild().getStep(-1);
    }

    public final LinkType getLinkType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final SQLElement.ReferenceAction getAction() {
        return this.action;
    }

    @Deprecated
    public final void setAction(SQLElement.ReferenceAction action) {
        List<SQLElement.ReferenceAction> possibleActions = this.getOwner().getPossibleActions(this.getLinkType(), this.getOwned());
        if (!possibleActions.contains((Object)action)) {
            throw new IllegalArgumentException("Not allowed : " + (Object)((Object)action));
        }
        this.action = action;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.action.hashCode();
        result = 31 * result + this.path.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLElementLink other = (SQLElementLink)obj;
        return this.action.equals((Object)other.action) && this.path.equals(other.path) && this.type.equals((Object)other.type);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " '" + this.getName() + "' " + (Object)((Object)this.getLinkType()) + " " + this.getPath();
    }

    public static enum LinkType {
        PARENT,
        COMPOSITION,
        ASSOCIATION;

    }
}

