/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.jcip.annotations.GuardedBy;
import org.openconcerto.sql.ShowAs;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBFileCache;
import org.openconcerto.sql.model.DBItemFileCache;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldMapper;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLFilter;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.utils.BaseDirs;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.StringUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class Configuration {
    @GuardedBy(value="this")
    private static Configuration instance;
    @GuardedBy(value="this")
    private ExecutorService nonInteractiveSQLExecutor;

    public static File getDefaultConfDir() {
        return new File(System.getProperty("user.home"), ".java/ilm/sql-config/");
    }

    public static SQLFieldTranslator getTranslator(SQLTable t) {
        return Configuration.getInstance().getTranslator();
    }

    public static synchronized Configuration getInstance() {
        return instance;
    }

    public static final void setInstance(Configuration instance) {
        Configuration.setInstance(instance, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Configuration setInstance(Configuration instance, boolean destroyPrevious) {
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            Configuration prev = Configuration.instance;
            if (prev == instance) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return prev;
            }
            Configuration.instance = instance;
            if (instance != null) {
                try {
                    instance.migrateToNewDBConfDir();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Couldn't migrate");
                }
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (prev != null && destroyPrevious) {
                prev.destroy();
            }
            return prev;
        }
    }

    public static final void migrateToNewDir(File oldDir, File newDir) throws IOException {
        if (oldDir.exists() && !newDir.exists()) {
            if (!oldDir.isDirectory()) {
                throw new IOException("Old file isn't a directory : " + oldDir);
            }
            FileUtils.mkdir_p(newDir.getParentFile());
            String err = FileUtils.mv(oldDir, newDir);
            if (err != null) {
                throw new IOException("Couldn't migrate from " + oldDir + " : " + err);
            }
        }
    }

    public abstract ShowAs getShowAs();

    public abstract SQLBase getBase();

    public abstract DBRoot getRoot();

    public abstract DBSystemRoot getSystemRoot();

    public abstract SQLFilter getFilter();

    public abstract SQLFieldTranslator getTranslator();

    public abstract SQLElementDirectory getDirectory();

    public abstract FieldMapper getFieldMapper();

    public abstract File getWD();

    public abstract String getAppName();

    public final String getAppID() {
        String appName = this.getAppName();
        if (StringUtils.isEmpty(appName)) {
            return null;
        }
        String variant = this.getAppVariant();
        if (StringUtils.isEmpty(variant, true)) {
            return appName;
        }
        return String.valueOf(appName) + '-' + variant;
    }

    public String getAppVariant() {
        return null;
    }

    public abstract BaseDirs getBaseDirs();

    public final File getConfDir() {
        return this.getBaseDirs().getPreferencesFolder();
    }

    @Deprecated
    protected File getOldConfDir() {
        return new File(Configuration.getDefaultConfDir(), this.getAppID());
    }

    public final File getConfDirForRoot() {
        return this.getConfDir(this.getRoot());
    }

    public final void migrateToNewDBConfDir() throws IOException {
        File oldFile = this.getOldDBConfDir();
        File newFile = this.getDBConfDir();
        Configuration.migrateToNewDir(oldFile, newFile);
    }

    private File getOldDBConfDir() {
        return new File(this.getOldConfDir(), "dataDepedent");
    }

    @Deprecated
    protected final File getOldConfDir(DBStructureItem<?> db) {
        return DBItemFileCache.getDescendant(this.getOldDBConfDir(), DBFileCache.getJDBCAncestorNames(db, true));
    }

    private File getDBConfDir() {
        return new File(this.getConfDir(), "dataDependent");
    }

    public final File getConfDir(DBStructureItem<?> db) {
        return DBItemFileCache.getDescendant(this.getDBConfDir(), DBFileCache.getJDBCAncestorNames(db, true));
    }

    public Configuration add(Configuration o) {
        this.getTranslator().putAll(o.getTranslator());
        this.getDirectory().putAll(o.getDirectory());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Configuration configuration = this;
        synchronized (configuration) {
            if (this.nonInteractiveSQLExecutor != null) {
                this.nonInteractiveSQLExecutor.shutdown();
            }
        }
    }

    public Document getXMLConf(Number userId, String idTable) throws IllegalStateException, IllegalArgumentException {
        SQLElement element = this.getDirectory().getElement("FWK_LIST_PREFS");
        SQLTable columnPrefsTable = element.getTable();
        SQLSelect select = new SQLSelect();
        select.addSelectStar(columnPrefsTable);
        select.setWhere(new Where((FieldRef)columnPrefsTable.getField("ID_USER"), "=", (Object)userId).and(new Where((FieldRef)columnPrefsTable.getField("ID_TABLE"), "=", (Object)idTable)));
        List<SQLRow> rqResult = SQLRowListRSH.execute(select);
        if (rqResult != null && !rqResult.isEmpty()) {
            DocumentBuilder docBuilder;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            try {
                docBuilder = docFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                throw new IllegalStateException("Impossible to create new XML document", ex);
            }
            try {
                return docBuilder.parse(new InputSource(new StringReader(rqResult.get(0).getString("VALUE"))));
            }
            catch (SAXException ex) {
                throw new IllegalArgumentException("Impossible to parse XML from database", ex);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Impossible to read content of database", ex);
            }
        }
        return null;
    }

    public void removeXMLConf(Number userId, String idTable) throws IllegalStateException, IllegalArgumentException {
        SQLElement element = this.getDirectory().getElement("FWK_LIST_PREFS");
        SQLTable columnPrefsTable = element.getTable();
        this.getRoot().getDBSystemRoot().getDataSource().execute("DELETE FROM " + columnPrefsTable.getSQLName().quote() + " WHERE \"ID_USER\" = " + userId + " AND \"ID_TABLE\" = '" + idTable + "'");
    }

    public final synchronized Executor getNonInteractiveSQLExecutor() {
        if (this.nonInteractiveSQLExecutor == null) {
            this.nonInteractiveSQLExecutor = this.createNonInteractiveSQLExecutor();
        }
        return this.nonInteractiveSQLExecutor;
    }

    protected ExecutorService createNonInteractiveSQLExecutor() {
        return Executors.newFixedThreadPool(2);
    }
}

