/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.erp.modules.DepSolverResultMM;
import org.openconcerto.erp.modules.ModulePanel;
import org.openconcerto.erp.modules.ModuleReference;
import org.openconcerto.erp.modules.ModuleVersion;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.VFlowLayout;

public class DepSolverResultPanel
extends JPanel {
    public DepSolverResultPanel(DepSolverResultMM depSolverResult) {
        this.setLayout(new VFlowLayout());
        Set<String> idsToInstall = depSolverResult.getIDsToInstall();
        HashMap<String, ModuleVersion> versionsToUpgrade = new HashMap<String, ModuleVersion>();
        ArrayList<ModuleReference> lRemove = new ArrayList<ModuleReference>();
        for (ModuleReference ref : depSolverResult.getReferencesToRemove()) {
            if (idsToInstall.contains(ref.getID())) {
                versionsToUpgrade.put(ref.getID(), ref.getVersion());
                continue;
            }
            lRemove.add(ref);
        }
        ArrayList<ModuleReference> lInstall = new ArrayList<ModuleReference>();
        ArrayList<ModuleReference> lUpgrade = new ArrayList<ModuleReference>();
        for (ModuleReference ref : depSolverResult.getReferencesToInstall()) {
            (versionsToUpgrade.containsKey(ref.getID()) ? lUpgrade : lInstall).add(ref);
        }
        this.addLabels(lUpgrade, versionsToUpgrade, "Mise \u00e0 jour du module ", "Modules \u00e0 mettre \u00e0 jour :");
        this.addLabels(lInstall, null, "Installation du module ", "Modules \u00e0 installer :");
        this.addLabels(lRemove, null, "D\u00e9sinstallation du module ", "Modules \u00e0 d\u00e9sinstaller :");
    }

    private void addLabels(List<ModuleReference> l, Map<String, ModuleVersion> oldVersions, String single, String multi) {
        if (l.isEmpty()) {
            return;
        }
        if (l.size() == 1) {
            this.add(new JLabelBold(String.valueOf(single) + DepSolverResultPanel.getVersionString(l.get(0), oldVersions)));
        } else {
            this.add(new JLabelBold(multi));
            Collections.sort(l, ModuleReference.COMP_ID_ASC_VERSION_DESC);
            for (ModuleReference moduleReference : l) {
                this.add(new JLabel("- " + DepSolverResultPanel.getVersionString(moduleReference, oldVersions)));
            }
        }
    }

    private static final String getVersionString(ModuleReference ref, Map<String, ModuleVersion> oldVersions) {
        if (oldVersions == null) {
            return ModulePanel.format(ref);
        }
        return String.valueOf(ref.getID()) + " (" + oldVersions.get(ref.getID()) + " -> " + ref.getVersion() + ")";
    }
}

