/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import org.openconcerto.erp.core.common.ui.TotalCalculator;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.generationEcritures.GenerationMvtReglementAvoir;
import org.openconcerto.erp.generationEcritures.provider.AccountingRecordsProvider;
import org.openconcerto.erp.generationEcritures.provider.AccountingRecordsProviderManager;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class GenerationMvtAvoirClient
extends GenerationEcritures {
    public static final String ID = "accounting.records.sales.credit";
    private static final String source = "AVOIR_CLIENT";
    private static final Integer journal = 3;
    private int idAvoirClient;
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationMvtAvoirClient(SQLRow row) {
        this(row, 1);
    }

    public GenerationMvtAvoirClient(SQLRow row, int idMvt) {
        this.idMvt = idMvt;
        this.setRowAnalytiqueSource(row);
        this.idAvoirClient = row.getID();
    }

    public int genereMouvement() throws Exception {
        SQLRowValues rowValsPiece;
        int idJrnlFactor;
        SQLTable avoirClientTable = base.getTable(source);
        SQLRow avoirRow = avoirClientTable.getRow(this.idAvoirClient);
        boolean affacturage = avoirRow.getBoolean("AFFACTURE");
        SQLRow rowClient = avoirRow.getForeignRow("ID_CLIENT");
        if (ecritureTable.contains("CODE_CLIENT")) {
            this.putValue("CODE_CLIENT", rowClient.getString("CODE"));
        }
        this.date = (Date)avoirRow.getObject("DATE");
        this.nom = avoirRow.getObject("NOM").toString();
        this.putValue("DATE", new java.sql.Date(this.date.getTime()));
        AccountingRecordsProvider provider = AccountingRecordsProviderManager.get(ID);
        provider.putLabel(avoirRow, this.mEcritures);
        this.putValue("ID_JOURNAL", journal);
        if (affacturage && (idJrnlFactor = rowPrefsCompte.getInt("ID_JOURNAL_FACTOR")) > 1) {
            this.putValue("ID_JOURNAL", idJrnlFactor);
        }
        this.putValue("ID_MOUVEMENT", 1);
        if (this.idMvt == 1) {
            rowValsPiece = new SQLRowValues(pieceTable);
            provider.putPieceLabel(avoirRow, rowValsPiece);
            this.getNewMouvement(source, this.idAvoirClient, 1, rowValsPiece);
        } else {
            this.putValue("ID_MOUVEMENT", this.idMvt);
            rowValsPiece = pieceTable.getTable("MOUVEMENT").getRow(this.idMvt).getForeign("ID_PIECE").asRowValues();
            provider.putPieceLabel(avoirRow, rowValsPiece);
            rowValsPiece.update();
        }
        BigDecimal portHT = BigDecimal.valueOf(avoirRow.getLong("PORT_HT")).movePointLeft(2);
        TotalCalculator calc = rowClient.getTable().contains("ID_COMPTE_PCE_PRODUIT") && !rowClient.isForeignEmpty("ID_COMPTE_PCE_PRODUIT") ? this.getValuesFromElement(false, false, "T_PV_HT", avoirRow, avoirRow.getTable().getTable("AVOIR_CLIENT_ELEMENT"), portHT, null, null, rowClient.getForeign("ID_COMPTE_PCE_PRODUIT")) : this.getValuesFromElement(avoirRow, avoirRow.getTable().getTable("AVOIR_CLIENT_ELEMENT"), portHT, null, null);
        Map<SQLRowAccessor, Map<SQLRowAccessor, BigDecimal>> taxeCompl = calc.getMapHtTaxeCompl();
        for (SQLRowAccessor row : calc.getMapHt().keySet()) {
            Object compl;
            long b = calc.getMapHt().get(row).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
            if (b == 0L) continue;
            long taxe = 0L;
            if (taxeCompl.containsKey(row)) {
                compl = taxeCompl.get(row);
                for (SQLRowAccessor rowCompl : compl.keySet()) {
                    if (compl.get(rowCompl) == null) continue;
                    long taxeC = ((BigDecimal)compl.get(rowCompl)).multiply(rowCompl.getBigDecimal("POURCENT").movePointLeft(2)).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
                    this.putValue("ID_COMPTE_PCE", rowCompl.getForeignID("ID_COMPTE_PCE"));
                    this.putValue("CREDIT", 0L);
                    this.putValue("DEBIT", taxeC);
                    this.ajoutEcriture();
                    taxe += taxeC;
                }
            }
            this.putValue("ID_COMPTE_PCE", row.getID());
            this.putValue("DEBIT", b - taxe);
            this.putValue("CREDIT", 0L);
            compl = this.ajoutEcriture();
        }
        Map<SQLRowAccessor, BigDecimal> tvaMap = calc.getMapHtTVA();
        for (SQLRowAccessor rowAc : tvaMap.keySet()) {
            long longValue = tvaMap.get(rowAc).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
            if (longValue == 0L) continue;
            this.putValue("ID_COMPTE_PCE", rowAc.getID());
            this.putValue("DEBIT", longValue);
            this.putValue("CREDIT", 0L);
            this.ajoutEcriture();
        }
        int idCompteClient = avoirRow.getForeignRow("ID_CLIENT").getInt("ID_COMPTE_PCE");
        if (idCompteClient <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
            idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
        }
        this.putValue("ID_COMPTE_PCE", idCompteClient);
        this.putValue("DEBIT", 0L);
        long ttc = calc.getTotalTTC().movePointRight(2).longValue();
        this.putValue("CREDIT", ttc);
        this.ajoutEcriture();
        SQLRowValues valAvoir = new SQLRowValues(avoirClientTable);
        valAvoir.put("ID_MOUVEMENT", (Object)this.idMvt);
        if (valAvoir.getInvalid() == null) {
            valAvoir.update(this.idAvoirClient);
        }
        if (affacturage) {
            this.putValue("ID_COMPTE_PCE", idCompteClient);
            this.putValue("DEBIT", ttc);
            this.putValue("CREDIT", 0L);
            this.ajoutEcriture();
            int idComptefactor = rowPrefsCompte.getInt("ID_COMPTE_PCE_FACTOR");
            if (idComptefactor <= 1 && (idComptefactor = rowPrefsCompte.getInt("ID_COMPTE_PCE_FACTOR")) <= 1) {
                try {
                    idComptefactor = ComptePCESQLElement.getIdComptePceDefault("Factor");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.putValue("ID_COMPTE_PCE", idComptefactor);
            this.putValue("DEBIT", 0L);
            this.putValue("CREDIT", ttc);
            this.ajoutEcriture();
        }
        if (avoirRow.getInt("ID_MODE_REGLEMENT") > 1) {
            new GenerationMvtReglementAvoir(avoirRow, this.idMvt);
        } else {
            valAvoir.put("SOLDE", Boolean.FALSE);
            valAvoir.update(this.idAvoirClient);
            this.displayMvtNumber();
        }
        return this.idMvt;
    }
}

