/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.ui;

import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JTable;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.supplychain.supplier.ui.ListEcheanceFournRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;

public class ListPanelEcheancesFourn
extends ListeAddPanel {
    private EditFrame editFrame;
    private boolean showRegCompta = false;

    public ListPanelEcheancesFourn() {
        this(Configuration.getInstance().getDirectory().getElement("ECHEANCE_FOURNISSEUR"));
    }

    public ListPanelEcheancesFourn(SQLElement elem) {
        super(elem, new IListe(elem.getTableSource(true)));
        this.setListe();
    }

    public void setShowRegCompta(boolean b) {
        this.showRegCompta = b;
        this.setListe();
    }

    public JTable getJTable() {
        return this.getListe().getJTable();
    }

    @Override
    protected void handleAction(JButton source, ActionEvent e) {
        if (source == this.buttonModifier) {
            if (this.editFrame == null) {
                this.editFrame = new EditFrame(this.element, EditPanel.MODIFICATION);
            }
            this.editFrame.selectionId(this.getListe().getSelectedId());
            this.editFrame.pack();
            this.editFrame.setVisible(true);
            SQLRow ecritureRow = new EcritureSQLElement().getTable().getRow(this.getListe().getSelectedId());
            MouvementSQLElement.showSource(ecritureRow.getInt("ID_MOUVEMENT"));
        } else {
            super.handleAction(source, e);
        }
    }

    private void setListe() {
        SQLTable primaryTable = this.getListe().getSource().getPrimaryTable();
        Where wNotRegle = new Where((FieldRef)primaryTable.getField("REGLE"), "=", (Object)Boolean.FALSE);
        if (!this.showRegCompta) {
            wNotRegle = wNotRegle.and(new Where((FieldRef)primaryTable.getField("REG_COMPTA"), "=", (Object)Boolean.FALSE));
        }
        this.getListe().getRequest().setWhere(wNotRegle);
        this.getListe().setSQLEditable(false);
        JTable jTable = this.getListe().getJTable();
        int columnCount = jTable.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            jTable.getColumnModel().getColumn(i).setCellRenderer(new ListEcheanceFournRenderer());
            ++i;
        }
        this.setAddVisible(false);
        this.setModifyVisible(false);
        this.setDeleteVisible(false);
    }

    @Override
    public SQLComponent getModifComp() {
        return null;
    }
}

