/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.element;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.supplychain.credit.component.AvoirFournisseurSQLComponent;
import org.openconcerto.erp.core.supplychain.order.component.SaisieAchatSQLComponent;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.element.SQLElementLinksSetup;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.RowAction;

public class SaisieAchatSQLElement
extends ComptaSQLConfElement {
    public SaisieAchatSQLElement() {
        super("SAISIE_ACHAT", "une saisie d'achat", "saisies d'achats");
        this.getRowActions().add(this.getCloneAction());
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_MOUVEMENT");
        l.add("DATE");
        l.add("NOM");
        l.add("ID_FOURNISSEUR");
        l.add("MONTANT_HT");
        l.add("MONTANT_TTC");
        l.add("INFOS");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("MONTANT_TTC");
        return l;
    }

    @Override
    protected void setupLinks(SQLElementLinksSetup links) {
        super.setupLinks(links);
        links.get("ID_MOUVEMENT").setType(SQLElementLink.LinkType.ASSOCIATION);
    }

    @Override
    public SQLComponent createComponent() {
        return new SaisieAchatSQLComponent(this);
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".purchase";
    }

    public void transfertAvoir(int idFacture) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("AVOIR_FOURNISSEUR");
        EditFrame editAvoirFrame = new EditFrame(elt);
        editAvoirFrame.setIconImage(new ImageIcon(Gestion.class.getResource("frameicon.png")).getImage());
        AvoirFournisseurSQLComponent comp = (AvoirFournisseurSQLComponent)editAvoirFrame.getSQLComponent();
        SQLInjector inject = SQLInjector.getInjector(this.getTable(), elt.getTable());
        comp.select(inject.createRowValuesFrom(idFacture));
        editAvoirFrame.pack();
        editAvoirFrame.setState(0);
        editAvoirFrame.setVisible(true);
    }

    public RowAction getCloneAction() {
        return new RowAction(new AbstractAction("Dupliquer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow selectedRow = IListe.get(e).fetchSelectedRow();
                EditFrame editFrame = new EditFrame(SaisieAchatSQLElement.this, EditPanel.CREATION);
                SQLRowValues copy = SaisieAchatSQLElement.this.createCopy(selectedRow.getID());
                copy.put("ID_MOUVEMENT", null);
                copy.put("DATE", null);
                editFrame.getSQLComponent().select(copy);
                editFrame.setVisible(true);
            }
        }, true, "purchase.clone"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                return selection != null && selection.size() == 1;
            }
        };
    }
}

