/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.quote.element;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.UISQLComponent;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.users.rights.UserRightsManager;

public class DevisItemSQLElement
extends ComptaSQLConfElement {
    public DevisItemSQLElement() {
        super("DEVIS_ELEMENT", "un element de devis", "\u00e9l\u00e9ments de devis");
    }

    @Override
    protected String getParentFFName() {
        return "ID_DEVIS";
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_DEVIS");
        l.add("CODE");
        l.add("NOM");
        String articleAdvanced = DefaultNXProps.getInstance().getStringProperty("ArticleModeVenteAvance");
        Boolean bArticleAdvanced = Boolean.valueOf(articleAdvanced);
        if (bArticleAdvanced.booleanValue()) {
            l.add("PRIX_METRIQUE_VT_1");
            l.add("ID_MODE_VENTE_ARTICLE");
        }
        if (UserRightsManager.getCurrentUserRights().haveRight("CORPS_VOIR_PRIX_ACHAT")) {
            l.add("PA_HT");
        }
        l.add("PV_HT");
        l.add("QTE");
        l.add("T_PV_HT");
        l.add("T_PV_TTC");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        l.add("PA_HT");
        l.add("PV_HT");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new UISQLComponent(this){

            @Override
            public void addViews() {
                this.addRequiredSQLObject(new JTextField(), "NOM", "left");
                this.addRequiredSQLObject(new JTextField(), "CODE", "right");
                this.addSQLObject(new ElementComboBox(), "ID_STYLE", "left");
                this.addRequiredSQLObject(new DeviseField(), "PA_HT", "left");
                this.addSQLObject(new DeviseField(), "PV_HT", "right");
                this.addSQLObject(new JTextField(), "POIDS", "left");
                this.addSQLObject(new ElementComboBox(), "ID_TAXE", "right");
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".item";
    }
}

