/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.model;

import java.text.Format;
import java.util.Date;
import net.jcip.annotations.Immutable;
import org.openconcerto.utils.CompareUtils;

@Immutable
public final class RegisterState {
    private final Status status;
    private final Date date;

    public RegisterState(Status status, Date date) {
        this.status = status;
        this.status.checkDate(date);
        this.date = date == null ? null : new Date(date.getTime());
    }

    public final Status getStatus() {
        return this.status;
    }

    public boolean hasDate() {
        return this.date != null;
    }

    public final int compareDateTo(RegisterState o) {
        return this.compareDateTo(o.date);
    }

    public final int compareDateTo(Date cal) {
        return this.date.compareTo(cal);
    }

    public final String formatDate(Format f) {
        return f.format(this.date);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + this.status.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegisterState other = (RegisterState)obj;
        return this.status.equals((Object)other.status) && CompareUtils.equals(this.date, other.date);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(250);
        sb.append(this.getClass().getSimpleName());
        if (this.getStatus() == Status.OBSOLETE) {
            sb.append(' ');
            sb.append((Object)this.getStatus());
        } else if (this.getStatus() == Status.CLOSED && !this.hasDate()) {
            sb.append(" never opened");
        } else {
            assert (this.date != null);
            sb.append(' ');
            sb.append((Object)this.getStatus());
            sb.append(" at ");
            sb.append(this.date);
        }
        return sb.toString();
    }

    public static enum Status {
        OBSOLETE{

            @Override
            protected void checkDate(Date date) {
                if (date != null) {
                    throw new IllegalArgumentException("Cannot have date for " + (Object)((Object)this));
                }
            }
        }
        ,
        CLOSED{

            @Override
            protected void checkDate(Date date) {
            }
        }
        ,
        OPEN{

            @Override
            protected void checkDate(Date date) {
                if (date == null) {
                    throw new IllegalArgumentException("Missing date for " + (Object)((Object)this));
                }
            }
        };


        protected abstract void checkDate(Date var1);
    }
}

