/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.model;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;

public class ReceiptCode {
    private static final int DIR_DEPTH = 3;
    private static final int FILE_DEPTH = 4;
    private static final String EXT = ".xml";
    private static final String DELETED_SUFFIX = "_deleted";
    private static final String DELETED_EXT = ".xml_deleted";
    private static final String IMPORTED_SUFFIX = "_imported";
    private static final String IMPORTED_EXT = ".xml_imported";
    private static final DecimalFormat DIGIT2_FORMAT = new DecimalFormat("00");
    private static final DecimalFormat DIGIT4_FORMAT = new DecimalFormat("0000");
    private static final DecimalFormat INDEX_FORMAT = new DecimalFormat("00000");
    private final int caisseNb;
    private final Calendar day;
    private final int dayIndex;
    private final String code;
    private SimpleDateFormat dateFormat;

    static {
        DIGIT2_FORMAT.setMaximumIntegerDigits(DIGIT2_FORMAT.getMinimumIntegerDigits());
        DIGIT4_FORMAT.setMaximumIntegerDigits(DIGIT4_FORMAT.getMinimumIntegerDigits());
        INDEX_FORMAT.setMaximumIntegerDigits(INDEX_FORMAT.getMinimumIntegerDigits());
    }

    public static final File getRootDir() {
        return ReceiptCode.getRootDir(false);
    }

    public static final File getRootDir(boolean archived) {
        TemplateNXProps nxprops = (TemplateNXProps)TemplateNXProps.getInstance();
        return new File(nxprops.getDefaultStringValue(), archived ? "Tickets archiv\u00e9s" : "Tickets");
    }

    public static final File getDayDir(Calendar cal, boolean create) {
        return ReceiptCode.getDayDir(ReceiptCode.getRootDir(), cal, create);
    }

    public static final File getDayDir(File rootDir, Calendar cal, boolean create) {
        int j = cal.get(5);
        int m = cal.get(2) + 1;
        int a = cal.get(1);
        List<String> dirs = Arrays.asList(DIGIT4_FORMAT.format(a), DIGIT2_FORMAT.format(m), DIGIT2_FORMAT.format(j));
        assert (dirs.size() == 3);
        File res = rootDir;
        for (String dir : dirs) {
            res = new File(res, dir);
        }
        if (create) {
            try {
                FileUtils.mkdir_p(res);
            }
            catch (IOException e) {
                ExceptionHandler.handle("Impossible de cr\u00e9er le dossier des tickets.\n\n" + res.getAbsolutePath());
            }
        }
        return res;
    }

    public static final List<File> getReceiptsToImport(int caisseNb) {
        return FileUtils.list(ReceiptCode.getRootDir(), 4, ReceiptCode.createFF(DIGIT2_FORMAT.format(caisseNb), false, false));
    }

    protected static FileFilter createFF(final String prefix, final boolean includeDeleted, final boolean includeImported) {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (!f.isFile() || !f.getName().startsWith(prefix)) {
                    return false;
                }
                return f.getName().endsWith(ReceiptCode.EXT) || includeDeleted && f.getName().endsWith(ReceiptCode.DELETED_EXT) || includeImported && f.getName().endsWith(ReceiptCode.IMPORTED_EXT);
            }
        };
    }

    private static final String getEnd(String s, List<String> candidates) {
        for (String candidate : candidates) {
            if (!s.endsWith(candidate)) continue;
            return candidate;
        }
        return null;
    }

    public static final ReceiptCode fromFile(File f) {
        String name = f.getName();
        String toRm = ReceiptCode.getEnd(name, Arrays.asList(EXT, DELETED_EXT, IMPORTED_EXT));
        if (toRm == null) {
            return null;
        }
        try {
            return new ReceiptCode(name.substring(0, name.length() - toRm.length()));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static void archiveCompletelyImported() throws IOException {
        File archiveDir = ReceiptCode.getRootDir(true);
        FileUtils.mkdir_p(archiveDir);
        File rootDir = ReceiptCode.getRootDir(false);
        List<File> dirs = FileUtils.list(rootDir, 3, FileUtils.DIR_FILTER);
        File todayDir = ReceiptCode.getDayDir(rootDir, Calendar.getInstance(), false);
        for (File dir : dirs) {
            if (todayDir.equals(dir) || dir.listFiles(ReceiptCode.createFF("", false, false)).length != 0) continue;
            File destDir = new File(archiveDir, FileUtils.relative(rootDir, dir));
            FileUtils.mkParentDirs(destDir);
            if (!destDir.exists()) {
                String err = FileUtils.mv(dir, destDir);
                if (err != null) {
                    throw new IOException(err);
                }
            } else {
                File[] fileArray = dir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    FileUtils.mv(f, destDir);
                    ++n2;
                }
                FileUtils.rm(dir);
            }
            assert (!dir.exists());
        }
    }

    private static Number parse(DecimalFormat f, String s, ParsePosition pos) throws ParseException {
        return (Number)ReceiptCode.parse(f, s, pos, f.getMaximumIntegerDigits());
    }

    private static Date parse(SimpleDateFormat f, String s, ParsePosition pos) throws ParseException {
        return (Date)ReceiptCode.parse(f, s, pos, f.toPattern().length());
    }

    private static Object parse(Format f, String s, ParsePosition pos, int maxChar) throws ParseException {
        return f.parseObject(s.substring(0, pos.getIndex() + maxChar), pos);
    }

    public ReceiptCode(String code) throws ParseException {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < code.length()) {
            char c = code.charAt(i);
            if (Character.isDigit(c)) {
                b.append(c);
            }
            ++i;
        }
        this.code = code = b.toString();
        this.setCalendar(Calendar.getInstance());
        ParsePosition pos = new ParsePosition(0);
        this.caisseNb = ReceiptCode.parse(DIGIT2_FORMAT, code, pos).intValue();
        this.day = this.getCalendar();
        this.day.setTime(ReceiptCode.parse(this.dateFormat, code, pos));
        this.dayIndex = ReceiptCode.parse(INDEX_FORMAT, code, pos).intValue();
    }

    public ReceiptCode(int caisseNb, Calendar cal, int dayIndex) {
        this.setCalendar(cal);
        this.caisseNb = caisseNb;
        this.day = (Calendar)cal.clone();
        this.dayIndex = dayIndex;
        this.code = String.valueOf(DIGIT2_FORMAT.format(this.caisseNb)) + this.dateFormat.format(this.day.getTime()) + INDEX_FORMAT.format(this.dayIndex);
    }

    public final void setCalendar(Calendar newCal) {
        Calendar cal = (Calendar)newCal.clone();
        this.dateFormat = new SimpleDateFormat("ddMMyy");
        this.dateFormat.setCalendar(cal);
        cal.clear();
        cal.set(2000, 0, 1);
        this.dateFormat.set2DigitYearStart(cal.getTime());
    }

    public final Calendar getCalendar() {
        return (Calendar)this.dateFormat.getCalendar().clone();
    }

    public final int getCaisseNb() {
        return this.caisseNb;
    }

    public final Calendar getDay() {
        return this.day;
    }

    public final int getDayIndex() {
        return this.dayIndex;
    }

    public final String getCodePrefix() {
        return this.code.substring(0, this.code.length() - INDEX_FORMAT.getMinimumIntegerDigits());
    }

    public final String getCode() {
        return this.code;
    }

    public final File getDir(boolean create) {
        return ReceiptCode.getDayDir(this.getDay(), create);
    }

    @Deprecated
    public final File getFile() {
        return new File(this.getDir(true), this.getFileName());
    }

    public final String getFileName() {
        return String.valueOf(this.getCode().replace(' ', '_')) + EXT;
    }

    public void markDeleted() throws IOException {
        this.mark(DELETED_SUFFIX);
    }

    public void markImported() throws IOException {
        this.mark(IMPORTED_SUFFIX);
    }

    private final void mark(String suffix) throws IOException {
        File f = this.getFile();
        if (!f.renameTo(new File(f.getParentFile(), String.valueOf(f.getName()) + suffix))) {
            throw new IOException("Couldn't rename " + f);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getCode();
    }
}

