/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.element;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTextField;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.UISQLComponent;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.utils.PartialUniqueTrigger;

public class TicketCaisseSQLElement
extends ComptaSQLConfElement {
    public static final String UNARCHIVED_WHERE = String.valueOf(SQLBase.quoteIdentifier("ARCHIVE")) + " = " + 0;
    public static final String DATE_WHERE = String.valueOf(UNARCHIVED_WHERE) + " and " + SQLBase.quoteIdentifier("FILE_HASH") + " is not null";

    public TicketCaisseSQLElement() {
        super("TICKET_CAISSE", "un ticket de caisse", "tickets de caisses");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("DATE");
        l.add("ID_CAISSE");
        l.add("TOTAL_HT");
        l.add("TOTAL_TTC");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new UISQLComponent(this){

            @Override
            public void addViews() {
                this.addRequiredSQLObject(new JTextField(), "NOM", "right");
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".ticket";
    }

    public static final class UniqueDate_PartialUniqueTrigger
    extends PartialUniqueTrigger {
        public UniqueDate_PartialUniqueTrigger() {
            super(Arrays.asList("ID_CAISSE", "DATE"), DATE_WHERE);
        }
    }

    public static final class UniqueNumber_PartialUniqueTrigger
    extends PartialUniqueTrigger {
        public UniqueNumber_PartialUniqueTrigger() {
            super(Arrays.asList("NUMERO"), UNARCHIVED_WHERE);
        }
    }
}

