/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.order.action;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.common.ui.ListeViewPanel;
import org.openconcerto.erp.core.sales.order.element.CommandeClientElementSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.state.WindowStateManager;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.cc.ITransformer;

public class ListeDesElementsACommanderClientAction
extends CreateFrameAbstractAction {
    final CommandeClientElementSQLElement eltCmd = (CommandeClientElementSQLElement)Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT_ELEMENT");
    private BaseSQLTableModelColumn colAvancement;

    public ListeDesElementsACommanderClientAction() {
        this.putValue("Name", "Liste des \u00e9l\u00e9ments en attente de livraison");
    }

    public JFrame createFrame() {
        JFrame frame = new JFrame("El\u00e9ments en attente de livraison");
        JPanel orderPanel = this.createPanel();
        frame.getContentPane().add(orderPanel);
        FrameUtil.setBounds(frame);
        File file = IListFrame.getConfigFile(this.eltCmd, frame.getClass());
        if (file != null) {
            new WindowStateManager(frame, file).loadState();
        }
        return frame;
    }

    JPanel createPanel() {
        SQLTableModelSourceOnline tableSource = this.eltCmd.getTableSource(true);
        tableSource.getReq().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                String quoteQteL = new SQLName(input.getAlias(ListeDesElementsACommanderClientAction.this.eltCmd.getTable()).getAlias(), "QTE_LIVREE").quote();
                String quoteQte = new SQLName(input.getAlias(ListeDesElementsACommanderClientAction.this.eltCmd.getTable()).getAlias(), "QTE").quote();
                String quoteQteU = new SQLName(input.getAlias(ListeDesElementsACommanderClientAction.this.eltCmd.getTable()).getAlias(), "QTE_UNITAIRE").quote();
                Where w = Where.createRaw(String.valueOf(quoteQteL) + " < (" + quoteQte + "*" + quoteQteU + ")", ListeDesElementsACommanderClientAction.this.eltCmd.getTable().getField("QTE_LIVREE"), ListeDesElementsACommanderClientAction.this.eltCmd.getTable().getField("QTE"), ListeDesElementsACommanderClientAction.this.eltCmd.getTable().getField("QTE_UNITAIRE"));
                input.setWhere(w);
                return input;
            }
        });
        BaseSQLTableModelColumn colStockR = new BaseSQLTableModelColumn("Stock Reel", Float.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                SQLRowAccessor foreign2;
                SQLRowAccessor foreign = r.getForeign("ID_ARTICLE");
                if (foreign != null && !foreign.isUndefined() && (foreign2 = foreign.getForeign("ID_STOCK")) != null && !foreign2.isUndefined()) {
                    return Float.valueOf(foreign2.getFloat("QTE_REEL"));
                }
                return Float.valueOf(0.0f);
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(ListeDesElementsACommanderClientAction.this.eltCmd.getTable());
                p = (Path)p.add(p.getLast().getField("ID_ARTICLE"));
                p = (Path)p.add(p.getLast().getField("ID_STOCK"));
                return CollectionUtils.createSet(new FieldPath(p, "QTE_REEL"));
            }
        };
        tableSource.getColumns().add(colStockR);
        BaseSQLTableModelColumn colLiv2 = new BaseSQLTableModelColumn("Stock TH", Float.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                SQLRowAccessor foreign2;
                SQLRowAccessor foreign = r.getForeign("ID_ARTICLE");
                if (foreign != null && !foreign.isUndefined() && (foreign2 = foreign.getForeign("ID_STOCK")) != null && !foreign2.isUndefined()) {
                    return Float.valueOf(foreign2.getFloat("QTE_TH"));
                }
                return Float.valueOf(0.0f);
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(ListeDesElementsACommanderClientAction.this.eltCmd.getTable());
                p = (Path)p.add(p.getLast().getField("ID_ARTICLE"));
                p = (Path)p.add(p.getLast().getField("ID_STOCK"));
                return CollectionUtils.createSet(new FieldPath(p, "QTE_TH"));
            }
        };
        tableSource.getColumns().add(colLiv2);
        BaseSQLTableModelColumn colStockMin = new BaseSQLTableModelColumn("Stock Min", Integer.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                SQLRowAccessor foreign = r.getForeign("ID_ARTICLE");
                return foreign.getInt("QTE_MIN");
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(ListeDesElementsACommanderClientAction.this.eltCmd.getTable());
                p = (Path)p.add(p.getLast().getField("ID_ARTICLE"));
                return CollectionUtils.createSet(new FieldPath(p, "QTE_MIN"));
            }
        };
        tableSource.getColumns().add(colStockMin);
        BaseSQLTableModelColumn colSug = new BaseSQLTableModelColumn("Qt\u00e8 \u00e0 commander", Float.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                SQLRowAccessor foreign = r.getForeign("ID_ARTICLE");
                if (foreign != null && !foreign.isUndefined()) {
                    float manque;
                    float qteMin = foreign.getFloat("QTE_MIN");
                    SQLRowAccessor foreign2 = foreign.getForeign("ID_STOCK");
                    if (foreign2 != null && !foreign2.isUndefined() && (manque = foreign2.getFloat("QTE_TH") - qteMin) < 0.0f) {
                        return Float.valueOf(-manque);
                    }
                }
                return Float.valueOf(0.0f);
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path pA = new Path(ListeDesElementsACommanderClientAction.this.eltCmd.getTable());
                pA = (Path)pA.add(pA.getLast().getField("ID_ARTICLE"));
                Path p = (Path)pA.add(pA.getLast().getField("ID_STOCK"));
                return CollectionUtils.createSet(new FieldPath(pA, "QTE_MIN"), new FieldPath(p, "QTE_TH"));
            }
        };
        tableSource.getColumns().add(colSug);
        ListeAddPanel panel = this.getPanel(this.eltCmd, tableSource);
        RowAction.PredicateRowAction action = new RowAction.PredicateRowAction(new AbstractAction("Calcul des besoins"){

            @Override
            public void actionPerformed(ActionEvent e) {
                final SQLElement artElt = ListeDesElementsACommanderClientAction.this.eltCmd.getForeignElement("ID_ARTICLE");
                SQLTableModelSourceOnline createTableSource = artElt.createTableSource();
                createTableSource.getReq().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                    @Override
                    public SQLSelect transformChecked(SQLSelect input) {
                        FieldRef refStock = input.getAlias(artElt.getTable().getForeignTable("ID_STOCK").getField("QTE_TH"));
                        SQLSelectJoin j = input.getJoinFromField(artElt.getTable().getTable("ARTICLE_ELEMENT").getField("ID_ARTICLE_PARENT"));
                        Where w = new Where(refStock, "<", artElt.getTable().getField("QTE_MIN"));
                        w = w.and(new Where(j.getJoinedTable().getKey(), "=", (Object)null));
                        input.setWhere(w);
                        return input;
                    }
                });
                BaseSQLTableModelColumn colSug = new BaseSQLTableModelColumn("Qt\u00e8 \u00e0 commander", Float.class){

                    @Override
                    protected Object show_(SQLRowAccessor r) {
                        float manque;
                        float qteMin = r.getFloat("QTE_MIN");
                        SQLRowAccessor foreign2 = r.getForeign("ID_STOCK");
                        if (foreign2 != null && !foreign2.isUndefined() && (manque = foreign2.getFloat("QTE_TH") - qteMin) < 0.0f) {
                            return Float.valueOf(-manque);
                        }
                        return Float.valueOf(0.0f);
                    }

                    @Override
                    public Set<FieldPath> getPaths() {
                        Path pA = new Path(artElt.getTable());
                        Path p = (Path)pA.add(pA.getLast().getField("ID_STOCK"));
                        return CollectionUtils.createSet(new FieldPath(pA, "QTE_MIN"), new FieldPath(p, "QTE_TH"));
                    }
                };
                createTableSource.getColumns().add(colSug);
                IListe listeArt = new IListe(createTableSource);
                RowAction.PredicateRowAction predicateACtion = new RowAction.PredicateRowAction(new AbstractAction("Passer une commande fournisseur"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        List<SQLRowValues> selectedRows = IListe.get(e).getSelectedRows();
                        (this).ListeDesElementsACommanderClientAction.this.eltCmd.createCommandeF(selectedRows);
                    }
                }, true);
                predicateACtion.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
                listeArt.addIListeAction(predicateACtion);
                ListeViewPanel p = new ListeViewPanel(artElt, listeArt);
                IListFrame f = new IListFrame(p);
                FrameUtil.show(f);
            }
        }, true);
        action.setPredicate(IListeAction.IListeEvent.createTotalRowCountPredicate(0, Integer.MAX_VALUE));
        panel.getListe().addIListeAction(action);
        return panel;
    }

    private BigDecimal getAvancementLFromBL(SQLRowAccessor r) {
        Collection<? extends SQLRowAccessor> rows = r.getReferentRows(r.getTable().getTable("COMMANDE_CLIENT_ELEMENT"));
        BigDecimal totalQte = BigDecimal.ZERO;
        BigDecimal totalQteL = BigDecimal.ZERO;
        for (SQLRowAccessor sQLRowAccessor : rows) {
            BigDecimal qte = sQLRowAccessor.getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(sQLRowAccessor.getInt("QTE")));
            totalQte = totalQte.add(qte);
            totalQteL = sQLRowAccessor.getBoolean("LIVRE_FORCED") != false || sQLRowAccessor.getBoolean("LIVRE") != false ? totalQteL.add(qte) : totalQteL.add(sQLRowAccessor.getBigDecimal("QTE_LIVREE"));
        }
        if (totalQte.signum() != 0) {
            return totalQteL.divide(totalQte, DecimalUtils.HIGH_PRECISION).movePointRight(2).setScale(2, RoundingMode.HALF_UP);
        }
        return BigDecimal.ONE.movePointRight(2);
    }

    private ListeAddPanel getPanel(SQLElement eltCmd, SQLTableModelSourceOnline tableSource) {
        ListeAddPanel panel = new ListeAddPanel(eltCmd, new IListe(tableSource));
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.fill = 1;
        c.anchor = 13;
        c.weightx = 1.0;
        c.gridy = 4;
        IListFilterDatePanel datePanel = new IListFilterDatePanel(panel.getListe(), eltCmd.getTable().getForeignTable("ID_COMMANDE_CLIENT").getField("DATE"), IListFilterDatePanel.getDefaultMap());
        datePanel.setFilterOnDefault();
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridBagLayout());
        bottomPanel.setOpaque(false);
        DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
        c2.fill = 0;
        c2.weightx = 1.0;
        bottomPanel.add((Component)datePanel, c2);
        panel.add((Component)bottomPanel, c);
        return panel;
    }
}

