/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.ui;

import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.sales.invoice.ui.ListEcheanceClientRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumnPath;
import org.openconcerto.sql.view.list.SQLTableModelSource;

public class ListPanelEcheancesClients
extends ListeAddPanel {
    private EditFrame editFrame;
    private boolean showRegCompta = false;
    private boolean onlyOld = false;

    public ListPanelEcheancesClients() {
        this(false);
    }

    public ListPanelEcheancesClients(boolean onlyOld) {
        this(Configuration.getInstance().getDirectory().getElement("ECHEANCE_CLIENT"), onlyOld);
    }

    private ListPanelEcheancesClients(SQLElement elem, boolean onlyOld) {
        super(elem, new IListe(elem.getTableSource(true)));
        this.onlyOld = onlyOld;
        this.setListe();
    }

    public JTable getJTable() {
        return this.getListe().getJTable();
    }

    public void setShowRegCompta(boolean b) {
        this.showRegCompta = b;
        this.setListe();
    }

    @Override
    protected void handleAction(JButton source, ActionEvent e) {
        if (source == this.buttonModifier) {
            if (this.editFrame == null) {
                this.editFrame = new EditFrame(this.element, EditFrame.MODIFICATION);
            }
            this.editFrame.selectionId(this.getListe().getSelectedId());
            this.editFrame.pack();
            this.editFrame.setVisible(true);
            SQLRow ecritureRow = Configuration.getInstance().getDirectory().getElement(EcritureSQLElement.class).getTable().getRow(this.getListe().getSelectedId());
            MouvementSQLElement.showSource(ecritureRow.getInt("ID_MOUVEMENT"));
        } else {
            super.handleAction(source, e);
        }
    }

    private void setListe() {
        SQLTable elementEchT = this.getListe().getSource().getPrimaryTable();
        Where wNotRegle = new Where((FieldRef)elementEchT.getField("REGLE"), "=", (Object)Boolean.FALSE);
        if (!this.showRegCompta) {
            wNotRegle = wNotRegle.and(new Where((FieldRef)elementEchT.getField("REG_COMPTA"), "=", (Object)Boolean.FALSE));
        }
        if (this.onlyOld) {
            Calendar c = Calendar.getInstance();
            c.add(5, -7);
            Date date = c.getTime();
            wNotRegle = wNotRegle.and(new Where((FieldRef)elementEchT.getField("DATE"), "<", (Object)date));
        }
        this.getListe().getRequest().setWhere(wNotRegle);
        ListEcheanceClientRenderer rend = new ListEcheanceClientRenderer(false);
        ListEcheanceClientRenderer rendDate = new ListEcheanceClientRenderer(true);
        SQLTableModelColumn colDate = this.getListe().getSource().getColumn(elementEchT.getField("DATE"));
        int indexColDate = this.getListe().getSource().getColumns().indexOf(colDate);
        int i = 0;
        while (i < this.getListe().getJTable().getColumnCount()) {
            if (this.getListe().getJTable().getColumnClass(i) != Boolean.class) {
                TableColumn col = this.getListe().getJTable().getColumnModel().getColumn(i);
                if (col.getModelIndex() == indexColDate) {
                    col.setCellRenderer(rendDate);
                } else {
                    col.setCellRenderer(rend);
                }
            }
            ++i;
        }
        this.getListe().getSource().getColumn(elementEchT.getField("DATE")).setRenderer(rendDate);
        this.buttonAjouter.setVisible(false);
        this.buttonEffacer.setVisible(false);
        this.buttonModifier.setVisible(false);
        SQLTableModelSource src = this.getListe().getSource();
        this.getListe().setSQLEditable(true);
        SQLField fieldDateEch = elementEchT.getField("DATE");
        for (SQLTableModelColumn column : src.getColumns()) {
            if (column.getClass().isAssignableFrom(SQLTableModelColumnPath.class)) {
                ((SQLTableModelColumnPath)column).setEditable(false);
            }
            if (column.getFields().contains(fieldDateEch)) {
                column.setRenderer(rendDate);
                continue;
            }
            column.setRenderer(rend);
        }
        ((SQLTableModelColumnPath)src.getColumns(this.getElement().getTable().getField("INFOS")).iterator().next()).setEditable(true);
    }

    @Override
    public SQLComponent getModifComp() {
        return null;
    }
}

