/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.report;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;

public class ReportingStockXmlSheet
extends AbstractListeSheetXml {
    private final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
    public static final String TEMPLATE_ID = "EtatStocks";
    public static final String TEMPLATE_PROPERTY_NAME = "Default";
    private Date date;
    private SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement("ARTICLE");
    private SQLElement eltStock = Configuration.getInstance().getDirectory().getElement("STOCK");

    public ReportingStockXmlSheet(boolean fournisseur) {
        this.printer = PrinterNXProps.getInstance().getStringProperty("BonPrinter");
    }

    @Override
    public String getStoragePathP() {
        return "Autres";
    }

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    public String getName() {
        if (this.date == null) {
            this.date = new Date();
        }
        return TEMPLATE_ID + this.date.getTime();
    }

    @Override
    protected void createListeValues() {
        SQLTable tableArt = this.eltArticle.getTable();
        SQLRowValues rowVals = new SQLRowValues(tableArt);
        rowVals.put("ID_FOURNISSEUR", null);
        rowVals.put("ID_FAMILLE_ARTICLE", null);
        rowVals.put("CODE", null);
        rowVals.put("NOM", null);
        rowVals.put("PA_HT", null);
        rowVals.put("PV_HT", null);
        rowVals.putRowValues("ID_STOCK").putNulls("QTE_REEL");
        SQLRowValuesListFetcher fetch = SQLRowValuesListFetcher.create(rowVals);
        List<SQLRowValues> values = fetch.fetch();
        SQLTable tableF = tableArt.getTable("FAMILLE_ARTICLE");
        SQLSelect selFam = new SQLSelect();
        selFam.addSelect(tableF.getKey());
        selFam.addSelect(tableF.getField("NOM"));
        selFam.addSelect(tableF.getField("ID_FAMILLE_ARTICLE_PERE"));
        List<SQLRow> fam = SQLRowListRSH.execute(selFam);
        HashMap<Integer, SQLRow> mapF = new HashMap<Integer, SQLRow>();
        for (SQLRow sqlRow : fam) {
            mapF.put(sqlRow.getID(), sqlRow);
        }
        SQLTable tableFourn = tableArt.getTable("FOURNISSEUR");
        SQLSelect selFourn = new SQLSelect();
        selFourn.addSelect(tableFourn.getKey());
        selFourn.addSelect(tableFourn.getField("NOM"));
        List<SQLRow> fourn = SQLRowListRSH.execute(selFourn);
        HashMap<Integer, SQLRow> mapFourn = new HashMap<Integer, SQLRow>();
        for (SQLRow sqlRow : fourn) {
            mapFourn.put(sqlRow.getID(), sqlRow);
        }
        HashMap<String, Line> linesFamilles = new HashMap<String, Line>();
        TreeMap myValues = new TreeMap(new Comparator<Line>(){

            @Override
            public int compare(Line o1, Line o2) {
                return o1.getNomArt().compareTo(o2.getNomArt());
            }
        });
        Line lineTotal = new Line("Total", "", BigDecimal.ZERO, Float.valueOf(0.0f));
        HashMap<Integer, String> style = new HashMap<Integer, String>();
        for (SQLRowValues vals : values) {
            Map mapSF;
            Line lineSF;
            Line lineF;
            Float qte = Float.valueOf(vals.getForeign("ID_STOCK").getFloat("QTE_REEL"));
            BigDecimal ha = BigDecimal.ZERO;
            if (!(qte.floatValue() > 0.0f)) continue;
            ha = vals.getBigDecimal("PA_HT").multiply(new BigDecimal(qte.floatValue()));
            int idFamille = vals.getForeignID("ID_FAMILLE_ARTICLE");
            SQLRow rowF = (SQLRow)mapF.get(idFamille);
            Line lineArt = new Line(vals.getString("NOM"), vals.getString("CODE"), ha, qte);
            if (rowF == null) {
                if (!linesFamilles.containsKey("Undef")) {
                    linesFamilles.put("Undef", new Line("Sans famille", "", BigDecimal.ZERO, Float.valueOf(0.0f)));
                    linesFamilles.put("Undef-Undef", new Line("", "", BigDecimal.ZERO, Float.valueOf(0.0f)));
                }
                lineF = (Line)linesFamilles.get("Undef");
                lineSF = (Line)linesFamilles.get("Undef-Undef");
            } else if (rowF.getObject("ID_FAMILLE_ARTICLE_PERE") == null || rowF.isForeignEmpty("ID_FAMILLE_ARTICLE_PERE")) {
                if (!linesFamilles.containsKey(String.valueOf(rowF.getID()))) {
                    linesFamilles.put(String.valueOf(rowF.getID()), new Line(rowF.getString("NOM"), "", BigDecimal.ZERO, Float.valueOf(0.0f)));
                    linesFamilles.put(String.valueOf(String.valueOf(rowF.getID())) + "-Undef", new Line("", "", BigDecimal.ZERO, Float.valueOf(0.0f)));
                }
                if (!linesFamilles.containsKey(String.valueOf(String.valueOf(rowF.getID())) + "-Undef")) {
                    linesFamilles.put(String.valueOf(String.valueOf(rowF.getID())) + "-Undef", new Line("", "", BigDecimal.ZERO, Float.valueOf(0.0f)));
                }
                lineF = (Line)linesFamilles.get(String.valueOf(rowF.getID()));
                lineSF = (Line)linesFamilles.get(String.valueOf(String.valueOf(rowF.getID())) + "-Undef");
            } else {
                if (!linesFamilles.containsKey(String.valueOf(rowF.getID()))) {
                    linesFamilles.put(String.valueOf(rowF.getID()), new Line(rowF.getString("NOM"), "", BigDecimal.ZERO, Float.valueOf(0.0f)));
                }
                if (!linesFamilles.containsKey(String.valueOf(rowF.getForeignID("ID_FAMILLE_ARTICLE_PERE")))) {
                    SQLRow rowSF = (SQLRow)mapF.get(rowF.getForeignID("ID_FAMILLE_ARTICLE_PERE"));
                    linesFamilles.put(String.valueOf(rowF.getForeignID("ID_FAMILLE_ARTICLE_PERE")), new Line(rowSF.getString("NOM"), "", BigDecimal.ZERO, Float.valueOf(0.0f)));
                }
                lineF = (Line)linesFamilles.get(String.valueOf(rowF.getForeignID("ID_FAMILLE_ARTICLE_PERE")));
                lineSF = (Line)linesFamilles.get(String.valueOf(rowF.getID()));
            }
            if (!myValues.containsKey(lineF)) {
                myValues.put(lineF, new TreeMap(new Comparator<Line>(){

                    @Override
                    public int compare(Line o1, Line o2) {
                        return o1.getNomArt().compareTo(o2.getNomArt());
                    }
                }));
                ((Map)myValues.get(lineF)).put(lineSF, new ArrayList());
            }
            if (!(mapSF = (Map)myValues.get(lineF)).containsKey(lineSF)) {
                mapSF.put(lineSF, new ArrayList());
            }
            List lines = (List)mapSF.get(lineSF);
            lines.add(lineArt);
            lineTotal.add(lineArt);
            lineF.add(lineArt);
            lineSF.add(lineArt);
        }
        ArrayList<Map<String, Object>> listValues = new ArrayList<Map<String, Object>>();
        for (Line f : myValues.keySet()) {
            listValues.add(f.getMapXMLSheet());
            style.put(style.keySet().size(), "Titre 1");
            Map sfs = (Map)myValues.get(f);
            for (Line sf : sfs.keySet()) {
                listValues.add(sf.getMapXMLSheet());
                style.put(style.keySet().size(), "Titre 2");
                List vals = (List)sfs.get(sf);
                Collections.sort(vals, new Comparator<Line>(){

                    @Override
                    public int compare(Line o1, Line o2) {
                        return o1.getNomArt().compareTo(o2.getNomArt());
                    }
                });
                for (Line line : vals) {
                    listValues.add(line.getMapXMLSheet());
                    style.put(style.keySet().size(), "Normal");
                }
            }
        }
        listValues.add(lineTotal.getMapXMLSheet());
        style.put(style.keySet().size(), "Titre 1");
        HashMap<String, String> valuesSheet = new HashMap<String, String>();
        valuesSheet.put("DATE", "Au " + this.dateFormat.format(new Date()));
        this.listAllSheetValues.put(0, listValues);
        this.styleAllSheetValues.put(0, style);
        this.mapAllSheetValues.put(0, valuesSheet);
    }

    class Line {
        private final String nomArt;
        private final String codeArt;
        private BigDecimal totalHA;
        private Float qte;

        public Line(String nomArt, String codeArt, BigDecimal totalHA, Float qte) {
            this.nomArt = nomArt;
            this.codeArt = codeArt;
            this.totalHA = totalHA;
            this.qte = qte;
        }

        public Float getQte() {
            return this.qte;
        }

        public String getCodeArt() {
            return this.codeArt;
        }

        public String getNomArt() {
            return this.nomArt;
        }

        public BigDecimal getTotalHA() {
            return this.totalHA;
        }

        public void add(Line l) {
            this.totalHA = this.totalHA.add(l.getTotalHA());
            if (l.getQte().floatValue() > 0.0f) {
                this.qte = Float.valueOf(this.qte.floatValue() + l.getQte().floatValue());
            }
        }

        public Map<String, Object> getMapXMLSheet() {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("CODE", this.getCodeArt());
            m.put("NOM", this.getNomArt());
            m.put("QTE", this.getQte());
            m.put("TOTAL_HA", this.getTotalHA());
            return m;
        }
    }
}

