/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.report;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.preferences.MailRelancePreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.utils.GestionDevise;

public class MailRelanceCreator {
    SQLRow rowEcheance;

    public String getDefaultObject() {
        return "Relance {FactureNumero}";
    }

    public String getDefaultValue() {
        String value = "Bonjour,\n\nSauf erreur de notre part, votre compte laisse appara\u00eetre dans nos livres un montant de {FactureRestant}\u20ac non r\u00e9gl\u00e9 \u00e0 ce jour.\nCe montant correspond \u00e0 la facture {FactureNumero} dat\u00e9e du {FactureDate} qui a pour \u00e9ch\u00e9ance le {FactureDateEcheance}.\nNous pr\u00e9sumons qu'il s'agit d'un simple oubli de votre part.\n\nToutefois, si le paiement avait \u00e9t\u00e9 effectu\u00e9, nous vous serions tr\u00e8s oblig\u00e9s de nous en communiquer la date et le mode de r\u00e8glement.\n\nDans l'attente d\u2019un prompt r\u00e8glement,\n\nNous vous prions d'agr\u00e9er, Madame, Monsieur, l'expression de nos sentiments distingu\u00e9s.";
        return value;
    }

    public Map<String, String> getMapValues(SQLRow rowEch, String datePattern) {
        SQLRow clientRowNX;
        HashMap<String, String> map = new HashMap<String, String>();
        SQLRow rowSoc = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        SQLRow rowSocAdresse = rowSoc.getForeignRow("ID_ADRESSE_COMMON");
        SQLRow rowUser = rowSoc.getTable().getDBRoot().findTable("USER_COMMON").getRow(UserManager.getUser().getId());
        map.put("UserName", rowUser.getString("NOM"));
        map.put("UserFirstName", rowUser.getString("PRENOM"));
        if (rowUser.getTable().contains("MAIL")) {
            map.put("UserMail", rowUser.getString("MAIL"));
        }
        if (rowUser.getTable().contains("TEL")) {
            map.put("UserTel", rowUser.getString("TEL"));
        }
        map.put("SocieteType", rowSoc.getString("TYPE"));
        map.put("SocieteNom", rowSoc.getString("NOM"));
        map.put("SocieteAdresse", rowSocAdresse.getString("RUE"));
        map.put("SocieteCodePostal", rowSocAdresse.getString("CODE_POSTAL"));
        String ville = rowSocAdresse.getString("VILLE");
        Object cedex = rowSocAdresse.getObject("CEDEX");
        boolean hasCedex = rowSocAdresse.getBoolean("HAS_CEDEX");
        if (hasCedex) {
            ville = String.valueOf(ville) + " CEDEX";
            if (cedex != null && cedex.toString().trim().length() > 0) {
                ville = String.valueOf(ville) + " " + cedex.toString().trim();
            }
        }
        map.put("SocieteVille", ville);
        SQLRow rowClient = clientRowNX = rowEch.getForeignRow("ID_CLIENT");
        SQLRow rowAdresse = rowClient.getForeignRow("ID_ADRESSE");
        if (!clientRowNX.isForeignEmpty("ID_ADRESSE_F")) {
            rowAdresse = clientRowNX.getForeign("ID_ADRESSE_F");
        }
        SQLRow rowCompteClient = clientRowNX.getForeignRow("ID_COMPTE_PCE");
        String numero = rowCompteClient.getString("NUMERO");
        map.put("ClientNumeroCompte", numero);
        map.put("ClientType", rowClient.getString("FORME_JURIDIQUE"));
        map.put("ClientNom", rowClient.getString("NOM"));
        map.put("ClientAdresse", rowAdresse.getString("RUE"));
        map.put("ClientCodePostal", rowAdresse.getString("CODE_POSTAL"));
        String villeCli = rowAdresse.getString("VILLE");
        Object cedexCli = rowAdresse.getObject("CEDEX");
        boolean hasCedexCli = rowAdresse.getBoolean("HAS_CEDEX");
        if (hasCedexCli) {
            villeCli = String.valueOf(villeCli) + " CEDEX";
            if (cedexCli != null && cedexCli.toString().trim().length() > 0) {
                villeCli = String.valueOf(villeCli) + " " + cedexCli.toString().trim();
            }
        }
        map.put("ClientVille", villeCli);
        Date d = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
        map.put("RelanceDate", dateFormat.format(d));
        SQLRow rowFacture = rowEch.getForeignRow("ID_SAISIE_VENTE_FACTURE");
        Long lTotal = (Long)rowFacture.getObject("T_TTC");
        Long lRestant = (Long)rowEch.getObject("MONTANT");
        Long lVerse = new Long(lTotal - lRestant);
        map.put("FactureNumero", rowFacture.getString("NUMERO"));
        map.put("FactureReference", rowFacture.getString("NOM"));
        map.put("FactureTotal", GestionDevise.currencyToString(lTotal, true));
        map.put("FactureRestant", GestionDevise.currencyToString(lRestant, true));
        map.put("FactureVerse", GestionDevise.currencyToString(lVerse, true));
        map.put("FactureDate", dateFormat.format((Date)rowFacture.getObject("DATE")));
        Date dFacture = (Date)rowFacture.getObject("DATE");
        SQLRow modeRegRow = rowFacture.getForeignRow("ID_MODE_REGLEMENT");
        Date dateEch = ModeDeReglementSQLElement.calculDate(modeRegRow.getInt("AJOURS"), modeRegRow.getInt("LENJOUR"), dFacture);
        map.put("FactureDateEcheance", dateFormat.format(dateEch));
        return map;
    }

    public String getObject(SQLRow rowEch) {
        SQLPreferences prefs = new SQLPreferences(rowEch.getTable().getDBRoot());
        String object = prefs.get(MailRelancePreferencePanel.MAIL_RELANCE_OBJET, this.getDefaultObject());
        String date = prefs.get(MailRelancePreferencePanel.MAIL_RELANCE_DATE_PATTERN, "dd/MM/yyyy");
        return this.fill(rowEch, date, object);
    }

    public String getValue(SQLRow rowEch) {
        SQLPreferences prefs = new SQLPreferences(rowEch.getTable().getDBRoot());
        String value = prefs.get(MailRelancePreferencePanel.MAIL_RELANCE, this.getDefaultValue());
        String date = prefs.get(MailRelancePreferencePanel.MAIL_RELANCE_DATE_PATTERN, "dd/MM/yyyy");
        return this.fill(rowEch, date, value);
    }

    private String fill(SQLRow rowEch, String datePattern, String string) {
        Map<String, String> map = this.getMapValues(rowEch, datePattern);
        String result = string;
        for (String key : map.keySet()) {
            result = result.replace("{" + key + "}", map.get(key));
        }
        return result;
    }
}

