/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.erp.model.FichePayeModel;

public class FichePayeRenderer
extends DefaultTableCellRenderer {
    private static final Color couleurBrut = new Color(225, 254, 207);
    private static final Color couleurCot = new Color(253, 243, 204);
    private static final Color couleurNet = new Color(206, 247, 255);
    private static final Color couleurComm = new Color(245, 245, 245);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!isSelected) {
            if (!((FichePayeModel)table.getModel()).containValueAt(row, column)) {
                this.setBackground(SwingUtilities.getRoot(table).getBackground());
            } else if (value != null && value.getClass() == String.class) {
                String source = ((FichePayeModel)table.getModel()).getSourceAt(row);
                if (source.equalsIgnoreCase("RUBRIQUE_COMM")) {
                    this.setBackground(couleurComm);
                }
                if (source.equalsIgnoreCase("RUBRIQUE_BRUT")) {
                    this.setBackground(couleurBrut);
                }
                if (source.equalsIgnoreCase("RUBRIQUE_COTISATION")) {
                    this.setBackground(couleurCot);
                }
                if (source.equalsIgnoreCase("RUBRIQUE_NET")) {
                    this.setBackground(couleurNet);
                }
            } else {
                this.setBackground(Color.WHITE);
            }
        }
        return this;
    }
}

