/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.sales.invoice.report.VenteFactureXmlSheet;
import org.openconcerto.erp.generationDoc.gestcomm.FicheRelanceSheet;
import org.openconcerto.erp.generationDoc.gestcomm.RelanceSheet;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumnPath;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.cc.ITransformer;

public class ListeDesRelancesAction
extends CreateFrameAbstractAction
implements MouseListener {
    private IListFrame frame;

    public ListeDesRelancesAction() {
        this.putValue("Name", "Liste des relances");
    }

    public JFrame createFrame() {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("RELANCE");
        this.frame = new IListFrame(new ListeAddPanel(elt){

            @Override
            protected void createUI() {
                super.createUI();
                this.btnMngr.setAdditional(this.buttonModifier, new ITransformer<JButton, String>(){

                    @Override
                    public String transformChecked(JButton input) {
                        SQLRow row = this.getListe().fetchSelectedRow();
                        if (((SQLRowAccessor)row).getForeign("ID_TYPE_LETTRE_RELANCE") == null || row.isForeignEmpty("ID_TYPE_LETTRE_RELANCE")) {
                            return "Vous ne pouvez pas modifier une relance envoy\u00e9e par mail!";
                        }
                        return null;
                    }
                });
            }
        });
        SQLTableModelSourceOnline src = (SQLTableModelSourceOnline)this.frame.getPanel().getListe().getModel().getReq();
        this.frame.getPanel().getListe().setSQLEditable(true);
        for (SQLTableModelColumn column : src.getColumns()) {
            if (!column.getClass().isAssignableFrom(SQLTableModelColumnPath.class)) continue;
            ((SQLTableModelColumnPath)column).setEditable(false);
        }
        ((SQLTableModelColumnPath)src.getColumns(elt.getTable().getField("INFOS")).iterator().next()).setEditable(true);
        this.frame.getPanel().getListe().getJTable().addMouseListener(this);
        this.frame.getPanel().setAddVisible(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.gridy = 4;
        IListFilterDatePanel datePanel = new IListFilterDatePanel(this.frame.getPanel().getListe(), elt.getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        ++c.gridy;
        c.anchor = 10;
        datePanel.setFilterOnDefault();
        this.frame.getPanel().add((Component)datePanel, c);
        return this.frame;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int selectedId = this.frame.getPanel().getListe().getSelectedId();
        if (selectedId > 1 && e.getButton() == 3) {
            final SQLRow rowRelance = this.frame.getPanel().getListe().fetchSelectedRow();
            boolean isNotMail = rowRelance.getForeign("ID_TYPE_LETTRE_RELANCE") != null && !rowRelance.isForeignEmpty("ID_TYPE_LETTRE_RELANCE");
            JPopupMenu menu = new JPopupMenu();
            final RelanceSheet s = new RelanceSheet(rowRelance);
            AbstractAction actionOpen = new AbstractAction("Voir le document"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    s.generate(false, false, "");
                    s.showDocument();
                }
            };
            actionOpen.setEnabled(isNotMail);
            menu.add(actionOpen);
            AbstractAction actionPrint = new AbstractAction("Imprimer"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    s.fastPrintDocument();
                }
            };
            actionPrint.setEnabled(isNotMail);
            menu.add(actionPrint);
            AbstractAction actionPrintFact = new AbstractAction("Imprimer la facture"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ListeDesRelancesAction.this.printInvoice(rowRelance);
                            }
                            catch (Exception e) {
                                ExceptionHandler.handle("Impression impossible", e);
                            }
                        }
                    });
                    t.start();
                }
            };
            actionPrintFact.setEnabled(isNotMail);
            menu.add(actionPrintFact);
            AbstractAction actionPrintBoth = new AbstractAction("Imprimer la facture et la relance"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                s.fastPrintDocument();
                                ListeDesRelancesAction.this.printInvoice(rowRelance);
                            }
                            catch (Exception e) {
                                ExceptionHandler.handle("Impression impossible", e);
                            }
                        }
                    });
                    t.start();
                }
            };
            actionPrintBoth.setEnabled(isNotMail);
            menu.add(actionPrintBoth);
            AbstractAction actionGenerate = new AbstractAction("G\u00e9n\u00e9rer"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String printer = PrinterNXProps.getInstance().getStringProperty("RelancePrinter");
                    s.generate(false, true, printer, true);
                }
            };
            actionGenerate.setEnabled(isNotMail);
            menu.add(actionGenerate);
            menu.add(new AbstractAction("Cr\u00e9er la fiche de relance"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        FicheRelanceSheet sheet = new FicheRelanceSheet(rowRelance);
                        sheet.createDocumentAsynchronous();
                        sheet.showPrintAndExportAsynchronous(true, false, true);
                    }
                    catch (Exception ex) {
                        ExceptionHandler.handle("Impression impossible", ex);
                    }
                }
            });
            menu.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void printInvoice(SQLRow rowRelance) throws Exception {
        VenteFactureXmlSheet sheet = new VenteFactureXmlSheet(rowRelance.getForeignRow("ID_SAISIE_VENTE_FACTURE"));
        sheet.getOrCreateDocumentFile();
        sheet.showPrintAndExport(false, true, true);
    }
}

