/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.DeviseCellEditor;
import org.openconcerto.erp.core.common.ui.MultiLineTableCellEditor;
import org.openconcerto.erp.core.common.ui.RowValuesMultiLineEditTable;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.ui.AnalytiqueItemTable;
import org.openconcerto.erp.core.finance.accounting.ui.CompteRowValuesRenderer;
import org.openconcerto.erp.core.finance.accounting.ui.DeviseKmRowValuesRenderer;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.list.AutoCompletionManager;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableControlPanel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.sql.view.list.TextTableCellEditorWithCompletion;
import org.openconcerto.sql.view.list.ValidStateChecker;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.checks.ValidState;

public class SaisieKmItemTable
extends JPanel
implements MouseListener {
    private final RowValuesTable table;
    private final SQLTableElement debit;
    private final SQLTableElement credit;
    private final SQLTableElement tableElementNumeroCompte;
    private final CompteRowValuesRenderer numeroCompteRenderer = new CompteRowValuesRenderer();
    private final DeviseKmRowValuesRenderer deviseRenderer = new DeviseKmRowValuesRenderer();
    private final DeviseCellEditor deviseCellEditor = new DeviseCellEditor();

    public SaisieKmItemTable(SQLRowValues defaultRowVals) {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("SAISIE_KM_ELEMENT");
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        SQLTable tableElement = elt.getTable();
        this.tableElementNumeroCompte = new SQLTableElement(tableElement.getField("NUMERO"));
        list.add(this.tableElementNumeroCompte);
        SQLTableElement tableElementNomCompte = new SQLTableElement(tableElement.getField("NOM"));
        list.add(tableElementNomCompte);
        if (tableElement.getTable().contains("NOM_PIECE")) {
            SQLTableElement tableElementNomPiece = new SQLTableElement(tableElement.getField("NOM_PIECE"));
            list.add(tableElementNomPiece);
        }
        SQLTableElement tableElementNomEcriture = new SQLTableElement(tableElement.getField("NOM_ECRITURE"));
        list.add(tableElementNomEcriture);
        this.debit = new SQLTableElement(tableElement.getField("DEBIT"), Long.class, this.deviseCellEditor);
        list.add(this.debit);
        this.credit = new SQLTableElement(tableElement.getField("CREDIT"), Long.class, this.deviseCellEditor);
        list.add(this.credit);
        if (!DefaultNXProps.getInstance().getBooleanValue("HideAnalytique").booleanValue()) {
            AnalytiqueItemTable analytiqueAssocTable = new AnalytiqueItemTable(true);
            SQLTableElement eltPourcentAnalytique = new SQLTableElement(tableElement.getField("ANALYTIQUE"), String.class, new MultiLineTableCellEditor((RowValuesMultiLineEditTable)analytiqueAssocTable.getTable(), analytiqueAssocTable));
            list.add(eltPourcentAnalytique);
        }
        RowValuesTableModel model = new RowValuesTableModel(elt, list, tableElement.getField("NUMERO"), false, defaultRowVals){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                super.setValueAt(aValue, rowIndex, columnIndex);
                int debitIndex = this.getColumnIndexForElement(SaisieKmItemTable.this.debit);
                int creditIndex = this.getColumnIndexForElement(SaisieKmItemTable.this.credit);
                if (debitIndex == columnIndex && (Long)aValue != 0L && (Long)this.getValueAt(rowIndex, creditIndex) != 0L) {
                    this.setValueAt(0L, rowIndex, creditIndex);
                } else if (creditIndex == columnIndex && (Long)aValue != 0L && (Long)this.getValueAt(rowIndex, debitIndex) != 0L) {
                    this.setValueAt(0L, rowIndex, debitIndex);
                }
            }
        };
        this.table = new RowValuesTable(model, null);
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        AutoCompletionManager m = new AutoCompletionManager(this.tableElementNumeroCompte, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("COMPTE_PCE.NUMERO"), this.table, this.table.getRowValuesTableModel(), 1, true, false, new ValidStateChecker(){
            ComptePCESQLElement elt = Configuration.getInstance().getDirectory().getElement(ComptePCESQLElement.class);

            @Override
            public ValidState getValidState(Object o) {
                if (o != null) {
                    return this.elt.getCompteNumeroValidState(o.toString());
                }
                return super.getValidState(o);
            }
        });
        m.fill("NOM", "NOM");
        m.setFillWithField("NUMERO");
        Where w = new Where((FieldRef)elt.getTable().getTable("COMPTE_PCE").getField("OBSOLETE"), "=", (Object)Boolean.FALSE);
        m.setWhere(w);
        AutoCompletionManager m2 = new AutoCompletionManager(tableElementNomCompte, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("COMPTE_PCE.NOM"), this.table, this.table.getRowValuesTableModel(), 2, true);
        m2.fill("NUMERO", "NUMERO");
        m2.setFillWithField("NOM");
        m2.setWhere(w);
        TextTableCellEditorWithCompletion t = (TextTableCellEditorWithCompletion)this.tableElementNumeroCompte.getTableCellEditor(this.table);
        this.add((Component)new RowValuesTableControlPanel(this.table), c);
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)new JScrollPane(this.table), c);
        this.tableElementNumeroCompte.setRenderer(this.numeroCompteRenderer);
        this.debit.setRenderer(this.deviseRenderer);
        this.credit.setRenderer(this.deviseRenderer);
        this.table.addMouseListener(this);
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 1) {
                    SaisieKmItemTable.this.editCellAt(e.getFirstRow(), 0);
                }
            }
        });
    }

    private void loadEcriture(SQLRow ecrRow, boolean contrePasser) {
        assert (SwingUtilities.isEventDispatchThread());
        SQLRow compteRow = ecrRow.getForeignRow("ID_COMPTE_PCE");
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("NUMERO", compteRow.getString("NUMERO"));
        m.put("NOM", compteRow.getString("NOM"));
        if (ecrRow.getTable().contains("NOM_PIECE")) {
            m.put("NOM_PIECE", ecrRow.getString("NOM_PIECE"));
        }
        if (contrePasser) {
            m.put("NOM_ECRITURE", "Contrepassation - " + ecrRow.getString("NOM"));
            m.put("DEBIT", ecrRow.getObject("CREDIT"));
            m.put("CREDIT", ecrRow.getObject("DEBIT"));
        } else {
            m.put("NOM_ECRITURE", ecrRow.getString("NOM"));
            m.put("DEBIT", ecrRow.getObject("DEBIT"));
            m.put("CREDIT", ecrRow.getObject("CREDIT"));
        }
        SQLRowValues rowVals = new SQLRowValues(this.getModel().getSQLElement().getTable(), m);
        this.table.getRowValuesTableModel().addRow(rowVals, false);
    }

    public void loadMouvement(int idMvt, boolean contrePasser) {
        assert (SwingUtilities.isEventDispatchThread());
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable ecrTable = base.getTable("ECRITURE");
        SQLSelect selEcriture = new SQLSelect();
        selEcriture.addSelectStar(ecrTable);
        Where w = new Where((FieldRef)ecrTable.getField("ID_MOUVEMENT"), "=", idMvt);
        selEcriture.setWhere(w);
        String reqEcriture = selEcriture.asString();
        List myListEcriture = (List)base.getDataSource().execute(reqEcriture, SQLRowListRSH.createFromSelect(selEcriture, ecrTable));
        this.table.getRowValuesTableModel().clearRows();
        for (SQLRow sqlRow : myListEcriture) {
            this.loadEcriture(sqlRow, contrePasser);
        }
        this.table.getRowValuesTableModel().fireTableDataChanged();
    }

    public void updateField(String field, int id) {
        this.table.updateField(field, id);
    }

    public void insertFrom(String field, int id) {
        this.table.insertFrom(field, id);
    }

    public void insertFrom(SQLRowAccessor row) {
        this.table.insertFrom(row);
    }

    public RowValuesTableModel getModel() {
        return this.table.getRowValuesTableModel();
    }

    public SQLTableElement getCreditElement() {
        return this.credit;
    }

    public SQLTableElement getDebitElement() {
        return this.debit;
    }

    public SQLTableElement getNumeroCompteElement() {
        return this.tableElementNumeroCompte;
    }

    public void setCreateAutoActive(boolean b) {
        this.numeroCompteRenderer.setCreateActive(b);
        this.table.revalidate();
        this.table.repaint();
    }

    public void setRowDeviseValidAt(boolean b, int index) {
        this.deviseRenderer.setValid(b, index);
    }

    public void editCellAt(int row, int column) {
        assert (SwingUtilities.isEventDispatchThread());
        this.table.setColumnSelectionInterval(column, column);
        this.table.setRowSelectionInterval(row, row);
        this.table.editCellAt(row, column);
    }

    private long getContrepartie() {
        assert (SwingUtilities.isEventDispatchThread());
        long totalCred = 0L;
        long totalDeb = 0L;
        RowValuesTableModel model = this.table.getRowValuesTableModel();
        int creditIndex = model.getColumnIndexForElement(this.getCreditElement());
        int debitIndex = model.getColumnIndexForElement(this.getDebitElement());
        int i = 0;
        while (i < this.table.getRowCount()) {
            if (model.isRowValid(i)) {
                Long fTd;
                Long fTc = (Long)model.getValueAt(i, creditIndex);
                if (fTc != null) {
                    totalCred += fTc.longValue();
                }
                if ((fTd = (Long)model.getValueAt(i, debitIndex)) != null) {
                    totalDeb += fTd.longValue();
                }
            }
            ++i;
        }
        return totalDeb - totalCred;
    }

    private long getSoldeRow(int index) {
        assert (SwingUtilities.isEventDispatchThread());
        if (index >= 0 && index < this.table.getRowCount()) {
            SQLRowValues rowVals = this.table.getRowValuesTableModel().getRowValuesAt(index);
            return rowVals.getLong("DEBIT") - rowVals.getLong("CREDIT");
        }
        return 0L;
    }

    public void fillEmptyEntryLabel(String previousText, String text) {
        assert (SwingUtilities.isEventDispatchThread());
        if (text == null) {
            return;
        }
        RowValuesTableModel model = this.table.getRowValuesTableModel();
        int size = model.getRowCount();
        int i = 0;
        while (i < size) {
            SQLRowValues r = model.getRowValuesAt(i);
            if (r.getString("NOM_ECRITURE") == null || r.getString("NOM_ECRITURE").trim().isEmpty() || r.getString("NOM_ECRITURE").trim().equals(previousText)) {
                r.put("NOM_ECRITURE", text);
            }
            ++i;
        }
        model.fireTableDataChanged();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        final int rowSel = this.table.getSelectedRow();
        if (e.getButton() == 3 && rowSel >= 0 && rowSel < this.table.getRowCount()) {
            JPopupMenu menuDroit = new JPopupMenu();
            menuDroit.add(new AbstractAction("Contrepartie"){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    long l = SaisieKmItemTable.this.getContrepartie();
                    if (SaisieKmItemTable.this.table.getRowValuesTableModel().isRowValid(rowSel)) {
                        l += SaisieKmItemTable.this.getSoldeRow(rowSel);
                    }
                    if (l > 0L) {
                        SaisieKmItemTable.this.table.getRowValuesTableModel().putValue(0L, rowSel, "DEBIT");
                        SaisieKmItemTable.this.table.getRowValuesTableModel().putValue(l, rowSel, "CREDIT");
                    } else {
                        SaisieKmItemTable.this.table.getRowValuesTableModel().putValue(0L, rowSel, "CREDIT");
                        SaisieKmItemTable.this.table.getRowValuesTableModel().putValue(-l, rowSel, "DEBIT");
                    }
                }
            });
            menuDroit.pack();
            menuDroit.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
            menuDroit.setVisible(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

