/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.accounting.model.PlanComptableEModel;
import org.openconcerto.erp.core.finance.accounting.ui.PlanComptableCellRenderer;
import org.openconcerto.erp.element.objet.ClasseCompte;
import org.openconcerto.erp.element.objet.Compte;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.TitledSeparator;

public class PlanComptableEPanel
extends JPanel {
    private Vector classeComptes = new Vector();
    private Vector tables = new Vector();
    private JTabbedPane tabbedClasse = new JTabbedPane();
    private JPanel panelInfosCompte = new JPanel();
    private JTextArea textInfos = new JTextArea();
    private Vector actionClickDroit;
    private EditFrame edit = null;
    private final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();

    public PlanComptableEPanel() {
        this.actionClickDroit = null;
        this.uiInit();
    }

    public PlanComptableEPanel(Vector actionClickDroit) {
        this.actionClickDroit = actionClickDroit;
        this.uiInit();
    }

    private void uiInit() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.panelInfosCompte.setLayout(new GridBagLayout());
        this.panelInfosCompte.setOpaque(false);
        List<ClasseCompte> liste = ClasseCompte.getClasseCompte();
        int k = 0;
        while (k < liste.size()) {
            ClasseCompte ccTmp = liste.get(k);
            this.classeComptes.add(ccTmp);
            JTable tab = this.creerJTable(ccTmp);
            this.tables.add(tab);
            this.tabbedClasse.add(ccTmp.getNom(), new JScrollPane(tab));
            ++k;
        }
        c.gridwidth = 1;
        c.gridheight = 6;
        c.gridwidth = 0;
        c.fill = 2;
        c.anchor = 18;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridy = 0;
        c.gridx = 0;
        TitledSeparator sep = new TitledSeparator("Informations sur le compte");
        this.panelInfosCompte.add((Component)sep, c);
        GridBagConstraints cInfos = new GridBagConstraints();
        cInfos.fill = 1;
        cInfos.anchor = 18;
        cInfos.gridx = 0;
        cInfos.gridy = 0;
        cInfos.gridwidth = 1;
        cInfos.gridheight = 1;
        cInfos.weightx = 1.0;
        cInfos.weighty = 0.0;
        this.textInfos.setFont(this.getFont());
        this.textInfos.setEditable(false);
        JPanel infos = new JPanel(new GridBagLayout());
        infos.add((Component)this.textInfos, cInfos);
        JScrollPane scrollInfos = new JScrollPane(this.textInfos);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.panelInfosCompte.add((Component)scrollInfos, c);
        this.panelInfosCompte.setMinimumSize(new Dimension(100, 80));
        JSplitPane split = new JSplitPane(0, this.tabbedClasse, this.panelInfosCompte);
        split.setBorder(null);
        this.add((Component)split, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.fill = 0;
        c.anchor = 13;
        JButton fermer = new JButton("Fermer");
        fermer.setHorizontalAlignment(4);
        this.add((Component)fermer, c);
        fermer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(PlanComptableEPanel.this)).dispose();
            }
        });
    }

    public JTable creerJTable(ClasseCompte ccTmp) {
        final PlanComptableEModel model = new PlanComptableEModel(ccTmp);
        final JTable table = new JTable(model);
        table.getColumnModel().getColumn(0).setCellRenderer(new PlanComptableCellRenderer(0));
        table.getColumnModel().getColumn(1).setCellRenderer(new PlanComptableCellRenderer(0));
        table.getColumnModel().getColumn(0).setMaxWidth(90);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = table.getSelectedRow();
                if (selectedRow < 0) {
                    PlanComptableEPanel.this.textInfos.setText("Pas de compte s\u00e9l\u00e9ctionn\u00e9");
                } else {
                    PlanComptableEPanel.this.textInfos.setText(model.getComptes().get(selectedRow).getInfos());
                }
            }
        });
        if (this.actionClickDroit != null) {
            System.out.println("Ajout menu droit");
            table.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 3) {
                        PlanComptableEPanel.this.actionDroitTable(e, table);
                    }
                }
            });
        }
        table.getTableHeader().setReorderingAllowed(false);
        return table;
    }

    private void actionDroitTable(final MouseEvent mE, final JTable table) {
        JPopupMenu menuDroit = new JPopupMenu();
        int i = 0;
        while (i < this.actionClickDroit.size()) {
            menuDroit.add((AbstractAction)this.actionClickDroit.get(i));
            ++i;
        }
        menuDroit.add(new AbstractAction("Tout s\u00e9lectionner"){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.selectAll();
            }
        });
        menuDroit.add(new AbstractAction("Modifier le compte"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = table.rowAtPoint(mE.getPoint());
                if (PlanComptableEPanel.this.edit == null) {
                    SQLElement compteElt = Configuration.getInstance().getDirectory().getElement("COMPTE_PCE");
                    PlanComptableEPanel.this.edit = new EditFrame(compteElt, EditPanel.MODIFICATION);
                }
                PlanComptableEPanel.this.edit.selectionId(((PlanComptableEModel)table.getModel()).getId(row), -1);
                PlanComptableEPanel.this.edit.pack();
                PlanComptableEPanel.this.edit.setVisible(true);
            }
        });
        menuDroit.add(new AbstractAction("Consulter le compte"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = table.rowAtPoint(mE.getPoint());
                SQLRow rowCompte = PlanComptableEPanel.this.base.getTable("COMPTE_PCE").getRow(((PlanComptableEModel)table.getModel()).getId(row));
                ((EcritureSQLElement)ComptaPropsConfiguration.getInstanceCompta().getDirectory().getElement("ECRITURE")).consultationCompte(rowCompte);
            }
        });
        menuDroit.show(mE.getComponent(), mE.getX(), mE.getY());
    }

    public void fireModificationCompte(Compte cpt) {
        int i = 0;
        while (i < this.classeComptes.size()) {
            ClasseCompte classeTmp = (ClasseCompte)this.classeComptes.get(i);
            if (cpt.getNumero().trim().matches(classeTmp.getTypeNumeroCompte().trim())) {
                JTable tab = this.creerJTable(classeTmp);
                this.tables.set(i, tab);
                this.tabbedClasse.setComponentAt(i, new JScrollPane(tab));
            }
            ++i;
        }
    }

    public int getSelectedIndex() {
        return this.tabbedClasse.getSelectedIndex();
    }

    public Vector getTables() {
        return this.tables;
    }
}

