/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.report;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.report.GrandLivreSheet;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.cc.ITransformer;

public class GrandLivreSheetXML
extends AbstractListeSheetXml {
    private static int debutFill;
    private static int endFill;
    private static final SQLTable tableEcriture;
    private static final SQLTable tableJournal;
    private static final SQLTable tableMvt;
    private static final SQLTable tableCompte;
    private final DateFormat dateFormat = DateFormat.getDateInstance(2);
    private final DateFormat dateFormatEcr = DateFormat.getDateInstance(3);
    private SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
    private Date dateDu;
    private Date dateAu;
    private String compteDeb;
    private String compteEnd;
    private int lettrage;
    private boolean cumul = false;
    private boolean excludeCompteSolde = true;
    private boolean centralClient = false;
    private boolean centralFourn = false;
    int idJrnlExclude = -1;
    public static String TEMPLATE_ID;
    public static String TEMPLATE_PROPERTY_NAME;
    Date date;
    private String toDay = this.dateFormat.format(new Date());
    private int size;
    private List<Map<String, Object>> recapSousTotaux = new ArrayList<Map<String, Object>>();

    static {
        tableEcriture = base.getTable("ECRITURE");
        tableJournal = base.getTable("JOURNAL");
        tableMvt = base.getTable("MOUVEMENT");
        tableCompte = base.getTable("COMPTE_PCE");
        TEMPLATE_ID = "GrandLivre";
        TEMPLATE_PROPERTY_NAME = "LocationGrandLivre";
    }

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    public String getName() {
        if (this.date == null) {
            this.date = new Date();
        }
        return "GrandLivre" + this.date.getTime();
    }

    @Override
    protected String getStoragePathP() {
        return "Grand Livre";
    }

    public GrandLivreSheetXML(Date du, Date au, String compteDep, String compteEnd, int lettrage, boolean cumul, boolean excludeCptSolde, boolean centralClient, boolean centralFourn, int idJrnlExclude) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(au);
        this.idJrnlExclude = idJrnlExclude;
        this.printer = PrinterNXProps.getInstance().getStringProperty("GrandLivrePrinter");
        this.dateAu = au;
        this.dateDu = du;
        this.compteDeb = compteDep.trim();
        this.compteEnd = compteEnd.trim();
        this.lettrage = lettrage;
        this.cumul = cumul;
        this.excludeCompteSolde = excludeCptSolde;
        this.centralClient = centralClient;
        this.centralFourn = centralFourn;
        HashMap<String, String> map = new HashMap<String, String>();
        this.recapSousTotaux.add(map);
        map.put("DATE", "R\u00e9capitulatif");
    }

    private void makeSousTotal(String numCpt, String nomCpt, Map<String, Object> line, Map<Integer, String> style, int pos, long debit, long credit) {
        style.put(pos, "Titre 1");
        line.put("DATE", "");
        line.put("JOURNAL", "");
        line.put("MOUVEMENT", "");
        line.put("LIBELLE", "Sous total");
        line.put("DEBIT", Double.valueOf(GestionDevise.currencyToString(debit, false)));
        line.put("CREDIT", Double.valueOf(GestionDevise.currencyToString(credit, false)));
        line.put("SOLDE", Double.valueOf(GestionDevise.currencyToString(debit - credit, false)));
        HashMap<String, Object> lineRecap = new HashMap<String, Object>();
        lineRecap.putAll(line);
        lineRecap.put("DATE", numCpt);
        lineRecap.put("JOURNAL", nomCpt);
        lineRecap.put("LIBELLE", "");
        this.recapSousTotaux.add(lineRecap);
    }

    @Override
    protected void createListeValues() {
        Date d = new Date();
        SQLRowValues vals = new SQLRowValues(tableEcriture);
        vals.put("ID_COMPTE_PCE", null);
        vals.put("COMPTE_NUMERO", null);
        vals.put("COMPTE_NOM", null);
        if (tableEcriture.contains("NOM_PIECE")) {
            vals.put("NOM_PIECE", null);
        }
        vals.put("ID_JOURNAL", null);
        vals.put("JOURNAL_CODE", null);
        vals.putRowValues("ID_MOUVEMENT").put("NUMERO", null).putRowValues("ID_PIECE").put("NOM", null);
        vals.put("CREDIT", null);
        vals.put("DEBIT", null);
        vals.put("DATE", null);
        vals.put("NOM", null);
        vals.put("LETTRAGE", null);
        vals.put("POINTEE", null);
        vals.put("DATE_LETTRAGE", null);
        vals.put("DATE_POINTEE", null);
        final List<Integer> lCompteSolde = this.excludeCompteSolde ? this.getListeCompteSolde() : null;
        Map<Integer, Long> mapCumul = this.getCumulsAnterieur(this.dateDu, lCompteSolde);
        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(vals);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect sel) {
                Where w = new Where((FieldRef)tableEcriture.getField("DATE"), GrandLivreSheetXML.this.dateDu, (Object)GrandLivreSheetXML.this.dateAu);
                w = GrandLivreSheetXML.this.compteDeb.equals(GrandLivreSheetXML.this.compteEnd) ? w.and(new Where((FieldRef)tableEcriture.getField("COMPTE_NUMERO"), "=", (Object)GrandLivreSheetXML.this.compteDeb)) : w.and(new Where((FieldRef)tableEcriture.getField("COMPTE_NUMERO"), (Object)GrandLivreSheetXML.this.compteDeb, (Object)GrandLivreSheetXML.this.compteEnd));
                w = w.and(new Where((FieldRef)tableEcriture.getField("ID_JOURNAL"), "!=", GrandLivreSheetXML.this.idJrnlExclude));
                w = w.and(new Where((FieldRef)tableEcriture.getField("ID_MOUVEMENT"), "=", tableMvt.getField("ID")));
                if (GrandLivreSheetXML.this.lettrage == GrandLivreSheet.MODELETTREE) {
                    Object o = null;
                    w = w.and(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "<>", (Object)o));
                    w = w.and(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "!=", (Object)""));
                    w = w.and(new Where((FieldRef)tableEcriture.getField("DATE_LETTRAGE"), "<=", (Object)GrandLivreSheetXML.this.dateAu));
                } else if (GrandLivreSheetXML.this.lettrage == GrandLivreSheet.MODENONLETTREE_PERIODE) {
                    Object o = null;
                    Where w2 = new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "=", (Object)o);
                    Where wSTTC = new Where((FieldRef)tableEcriture.getField("DATE_LETTRAGE"), "<>", (Object)o);
                    wSTTC = wSTTC.and(new Where((FieldRef)tableEcriture.getField("DATE_LETTRAGE"), ">", (Object)GrandLivreSheetXML.this.dateAu));
                    w2 = w2.or(wSTTC);
                    w = w.and(w2.or(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "=", (Object)"")));
                } else if (GrandLivreSheetXML.this.lettrage == GrandLivreSheet.MODENONLETTREE_ALL) {
                    Object o = null;
                    Where w2 = new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "=", (Object)o);
                    w = w.and(w2.or(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "=", (Object)"")));
                }
                if (GrandLivreSheetXML.this.excludeCompteSolde) {
                    System.err.println("Exclude compte");
                    w = w.and(new Where(tableEcriture.getField("ID_COMPTE_PCE"), lCompteSolde).not());
                }
                w = w.and(new Where((FieldRef)tableEcriture.getField("NOM"), "NOT LIKE", (Object)"Fermeture du compte%"));
                if (!UserRightsManager.getCurrentUserRights().haveRight(ComptaUserRight.ACCES_NOT_RESCTRICTED_TO_411)) {
                    w = w.and(new Where((FieldRef)tableEcriture.getField("COMPTE_NUMERO"), "LIKE", (Object)"411%"));
                }
                sel.setWhere(w);
                sel.addFieldOrder(tableEcriture.getField("COMPTE_NUMERO"));
                sel.addFieldOrder(tableEcriture.getField("DATE"));
                sel.addFieldOrder(tableMvt.getField("NUMERO"));
                System.err.println(sel.asString());
                return sel;
            }
        });
        List<SQLRowValues> list = fetcher.fetch();
        this.size = list.size();
        System.err.println("START CREATE Grand livre, NB ecritures  " + this.size);
        long totalDebit = 0L;
        long totalCredit = 0L;
        long sousTotalCredit = 0L;
        long sousTotalDebit = 0L;
        long totalCreditAntC = 0L;
        long totalDebitAntC = 0L;
        long totalCreditAntF = 0L;
        long totalDebitAntF = 0L;
        SQLRowValues rowFirstEcr = null;
        int idCptFirstEcr = 1;
        boolean setTitle = true;
        boolean setLine = false;
        boolean setCumuls = true;
        boolean firstEcrCentC = true;
        boolean firstEcrCentF = true;
        String numCptFirstEcr = "411";
        String numCptClient = "411";
        String nomCptClient = "Clients";
        String numCptFourn = "401";
        String nomCptFourn = "Fournisseurs";
        int idCptClient = ComptePCESQLElement.getId(numCptClient, nomCptClient);
        int idCptFourn = ComptePCESQLElement.getId(numCptFourn, nomCptFourn);
        String titre3 = "Titre 3";
        String cumulAntString = "Cumuls ant\u00e9rieurs";
        ArrayList<Map<Object, Object>> tableauVals = new ArrayList<Map<Object, Object>>();
        this.listAllSheetValues.put(0, tableauVals);
        HashMap<Integer, String> style = new HashMap<Integer, String>();
        this.styleAllSheetValues.put(0, style);
        setTitle = true;
        setLine = false;
        String nomCpt = "";
        String numCpt = "";
        int i = 0;
        while (i < this.size) {
            long solde;
            Double doubleZero = Double.valueOf("0");
            SQLRowValues rowEcr = list.get(i);
            int idCpt = rowEcr.getInt("ID_COMPTE_PCE");
            nomCpt = rowEcr.getString("COMPTE_NOM");
            numCpt = rowEcr.getString("COMPTE_NUMERO");
            HashMap<String, Object> ooLine = new HashMap<String, Object>();
            tableauVals.add(ooLine);
            if (setCumuls && this.cumul && !setTitle) {
                style.put(tableauVals.size(), "Titre 3");
                ooLine.put("DATE", "");
                ooLine.put("JOURNAL", "");
                ooLine.put("MOUVEMENT", "");
                ooLine.put("LIBELLE", "Cumuls ant\u00e9rieurs");
                Long longSolde = mapCumul.get(idCpt);
                if (longSolde == null) {
                    longSolde = 0L;
                }
                long debitCumulAnt = 0L;
                long creditCumulAnt = 0L;
                if (longSolde > 0L) {
                    debitCumulAnt = longSolde;
                } else {
                    creditCumulAnt = -longSolde.longValue();
                }
                ooLine.put("DEBIT", debitCumulAnt == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(debitCumulAnt, false)));
                ooLine.put("CREDIT", creditCumulAnt == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(creditCumulAnt, false)));
                ooLine.put("SOLDE", longSolde == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(longSolde, false)));
                totalCredit += creditCumulAnt;
                totalDebit += debitCumulAnt;
                sousTotalCredit += creditCumulAnt;
                sousTotalDebit += debitCumulAnt;
                setCumuls = false;
                continue;
            }
            if (setTitle) {
                if (!setLine) {
                    style.put(tableauVals.size() - 1, "Titre 1");
                    if (this.centralClient && nomCpt.startsWith("411")) {
                        nomCpt = nomCptClient;
                        numCpt = numCptClient;
                        idCpt = idCptClient;
                    }
                    if (this.centralFourn && nomCpt.startsWith("401")) {
                        nomCpt = nomCptFourn;
                        numCpt = numCptFourn;
                        idCpt = idCptFourn;
                    }
                    ooLine.put("DATE", numCpt);
                    ooLine.put("JOURNAL", nomCpt);
                    ooLine.put("MOUVEMENT", "");
                    ooLine.put("LIBELLE", "");
                    ooLine.put("DEBIT", "");
                    ooLine.put("CREDIT", "");
                    ooLine.put("SOLDE", "");
                    setTitle = false;
                    setLine = true;
                    if (rowFirstEcr != null) continue;
                    rowFirstEcr = rowEcr;
                    idCptFirstEcr = rowEcr.getInt("ID_COMPTE_PCE");
                    numCptFirstEcr = rowEcr.getString("COMPTE_NUMERO");
                    continue;
                }
                style.put(tableauVals.size() - 1, "Normal");
                setLine = false;
                continue;
            }
            if (!(rowFirstEcr == null || idCptFirstEcr == idCpt || this.centralFourn && numCptFirstEcr.startsWith("401") && numCpt.startsWith("401") || this.centralClient && numCptFirstEcr.startsWith("411") && numCpt.startsWith("411"))) {
                rowFirstEcr = rowEcr;
                idCptFirstEcr = rowFirstEcr.getInt("ID_COMPTE_PCE");
                numCptFirstEcr = rowEcr.getString("COMPTE_NUMERO");
                this.makeSousTotal(numCpt, nomCpt, ooLine, style, tableauVals.size() - 1, sousTotalDebit, sousTotalCredit);
                sousTotalCredit = 0L;
                sousTotalDebit = 0L;
                setTitle = true;
                setCumuls = true;
                continue;
            }
            long cred = rowEcr.getLong("CREDIT");
            long deb = rowEcr.getLong("DEBIT");
            if (this.centralFourn && numCpt.startsWith("401")) {
                ++i;
                if (firstEcrCentF) {
                    ooLine.put("LIBELLE", "Centralisation des comptes fournisseurs");
                    style.put(tableauVals.size() - 1, "Normal");
                    firstEcrCentF = false;
                }
                sousTotalCredit += cred;
                sousTotalDebit += deb;
                solde = (totalDebitAntF += deb) - (totalCreditAntF += cred);
                ooLine.put("DEBIT", totalDebitAntF == 0L ? doubleZero : new Double(GestionDevise.currencyToString(totalDebitAntF, false)));
                ooLine.put("CREDIT", totalCreditAntF == 0L ? doubleZero : new Double(GestionDevise.currencyToString(totalCreditAntF, false)));
                ooLine.put("SOLDE", solde == 0L ? doubleZero : new Double(GestionDevise.currencyToString(solde, false)));
                continue;
            }
            if (this.centralClient && numCpt.startsWith("411")) {
                ++i;
                if (firstEcrCentC) {
                    ooLine.put("LIBELLE", "Centralisation des comptes clients");
                    style.put(tableauVals.size() - 1, "Normal");
                    firstEcrCentC = false;
                }
                sousTotalCredit += cred;
                sousTotalDebit += deb;
                solde = (totalDebitAntC += deb) - (totalCreditAntC += cred);
                ooLine.put("DEBIT", totalDebitAntC == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(totalDebitAntC, false)));
                ooLine.put("CREDIT", totalCreditAntC == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(totalCreditAntC, false)));
                ooLine.put("SOLDE", solde == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(solde, false)));
                continue;
            }
            ooLine.put("DATE", this.dateFormatEcr.format((Date)rowEcr.getObject("DATE")));
            ooLine.put("JOURNAL", rowEcr.getString("JOURNAL_CODE"));
            ooLine.put("MOUVEMENT", rowEcr.getForeign("ID_MOUVEMENT").getObject("NUMERO"));
            ooLine.put("PIECE", rowEcr.getForeign("ID_MOUVEMENT").getForeign("ID_PIECE").getObject("NOM"));
            ooLine.put("LIBELLE", rowEcr.getObject("NOM"));
            ooLine.put("CODE_LETTRAGE", rowEcr.getObject("LETTRAGE"));
            ooLine.put("CODE_POINTAGE", rowEcr.getObject("POINTEE"));
            ooLine.put("DATE_LETTRAGE", rowEcr.getObject("DATE_LETTRAGE"));
            ooLine.put("DATE_POINTAGE", rowEcr.getObject("DATE_LETTRAGE"));
            if (tableEcriture.contains("NOM_PIECE")) {
                ooLine.put("NOM_PIECE", rowEcr.getObject("NOM_PIECE"));
            }
            totalCredit += cred;
            totalDebit += deb;
            solde = (sousTotalDebit += deb) - (sousTotalCredit += cred);
            ooLine.put("DEBIT", deb == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(deb, false)));
            ooLine.put("CREDIT", cred == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(cred, false)));
            ooLine.put("SOLDE", solde == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(solde, false)));
            style.put(tableauVals.size() - 1, "Normal");
            ++i;
        }
        HashMap<String, Object> sheetVals = new HashMap<String, Object>();
        this.mapAllSheetValues.put(0, sheetVals);
        if (this.size > 0) {
            HashMap<String, Object> ooLine = new HashMap<String, Object>();
            tableauVals.add(ooLine);
            this.makeSousTotal(numCpt, nomCpt, ooLine, style, tableauVals.size() - 1, sousTotalDebit, sousTotalCredit);
            sheetVals.put("TOTAL_DEBIT", totalDebit == 0L ? 0.0 : new Double(GestionDevise.currencyToString(totalDebit, false)));
            sheetVals.put("TOTAL_CREDIT", totalCredit == 0L ? 0.0 : new Double(GestionDevise.currencyToString(totalCredit, false)));
            sheetVals.put("TOTAL_SOLDE", totalDebit - totalCredit == 0L ? 0.0 : new Double(GestionDevise.currencyToString(totalDebit - totalCredit, false)));
            HashMap emptyLine = new HashMap();
            style.put(tableauVals.size(), "Normal");
            tableauVals.add(emptyLine);
            for (Map<String, Object> recap : this.recapSousTotaux) {
                style.put(tableauVals.size(), "Titre 1");
                tableauVals.add(recap);
            }
            HashMap<String, Object> lineRecap = new HashMap<String, Object>();
            lineRecap.put("DEBIT", totalDebit == 0L ? 0.0 : new Double(GestionDevise.currencyToString(totalDebit, false)));
            lineRecap.put("CREDIT", totalCredit == 0L ? 0.0 : new Double(GestionDevise.currencyToString(totalCredit, false)));
            lineRecap.put("SOLDE", totalDebit - totalCredit == 0L ? 0.0 : new Double(GestionDevise.currencyToString(totalDebit - totalCredit, false)));
            lineRecap.put("DATE", "");
            lineRecap.put("JOURNAL", "");
            lineRecap.put("LIBELLE", "Global");
            style.put(tableauVals.size(), "Titre 1");
            tableauVals.add(lineRecap);
        }
        sheetVals.put("TITRE_1", "GRAND LIVRE " + this.rowSociete.getString("TYPE") + " " + this.rowSociete.getString("NOM"));
        sheetVals.put("DATE_EDITION", new Date());
        sheetVals.put("TITRE_2", "Compte : " + this.compteDeb + " \u00e0 " + this.compteEnd + ". P\u00e9riode du " + this.dateFormatEcr.format(this.dateDu) + " au " + this.dateFormatEcr.format(this.dateAu) + ".");
        Date end = new Date();
        System.err.println("///////// TAKE " + (end.getTime() - d.getTime()) + " millisecondes TO CREATE MAP");
    }

    private List<Integer> getListeCompteSolde() {
        Where w2;
        Object o;
        SQLSelect sel = new SQLSelect(base);
        sel.addSelect(tableCompte.getField("ID"));
        sel.addSelect(tableEcriture.getField("DEBIT"), "SUM");
        sel.addSelect(tableEcriture.getField("CREDIT"), "SUM");
        Where w = this.compteDeb.equals(this.compteEnd) ? new Where((FieldRef)tableCompte.getField("NUMERO"), "=", (Object)this.compteDeb) : new Where((FieldRef)tableCompte.getField("NUMERO"), (Object)this.compteDeb, (Object)this.compteEnd);
        w = w.and(new Where((FieldRef)tableEcriture.getField("ID_COMPTE_PCE"), "=", tableCompte.getField("ID")));
        w = this.cumul ? w.and(new Where((FieldRef)tableEcriture.getField("DATE"), "<=", (Object)this.dateAu)) : w.and(new Where((FieldRef)tableEcriture.getField("DATE"), this.dateDu, (Object)this.dateAu));
        w = w.and(new Where((FieldRef)tableEcriture.getField("ID_JOURNAL"), "!=", this.idJrnlExclude));
        if (this.lettrage == GrandLivreSheet.MODELETTREE) {
            o = null;
            w = w.and(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "<>", (Object)o));
            w = w.and(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "!=", (Object)""));
        } else if (this.lettrage == GrandLivreSheet.MODENONLETTREE_ALL) {
            o = null;
            w2 = new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "=", (Object)o);
            w = w.and(w2.or(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "=", (Object)"")));
        } else if (this.lettrage == GrandLivreSheet.MODENONLETTREE_PERIODE) {
            o = null;
            w2 = new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "=", (Object)o);
            w = w.and(w2.or(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "=", (Object)"")));
        }
        sel.setWhere(w);
        String req = String.valueOf(sel.asString()) + " GROUP BY \"COMPTE_PCE\".\"ID\"";
        System.err.println(req);
        List l = (List)base.getDataSource().execute(req, new ArrayListHandler());
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Object[] o2 : l) {
            long credit = 0L;
            if (o2[2] != null) {
                credit = Long.valueOf(o2[2].toString());
            }
            long debit = 0L;
            if (o2[1] != null) {
                debit = Long.valueOf(o2[1].toString());
            }
            int id = Integer.valueOf(o2[0].toString());
            long solde = debit - credit;
            if (solde != 0L) continue;
            list.add(id);
        }
        return list;
    }

    private Map<Integer, Long> getCumulsAnterieur(Date d, List<Integer> listCompteSolde) {
        Object o;
        SQLSelect sel = new SQLSelect(base);
        sel.addSelect(tableEcriture.getField("ID_COMPTE_PCE"));
        sel.addSelect(tableEcriture.getField("DEBIT"), "SUM");
        sel.addSelect(tableEcriture.getField("CREDIT"), "SUM");
        sel.addSelect(tableEcriture.getField("COMPTE_NUMERO"));
        Where w = new Where((FieldRef)tableEcriture.getField("DATE"), "<", (Object)d);
        w = w.and(new Where((FieldRef)tableEcriture.getField("ID_MOUVEMENT"), "=", tableMvt.getKey()));
        w = this.compteDeb.equals(this.compteEnd) ? w.and(new Where((FieldRef)tableEcriture.getField("COMPTE_NUMERO"), "=", (Object)this.compteDeb)) : w.and(new Where((FieldRef)tableEcriture.getField("COMPTE_NUMERO"), (Object)this.compteDeb, (Object)this.compteEnd));
        if (this.lettrage == GrandLivreSheet.MODELETTREE) {
            o = null;
            w = w.and(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "<>", (Object)o));
            w = w.and(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "!=", (Object)""));
        } else if (this.lettrage == GrandLivreSheet.MODENONLETTREE_ALL || this.lettrage == GrandLivreSheet.MODENONLETTREE_PERIODE) {
            o = null;
            Where w2 = new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "=", (Object)o);
            w = w.and(w2.or(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "=", (Object)"")));
        }
        w = w.and(new Where((FieldRef)tableEcriture.getField("ID_COMPTE_PCE"), "=", tableCompte.getField("ID")));
        w = w.and(new Where((FieldRef)tableEcriture.getField("ID_JOURNAL"), "!=", this.idJrnlExclude));
        if (listCompteSolde != null) {
            w = w.and(new Where(tableEcriture.getField("ID_COMPTE_PCE"), listCompteSolde).not());
        }
        sel.setWhere(w);
        String req = String.valueOf(sel.asString()) + " GROUP BY \"ECRITURE\".\"ID_COMPTE_PCE\", \"ECRITURE\".\"COMPTE_NUMERO\"";
        System.err.println(req);
        List l = (List)base.getDataSource().execute(req, new ArrayListHandler());
        HashMap<Integer, Long> map = new HashMap<Integer, Long>();
        int idCptFourn = ComptePCESQLElement.getId("401", "Fournisseurs");
        int idCptClient = ComptePCESQLElement.getId("411", "Clients");
        for (Object[] o2 : l) {
            Long lS;
            long credit = 0L;
            if (o2[2] != null) {
                credit = Long.valueOf(o2[2].toString());
            }
            long debit = 0L;
            if (o2[1] != null) {
                debit = Long.valueOf(o2[1].toString());
            }
            int id = Integer.valueOf(o2[0].toString());
            long solde = debit - credit;
            map.put(id, solde);
            if (o2[3] == null) continue;
            String numero = o2[3].toString();
            if (this.centralFourn && numero.startsWith("401")) {
                lS = (Long)map.get(idCptFourn);
                lS = lS != null ? Long.valueOf(lS + solde) : new Long(solde);
                map.put(idCptFourn, lS);
            }
            if (!this.centralClient || !numero.startsWith("411")) continue;
            lS = (Long)map.get(idCptClient);
            lS = lS != null ? Long.valueOf(lS + solde) : new Long(solde);
            map.put(idCptClient, lS);
        }
        return map;
    }

    @Override
    public String getTemplateId() {
        return TEMPLATE_ID;
    }

    public int getSize() {
        return this.size;
    }
}

