/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.model;

import java.util.List;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class PointageModel
extends AbstractTableModel {
    private String[] titresCol;
    private String[] titresRow;
    private long debitPointe = 0L;
    private long creditPointe = 0L;
    private long debitNonPointe = 0L;
    private long creditNonPointe = 0L;
    private long creditSelection = 0L;
    private long debitSelection = 0L;
    private static final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    private static final SQLTable tableEcr = base.getTable("ECRITURE");
    int idCpt;

    public PointageModel(int idCpt) {
        this.idCpt = idCpt;
        this.titresCol = new String[6];
        this.titresCol[0] = "Totaux";
        this.titresCol[1] = "Point\u00e9";
        this.titresCol[2] = "Non Point\u00e9";
        this.titresCol[3] = "Total";
        this.titresCol[4] = "S\u00e9lection";
        this.titresCol[5] = "Point\u00e9\u00e9 + s\u00e9lection";
        this.titresRow = new String[3];
        this.titresRow[0] = "D\u00e9bit";
        this.titresRow[1] = "Cr\u00e9dit";
        this.titresRow[2] = "Solde";
        this.updateTotauxCompte();
    }

    public void setIdCompte(int id) {
        this.idCpt = id;
        this.updateTotauxCompte();
        this.updateSelection(null);
    }

    public void updateSelection(int[] rowIndex) {
        System.err.println("Update Selection");
        this.creditSelection = 0L;
        this.debitSelection = 0L;
        if (rowIndex != null) {
            int i = 0;
            while (i < rowIndex.length) {
                SQLRow row = tableEcr.getRow(rowIndex[i]);
                if (row != null) {
                    this.debitSelection += ((Long)row.getObject("DEBIT")).longValue();
                    this.creditSelection += ((Long)row.getObject("CREDIT")).longValue();
                }
                ++i;
            }
        }
        this.fireTableDataChanged();
    }

    public void updateTotauxCompte() {
        new SwingWorker<String, Object>(){

            @Override
            protected String doInBackground() throws Exception {
                SQLSelect sel = new SQLSelect(base);
                sel.addSelect(tableEcr.getField("CREDIT"), "SUM");
                sel.addSelect(tableEcr.getField("DEBIT"), "SUM");
                Where w = new Where((FieldRef)tableEcr.getField("ID_COMPTE_PCE"), "=", PointageModel.this.idCpt);
                sel.setWhere(w.and(new Where((FieldRef)tableEcr.getField("POINTEE"), "!=", (Object)"")));
                String reqPointee = sel.toString();
                Object obPointee = base.getDataSource().execute(reqPointee, new ArrayListHandler());
                List myListPointee = (List)obPointee;
                PointageModel.this.creditPointe = 0L;
                PointageModel.this.debitPointe = 0L;
                if (myListPointee.size() != 0) {
                    int i = 0;
                    while (i < myListPointee.size()) {
                        Object[] objTmp = (Object[])myListPointee.get(i);
                        if (objTmp[0] != null) {
                            PointageModel pointageModel = PointageModel.this;
                            pointageModel.creditPointe = pointageModel.creditPointe + ((Number)objTmp[0]).longValue();
                        }
                        if (objTmp[1] != null) {
                            PointageModel pointageModel = PointageModel.this;
                            pointageModel.debitPointe = pointageModel.debitPointe + ((Number)objTmp[1]).longValue();
                        }
                        ++i;
                    }
                }
                sel.setWhere(w.and(new Where((FieldRef)tableEcr.getField("POINTEE"), "=", (Object)"")));
                String reqNotPointee = sel.toString();
                Object obNotPointee = base.getDataSource().execute(reqNotPointee, new ArrayListHandler());
                List myListNotPointee = (List)obNotPointee;
                PointageModel.this.creditNonPointe = 0L;
                PointageModel.this.debitNonPointe = 0L;
                if (myListNotPointee.size() != 0) {
                    int i = 0;
                    while (i < myListNotPointee.size()) {
                        Object[] objTmp = (Object[])myListNotPointee.get(i);
                        if (objTmp[0] != null) {
                            PointageModel pointageModel = PointageModel.this;
                            pointageModel.creditNonPointe = pointageModel.creditNonPointe + ((Number)objTmp[0]).longValue();
                        }
                        if (objTmp[1] != null) {
                            PointageModel pointageModel = PointageModel.this;
                            pointageModel.debitNonPointe = pointageModel.debitNonPointe + ((Number)objTmp[1]).longValue();
                        }
                        ++i;
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                PointageModel.this.fireTableDataChanged();
            }
        }.execute();
    }

    @Override
    public String getColumnName(int column) {
        return this.titresCol[column];
    }

    @Override
    public int getColumnCount() {
        return this.titresCol.length;
    }

    @Override
    public int getRowCount() {
        return this.titresRow.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        return Long.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.titresRow[rowIndex];
        }
        if (columnIndex == 1) {
            if (rowIndex == 0) {
                return new Long(this.debitPointe);
            }
            if (rowIndex == 1) {
                return new Long(this.creditPointe);
            }
            if (rowIndex == 2) {
                return new Long(this.debitPointe - this.creditPointe);
            }
        }
        if (columnIndex == 2) {
            if (rowIndex == 0) {
                return new Long(this.debitNonPointe);
            }
            if (rowIndex == 1) {
                return new Long(this.creditNonPointe);
            }
            if (rowIndex == 2) {
                return new Long(this.debitNonPointe - this.creditNonPointe);
            }
        }
        if (columnIndex == 3) {
            if (rowIndex == 0) {
                return new Long(this.debitNonPointe + this.debitPointe);
            }
            if (rowIndex == 1) {
                return new Long(this.creditNonPointe + this.creditPointe);
            }
            if (rowIndex == 2) {
                return new Long(this.debitNonPointe - this.creditNonPointe + (this.debitPointe - this.creditPointe));
            }
        }
        if (columnIndex == 4) {
            if (rowIndex == 0) {
                return new Long(this.debitSelection);
            }
            if (rowIndex == 1) {
                return new Long(this.creditSelection);
            }
            if (rowIndex == 2) {
                return new Long(this.debitSelection - this.creditSelection);
            }
        }
        if (columnIndex == 5) {
            if (rowIndex == 0) {
                return new Long(this.debitSelection + this.debitPointe);
            }
            if (rowIndex == 1) {
                return new Long(this.creditSelection + this.creditPointe);
            }
            if (rowIndex == 2) {
                return new Long(this.debitSelection - this.creditSelection + this.debitPointe - this.creditPointe);
            }
        }
        return null;
    }
}

