/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.generationDoc.gestcomm.RelanceSheet;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.utils.ExceptionHandler;

public class RelanceSQLElement
extends ComptaSQLConfElement {
    public RelanceSQLElement() {
        super("RELANCE", "relance client", "relances clients");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("ID_CLIENT");
        l.add("ID_SAISIE_VENTE_FACTURE");
        l.add("DATE");
        l.add("ID_TYPE_LETTRE_RELANCE");
        l.add("MONTANT");
        l.add("INFOS");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            ElementComboBox comboFacture;
            ElementComboBox comboClient;
            ElementComboBox comboTypeLettre;
            JUniqueTextField textNumero;
            JCheckBox checkImpression;
            JCheckBox checkVisu;
            {
                this.comboFacture = new ElementComboBox();
                this.comboClient = new ElementComboBox();
                this.textNumero = new JUniqueTextField();
                this.checkImpression = new JCheckBox("Impression");
                this.checkVisu = new JCheckBox("Visualisation");
            }

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JLabel labelTypeLettre = new JLabel(this.getLabelFor("ID_TYPE_LETTRE_RELANCE"));
                labelTypeLettre.setHorizontalAlignment(4);
                this.add((Component)labelTypeLettre, c);
                ++c.gridx;
                this.comboTypeLettre = new ElementComboBox(false);
                this.add((Component)this.comboTypeLettre, c);
                ++c.gridx;
                JLabel labelDate = new JLabel(this.getLabelFor("DATE"));
                labelDate.setHorizontalAlignment(4);
                this.add((Component)labelDate, c);
                JDate date = new JDate(true);
                ++c.gridx;
                this.add((Component)date, c);
                c.gridx = 0;
                ++c.gridy;
                JLabel labelNumero = new JLabel(this.getLabelFor("NUMERO"));
                labelNumero.setHorizontalAlignment(4);
                this.add((Component)labelNumero, c);
                ++c.gridx;
                this.add((Component)this.textNumero, c);
                ++c.gridy;
                c.gridx = 0;
                JLabel labelClient = new JLabel(this.getLabelFor("ID_CLIENT"));
                labelClient.setHorizontalAlignment(4);
                this.add((Component)labelClient, c);
                ++c.gridx;
                c.gridwidth = 0;
                this.add((Component)this.comboClient, c);
                ++c.gridy;
                c.gridx = 0;
                c.gridwidth = 1;
                JLabel labelFacture = new JLabel(this.getLabelFor("ID_SAISIE_VENTE_FACTURE"));
                labelFacture.setHorizontalAlignment(4);
                this.add((Component)labelFacture, c);
                ++c.gridx;
                this.add((Component)this.comboFacture, c);
                ++c.gridx;
                JLabel labelMontant = new JLabel(this.getLabelFor("MONTANT"));
                labelMontant.setHorizontalAlignment(4);
                this.add((Component)labelMontant, c);
                ++c.gridx;
                DeviseField textMontant = new DeviseField();
                this.add((Component)textMontant, c);
                c.gridx = 0;
                ++c.gridy;
                this.add((Component)new JLabel(this.getLabelFor("INFOS")), c);
                ++c.gridx;
                c.gridwidth = 0;
                c.fill = 2;
                c.weightx = 1.0;
                this.add((Component)new JSeparator(0), c);
                c.gridx = 0;
                ++c.gridy;
                c.weighty = 1.0;
                c.fill = 1;
                ITextArea textInfos = new ITextArea();
                this.add((Component)textInfos, c);
                JPanel panelCheck = new JPanel();
                panelCheck.setBorder(null);
                panelCheck.add(this.checkVisu);
                panelCheck.add(this.checkImpression);
                c.fill = 0;
                c.weighty = 0.0;
                ++c.gridy;
                this.add((Component)panelCheck, c);
                this.addRequiredSQLObject(textMontant, "MONTANT");
                this.addRequiredSQLObject(date, "DATE");
                this.addRequiredSQLObject(this.comboTypeLettre, "ID_TYPE_LETTRE_RELANCE");
                this.addRequiredSQLObject(this.comboClient, "ID_CLIENT");
                this.addRequiredSQLObject(this.comboFacture, "ID_SAISIE_VENTE_FACTURE");
                this.addSQLObject(textInfos, "INFOS");
                this.addRequiredSQLObject(this.textNumero, "NUMERO");
                this.comboTypeLettre.setButtonsVisible(false);
                this.textNumero.setText(NumerotationAutoSQLElement.getNextNumero(RelanceSQLElement.class));
                this.checkVisu.setSelected(true);
            }

            @Override
            public int insert(SQLRow order) {
                if (this.textNumero.checkValidation()) {
                    if (NumerotationAutoSQLElement.getNextNumero(RelanceSQLElement.class).equalsIgnoreCase(this.textNumero.getText().trim())) {
                        SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
                        SQLRowValues rowVals = new SQLRowValues(tableNum);
                        int val = tableNum.getRow(2).getInt("RELANCE_START");
                        rowVals.put("RELANCE_START", (Object)(++val));
                        try {
                            rowVals.update(2);
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    int id = super.insert(order);
                    RelanceSheet s = new RelanceSheet(this.getTable().getRow(id));
                    String printer = PrinterNXProps.getInstance().getStringProperty("RelancePrinter");
                    s.generate(this.checkImpression.isSelected(), this.checkVisu.isSelected(), printer, true);
                    return id;
                }
                ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de relance existant.");
                Component root = SwingUtilities.getRoot(this);
                if (root instanceof EditFrame) {
                    EditFrame frame = (EditFrame)root;
                    frame.getPanel().setAlwaysVisible(true);
                }
                return this.getSelectedID();
            }

            @Override
            public void select(SQLRowAccessor r) {
                super.select(r);
                this.comboFacture.setInteractionMode(InteractionMode.DISABLED);
                this.comboClient.setInteractionMode(InteractionMode.DISABLED);
                this.fireValidChange();
            }

            @Override
            public void update() {
                if (!this.textNumero.checkValidation()) {
                    ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de relance existant.");
                    Component root = SwingUtilities.getRoot(this);
                    if (root instanceof EditFrame) {
                        EditFrame frame = (EditFrame)root;
                        frame.getPanel().setAlwaysVisible(true);
                    }
                    return;
                }
                super.update();
                RelanceSheet s = new RelanceSheet(this.getTable().getRow(this.getSelectedID()));
                String printer = PrinterNXProps.getInstance().getStringProperty("RelancePrinter");
                s.generate(this.checkImpression.isSelected(), this.checkVisu.isSelected(), printer);
            }
        };
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        for (SQLRow row : trees.getRows()) {
            if (row.getForeign("ID_ECHEANCE_CLIENT") == null || row.isForeignEmpty("ID_ECHEANCE_CLIENT")) continue;
            SQLRow rowEch = row.getForeign("ID_ECHEANCE_CLIENT");
            int count = rowEch.getInt("NOMBRE_RELANCE");
            count = Math.max(0, count - 1);
            SQLRowValues rowValsUp = rowEch.createEmptyUpdateRow();
            rowValsUp.put("NOMBRE_RELANCE", count);
            rowValsUp.put("DATE_LAST_RELANCE", null);
            if (count > 0) {
                Collection rows = rowEch.getReferentRows(row.getTable());
                Calendar cal = null;
                for (SQLRow sqlRow : rows) {
                    if (sqlRow.getID() == row.getID() || sqlRow.getDate("DATE") == null || cal != null && !cal.before(sqlRow.getDate("DATE"))) continue;
                    cal = sqlRow.getDate("DATE");
                }
                if (cal != null) {
                    rowValsUp.put("DATE_LAST_RELANCE", cal.getTime());
                }
            }
            rowValsUp.commit();
        }
        super.archive(trees, cutLinks);
    }

    @Override
    protected String createCode() {
        return String.valueOf(super.createCodeFromPackage()) + ".chaseletter";
    }
}

