/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.element;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableControlPanel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.RowValuesTableRenderer;
import org.openconcerto.sql.view.list.SQLTableElement;

public class ContactItemTable
extends JPanel {
    private RowValuesTable table;
    final RowValuesTableControlPanel comp;

    public ContactItemTable(SQLRowValues defaultRow) {
        this(defaultRow, Configuration.getInstance().getDirectory().getElement(defaultRow.getTable()));
    }

    private ContactItemTable(SQLRowValues defaultRow, SQLElement elt) {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        SQLTableElement tableElementTitre = new SQLTableElement(elt.getTable().getField("ID_TITRE_PERSONNEL"));
        list.add(tableElementTitre);
        SQLTableElement tableElementNom = new SQLTableElement(elt.getTable().getField("NOM"));
        list.add(tableElementNom);
        SQLTableElement tableElementPrenom = new SQLTableElement(elt.getTable().getField("PRENOM"));
        list.add(tableElementPrenom);
        SQLTableElement tableElementFonction = new SQLTableElement(elt.getTable().getField("FONCTION"));
        list.add(tableElementFonction);
        if (elt.getTable().contains("SERVICE")) {
            SQLTableElement tableElementService = new SQLTableElement(elt.getTable().getField("SERVICE"));
            list.add(tableElementService);
        }
        SQLTableElement tableElementTel = new SQLTableElement(elt.getTable().getField("TEL_DIRECT"));
        list.add(tableElementTel);
        SQLTableElement tableElementFax = new SQLTableElement(elt.getTable().getField("FAX"));
        list.add(tableElementFax);
        SQLTableElement tableElementTelP = new SQLTableElement(elt.getTable().getField("TEL_MOBILE"));
        list.add(tableElementTelP);
        SQLTableElement tableElementMail = new SQLTableElement(elt.getTable().getField("EMAIL"));
        list.add(tableElementMail);
        if (elt.getTable().contains("TYPE")) {
            SQLTableElement tableElementType = new SQLTableElement(elt.getTable().getField("TYPE"));
            list.add(tableElementType);
        }
        if (elt.getTable().contains("PAYS")) {
            SQLTableElement tableElementPays = new SQLTableElement(elt.getTable().getField("PAYS"));
            list.add(tableElementPays);
        }
        if (elt.getTable().contains("ENVOI_RAPPORT_MAIL")) {
            SQLTableElement tableElementEnvoiMail = new SQLTableElement(elt.getTable().getField("ENVOI_RAPPORT_MAIL"));
            list.add(tableElementEnvoiMail);
        }
        if (elt.getTable().contains("NO_MAILING")) {
            SQLTableElement tableElementNoMailing = new SQLTableElement(elt.getTable().getField("NO_MAILING"));
            list.add(tableElementNoMailing);
        }
        RowValuesTableModel model = new RowValuesTableModel(elt, list, elt.getTable().getField("NOM"), false, defaultRow);
        this.table = new RowValuesTable(model, new File(Configuration.getInstance().getConfDir(), "Table" + File.separator + "Table_Contact.xml"));
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        this.comp = new RowValuesTableControlPanel(this.table);
        this.add((Component)this.comp, c);
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)new JScrollPane(this.table), c);
        this.table.setDefaultRenderer(Long.class, new RowValuesTableRenderer());
    }

    public void updateField(String field, int id) {
        this.table.updateField(field, id);
    }

    public void insertFrom(String field, SQLRowValues row) {
        this.table.insertFrom(field, row);
    }

    public void insertFrom(String field, int id) {
        this.table.insertFrom(field, id);
    }

    public RowValuesTableModel getModel() {
        return this.table.getRowValuesTableModel();
    }

    public void setEditable(boolean b) {
        this.comp.setEditable(b);
        this.table.setEditable(b);
    }
}

