/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.List;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.panel.ODSViewerPanel;
import org.jopendocument.print.DefaultXMLDocumentPrinter;
import org.jopendocument.print.DocumentPrinter;
import org.openconcerto.erp.generationDoc.A4;
import org.openconcerto.erp.generationDoc.DefaultNXDocumentPrinter;
import org.openconcerto.utils.ExceptionHandler;

public class PreviewFrame
extends JFrame {
    private PreviewFrame(OpenDocument doc, String title) {
        super(title);
        this.setContentPane((Container)new ODSViewerPanel(doc, (DocumentPrinter)this.createDocumentPrinter()));
        this.init();
    }

    public PreviewFrame(String title, String url, String odspXml) {
        this.setContentPane((Container)new ODSViewerPanel(url, odspXml, (DocumentPrinter)this.createDocumentPrinter(), true));
        this.setTitle(title);
        this.init();
    }

    public DefaultXMLDocumentPrinter createDocumentPrinter() {
        return new DefaultXMLDocumentPrinter(){

            public void print(final List<OpenDocument> documents) {
                double POINTS_PER_INCH = 72.0;
                final PrinterJob printJob = PrinterJob.getPrinterJob();
                HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
                MediaSizeName media = MediaSizeName.ISO_A4;
                attributes.add(media);
                A4 paper = new A4(0.0f, 0.0f);
                MediaPrintableArea printableArea = new MediaPrintableArea((float)(paper.getImageableX() / 72.0), (float)(paper.getImageableY() / 72.0), (float)(paper.getImageableWidth() / 72.0), (float)(paper.getImageableHeight() / 72.0), 25400);
                attributes.add(printableArea);
                attributes.add(new Copies(2));
                boolean okToPrint = printJob.printDialog(attributes);
                Attribute attribute = attributes.get(Copies.class);
                if (attribute != null) {
                    Copies attributeCopies = (Copies)attribute;
                    int value = attributeCopies.getValue();
                    printJob.setCopies(value);
                } else {
                    printJob.setCopies(1);
                }
                if (okToPrint) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                DefaultNXDocumentPrinter printer = new DefaultNXDocumentPrinter();
                                printer.print(documents, printJob);
                            }
                            catch (Exception e) {
                                ExceptionHandler.handle("Print error", e);
                            }
                        }
                    });
                    t.setName("PreviewFrame Print Thread");
                    t.setDaemon(true);
                    t.start();
                }
            }
        };
    }

    private void init() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.setMaximizedBounds(ge.getMaximumWindowBounds());
        Dimension maxD = ge.getMaximumWindowBounds().getSize();
        this.setMaximumSize(maxD);
        this.pack();
        Dimension d = this.getSize();
        if (d.width > maxD.width) {
            d.setSize(maxD.width, d.height);
        }
        if (d.height > maxD.height) {
            d.setSize(d.width, maxD.height);
        }
        this.setSize(d);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
    }

    public static void show(File file) {
        final OpenDocument doc = new OpenDocument(file);
        final String title = file.getName();
        if (SwingUtilities.isEventDispatchThread()) {
            new PreviewFrame(doc, title).setVisible(true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new PreviewFrame(doc, title, null).setVisible(true);
                }
            });
        }
    }

    /* synthetic */ PreviewFrame(OpenDocument openDocument, String string, PreviewFrame previewFrame) {
        this(openDocument, string);
    }
}

