/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil;

import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

class MimeTypeHashSet
implements Set,
Collection {
    private Set hashSet = new LinkedHashSet();

    MimeTypeHashSet() {
    }

    MimeTypeHashSet(Collection collection) {
        this.addAll(collection);
    }

    MimeTypeHashSet(int initialCapacity) {
        this.hashSet = new HashSet(initialCapacity);
    }

    MimeTypeHashSet(int initialCapacity, float loadFactor) {
        this.hashSet = new HashSet(initialCapacity, loadFactor);
    }

    MimeTypeHashSet(String arg0) {
        this.add(arg0);
    }

    MimeTypeHashSet(String[] arg0) {
        this.add(arg0);
    }

    MimeTypeHashSet(MimeType mimeType) {
        this.add(mimeType);
    }

    public boolean add(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (arg0 instanceof MimeType) {
            if (this.contains(arg0)) {
                this.updateSpecificity((MimeType)arg0);
            }
            MimeUtil.addKnownMimeType((MimeType)arg0);
            return this.hashSet.add(arg0);
        }
        if (arg0 instanceof Collection) {
            return this.addAll((Collection)arg0);
        }
        if (arg0 instanceof String) {
            String[] mimeTypes = ((String)arg0).split(",");
            boolean added = false;
            int i = 0;
            while (i < mimeTypes.length) {
                try {
                    if (this.add(new MimeType(mimeTypes[i]))) {
                        added = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            return added;
        }
        if (arg0 instanceof String[]) {
            boolean added = false;
            String[] mimeTypes = (String[])arg0;
            int i = 0;
            while (i < mimeTypes.length) {
                String[] parts = mimeTypes[i].split(",");
                int j = 0;
                while (j < parts.length) {
                    try {
                        if (this.add(new MimeType(parts[j]))) {
                            added = true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++j;
                }
                ++i;
            }
            return added;
        }
        return false;
    }

    public boolean addAll(Collection arg0) throws NullPointerException {
        if (arg0 == null) {
            throw new NullPointerException();
        }
        boolean added = false;
        Iterator it = arg0.iterator();
        while (it.hasNext()) {
            try {
                if (!this.add(it.next())) continue;
                added = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return added;
    }

    @Override
    public void clear() {
        this.hashSet.clear();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof MimeType) {
            return this.hashSet.contains(o);
        }
        if (o instanceof Collection) {
            return this.containsAll((Collection)o);
        }
        if (o instanceof String) {
            String[] parts = ((String)o).split(",");
            int i = 0;
            while (i < parts.length) {
                if (!this.contains(new MimeType(parts[i]))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (o instanceof String[]) {
            String[] mimeTypes = (String[])o;
            int i = 0;
            while (i < mimeTypes.length) {
                String[] parts = mimeTypes[i].split(",");
                int j = 0;
                while (j < parts.length) {
                    if (!this.contains(new MimeType(parts[j]))) {
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection arg0) {
        if (arg0 == null) {
            throw new NullPointerException();
        }
        Iterator it = arg0.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.hashSet.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return this.hashSet.iterator();
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = false;
        if (o == null) {
            return removed;
        }
        if (o instanceof MimeType) {
            return this.hashSet.remove(o);
        }
        if (o instanceof String) {
            String[] parts = ((String)o).split(",");
            int i = 0;
            while (i < parts.length) {
                if (this.remove(new MimeType(parts[i]))) {
                    removed = true;
                }
                ++i;
            }
        } else if (o instanceof String[]) {
            String[] mimeTypes = (String[])o;
            int i = 0;
            while (i < mimeTypes.length) {
                String[] parts = mimeTypes[i].split(",");
                int j = 0;
                while (j < parts.length) {
                    if (this.remove(new MimeType(parts[j]))) {
                        removed = true;
                    }
                    ++j;
                }
                ++i;
            }
        } else if (o instanceof Collection) {
            return this.removeAll((Collection)o);
        }
        return removed;
    }

    public boolean removeAll(Collection arg0) {
        if (arg0 == null) {
            throw new NullPointerException();
        }
        boolean removed = false;
        Iterator it = arg0.iterator();
        while (it.hasNext()) {
            if (!this.remove(it.next())) continue;
            removed = true;
        }
        return removed;
    }

    public boolean retainAll(Collection arg0) {
        if (arg0 == null) {
            throw new NullPointerException();
        }
        MimeTypeHashSet c = new MimeTypeHashSet(arg0);
        return this.hashSet.retainAll(c);
    }

    @Override
    public int size() {
        return this.hashSet.size();
    }

    @Override
    public Object[] toArray() {
        return this.hashSet.toArray();
    }

    public Object[] toArray(Object[] arg0) {
        return this.hashSet.toArray(arg0);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            buf.append(((MimeType)it.next()).toString());
            if (!it.hasNext()) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        MimeTypeHashSet c = new MimeTypeHashSet();
        c.add(o);
        return this.match(c);
    }

    private boolean match(Collection c) {
        if (this.size() != c.size()) {
            return false;
        }
        MimeType[] mt = c.toArray(new MimeType[c.size()]);
        int i = 0;
        while (i < mt.length) {
            if (!this.contains(mt[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void updateSpecificity(MimeType o) {
        MimeType mimeType = this.get(o);
        int specificity = mimeType.getSpecificity() + o.getSpecificity();
        mimeType.setSpecificity(specificity);
        o.setSpecificity(specificity);
    }

    private MimeType get(MimeType mimeType) {
        for (MimeType mt : this.hashSet) {
            if (!mt.equals(mimeType)) continue;
            return mt;
        }
        return null;
    }

    public Collection matches(String pattern) {
        MimeTypeHashSet c = new MimeTypeHashSet();
        for (MimeType mimeType : this) {
            if (!mimeType.toString().matches(pattern)) continue;
            c.add(mimeType);
        }
        return c;
    }
}

