/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.model;

import java.util.Collection;
import java.util.Collections;
import javax.swing.event.ListDataListener;
import org.openconcerto.utils.change.CollectionChangeEventCreator;
import org.openconcerto.utils.change.ConstructorCreator;
import org.openconcerto.utils.change.IListDataEvent;
import org.openconcerto.utils.model.DefaultIListModel;
import org.openconcerto.utils.model.IMutableListModel;
import org.openconcerto.utils.model.NewSelection;

public class DefaultIMutableListModel<T>
extends DefaultIListModel<T>
implements IMutableListModel<T> {
    private Object selectedObject;
    private boolean selectionIsT;
    private boolean selectOnAdd = true;
    private NewSelection selectOnRm;
    private NewSelection selectOnReplace;

    public DefaultIMutableListModel(Collection<? extends T> v) {
        super(v);
        this.setOnRemovingOrReplacingSelection(null);
        this.selectedObject = this.getSize() > 0 && this.isSelectOnAdd() ? this.getElementAt(0) : null;
        this.selectionIsT = true;
    }

    public final void setSelectedItem(Object anObject) {
        this.setSelectedItem(anObject, false);
    }

    private final boolean setSelectedItem(Object anObject, boolean isT) {
        if (this.selectedObject != null && !this.selectedObject.equals(anObject) || this.selectedObject == null && anObject != null) {
            this.selectedObject = anObject;
            this.selectionIsT = isT || anObject == null;
            this.fireContentsChanged(this, -1, -1);
            return true;
        }
        return false;
    }

    public void setSelectedObject(T anObject) {
        this.setSelectedItem(anObject, true);
    }

    public final Object getSelectedItem() {
        return this.selectedObject;
    }

    public final boolean hasSelection() {
        return this.getSelectedItem() != null;
    }

    protected final int getSelectionIndex() {
        return this.objects.indexOf(this.getSelectedItem());
    }

    public final void addElement(T anObject) {
        this.addAll(Collections.singleton(anObject));
    }

    public void addAll(Collection<? extends T> items) {
        this.addAll(-1, items);
    }

    public void addAll(int index, Collection<? extends T> items) {
        this.addAll(index, items, true);
    }

    public void addAll(int index, Collection<? extends T> items, boolean setSelection) {
        if (items.size() > 0) {
            int size = this.objects.size();
            if (index < 0) {
                index = size;
                this.objects.addAll(items);
            } else {
                this.objects.addAll(index, items);
            }
            this.fireIntervalAdded(this, index, index + items.size() - 1);
            if (setSelection && this.isSelectOnAdd() && size == 0 && !this.hasSelection()) {
                this.setSelectedObject(items.iterator().next());
            }
        }
    }

    public void insertElementAt(T anObject, int index) {
        this.objects.add(index, anObject);
        this.fireIntervalAdded(this, index, index);
    }

    public void removeElementAt(int index) {
        this.removeElementsAt(index, index);
    }

    public void removeElementsAt(int from, int to) {
        ConstructorCreator c = this.createCreator();
        int selectedIndex = this.getSelectionIndex();
        NewSelection onRm = this.getOnRemovingSelection();
        if (selectedIndex >= from && selectedIndex <= to && onRm != NewSelection.NO) {
            this.setSelectedObject(onRm.getNewSelection(this, selectedIndex, from, to, Collections.emptyList()));
        }
        this.objects.subList(from, to + 1).clear();
        this.fireIntervalRemoved(from, to, c);
    }

    protected final void removeForJRE(Object anObject) {
        int index = this.objects.indexOf(anObject);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    private ConstructorCreator createCreator() {
        return new ConstructorCreator(this, "items", this.objects);
    }

    protected void fireIntervalRemoved(int index0, int index1, CollectionChangeEventCreator c) {
        this.fire(2, index0, index1, c);
    }

    protected void fire(int type, int index0, int index1, CollectionChangeEventCreator c) {
        Object[] listeners = this.listenerList.getListenerList();
        IListDataEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ListDataListener.class) {
                if (e == null) {
                    e = c.create(this.objects, type, index0, index1);
                }
                switch (type) {
                    case 2: {
                        ((ListDataListener)listeners[i + 1]).intervalRemoved(e);
                        break;
                    }
                    case 0: {
                        ((ListDataListener)listeners[i + 1]).contentsChanged(e);
                        break;
                    }
                    case 1: {
                        ((ListDataListener)listeners[i + 1]).intervalAdded(e);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("wrong type: " + type);
                    }
                }
            }
            i -= 2;
        }
    }

    public final boolean isSelectOnAdd() {
        return this.selectOnAdd;
    }

    public final void setSelectOnAdd(boolean selectOnAdd) {
        this.selectOnAdd = selectOnAdd;
    }

    public final NewSelection getOnRemovingSelection() {
        return this.selectOnRm;
    }

    public final void setOnRemovingOrReplacingSelection(NewSelection newSel) {
        if (newSel == null) {
            this.setOnRemovingSelection(NewSelection.DIFFERENT_INDEX);
            this.setOnReplacingSelection(NewSelection.NONE);
        } else {
            this.setOnRemovingSelection(newSel);
            this.setOnReplacingSelection(newSel);
        }
    }

    public final void setOnRemovingSelection(NewSelection selectOnRm) {
        if (selectOnRm == null) {
            throw new NullPointerException();
        }
        this.selectOnRm = selectOnRm;
    }

    public final void setOnReplacingSelection(NewSelection newSel) {
        if (newSel == null) {
            throw new NullPointerException();
        }
        this.selectOnReplace = newSel;
    }
}

